/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.kit;

import java.util.List;
import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UtilKit {
    private final Player player;
    private final Essence plugin;

    public UtilKit(Essence plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public int giveKit(String kit) {
        Files kitData = new Files(this.plugin.foundryConfig, this.plugin);
        kitData.load("data/kits.yml");
        if (kitData.get("kits." + kit) == null) {
            return 2;
        }
        UtilPermission perm = new UtilPermission(this.plugin, (CommandSender)this.player);
        if (kitData.get("kits." + kit + ".permission") != null && !perm.has(kitData.get("kits." + kit + ".permission").toString())) {
            return 1;
        }
        Object max = kitData.get("kits." + kit + ".maxclaims");
        Files playerData = new Files(this.plugin.foundryConfig, this.plugin);
        playerData.load(playerData.playerDataFile(this.player));
        Object claims = playerData.get("kits." + kit + ".claims");
        if (claims == null || (Integer)claims < 0) {
            playerData.set("kits." + kit + ".claims", 0);
        }
        if (max != null && (Integer)max != -1 && !perm.has("essence.bypass.maxkitclaims") && playerData.getInt("kits." + kit + ".claims") >= (Integer)max) {
            playerData.save();
            playerData.close();
            return 3;
        }
        playerData.set("kits." + kit + ".claims", playerData.getInt("kits." + kit + ".claims") + 1);
        playerData.save();
        List<String> items = kitData.getStringList("kits." + kit + ".items");
        for (String object : items) {
            this.player.getInventory().addItem(new ItemStack[]{new ItemStack(Objects.requireNonNull(Material.getMaterial((String)object)))});
        }
        kitData.close();
        return 0;
    }
}

