/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.external;

import java.util.Objects;
import java.util.regex.Pattern;
import net.lewmc.essence.external.FoundryConfig;
import net.lewmc.essence.external.Logger;

public class Security {
    private final FoundryConfig config;

    public Security(FoundryConfig config) {
        this.config = config;
    }

    public boolean hasSpecialCharacters(String string) {
        return Pattern.compile("[^a-z0-9 ]", 2).matcher(string).find();
    }

    public void startWatchdog() {
        Logger log = new Logger(this.config);
        String plugin = this.config.pluginId.toUpperCase();
        if (Objects.equals(System.getProperty("FOUNDRY_WATCHDOG_" + plugin, ""), "ACTIVE")) {
            log.severe("");
            log.severe("WARNING: RELOAD DETECTED!");
            log.severe("");
            log.severe("This may cause issues with " + plugin + ", other plugins, and your server overall.");
            log.severe("These issues include breaking permissions and other crashing exceptions.");
            log.severe("If you are reloading datapacks use /minecraft:reload instead.");
            log.severe("");
            log.severe("WE HIGHLY RECOMMEND RESTARTING YOUR SERVER.");
            log.severe("");
            log.severe("We will not provide support for any issues when plugin reloaders are used.");
            log.severe("");
            log.severe("More info: https://madelinemiller.dev/blog/problem-with-reload");
            log.severe("");
        }
        log.info("Watchdog started for " + plugin + ".");
        System.setProperty("FOUNDRY_WATCHDOG_" + plugin, "ACTIVE");
    }

    public void stopWatchdog() {
        System.setProperty("FOUNDRY_WATCHDOG_" + this.config.pluginId.toUpperCase(), "INACTIVE");
    }
}

