/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.economy;

import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.command.FoundryCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandEco
extends FoundryCommand {
    private final Essence plugin;

    public CommandEco(Essence plugin) {
        this.plugin = plugin;
    }

    @Override
    protected String requiredPermission() {
        return "essence.economy.admin";
    }

    @Override
    protected boolean onRun(CommandSender cs, Command command, String s, String[] args) {
        String subCommand;
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (args.length == 0) {
            this.showUsage(message);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                return this.handleSetCommand(args, message);
            }
            case "give": {
                return this.handleGiveCommand(args, message);
            }
            case "take": {
                return this.handleTakeCommand(args, message);
            }
            case "help": {
                this.showUsage(message);
                return true;
            }
        }
        message.send("generic", "invalidcommand");
        this.showUsage(message);
        return true;
    }

    private boolean handleSetCommand(String[] args, UtilMessage message) {
        if (args.length != 3) {
            message.send("economy", "ecosetusage");
            return true;
        }
        Double amount = this.validateAmount(args[2], message, true);
        if (amount == null) {
            return true;
        }
        Player targetPlayer = this.findPlayer(args[1], message);
        if (targetPlayer == null) {
            return true;
        }
        if (new UtilPlayer(this.plugin).setPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE, amount)) {
            String symbol = this.plugin.config.get("economy.symbol").toString();
            message.send("economy", "ecoset", new String[]{targetPlayer.getName(), symbol + amount});
            return true;
        }
        message.send("generic", "exception");
        this.plugin.log.warn("Unable to update player balance: player " + targetPlayer.getName() + " may be null");
        return false;
    }

    private boolean handleGiveCommand(String[] args, UtilMessage message) {
        if (args.length != 3) {
            message.send("economy", "ecogiveusage");
            return true;
        }
        Double amount = this.validateAmount(args[2], message, false);
        if (amount == null) {
            return true;
        }
        Player targetPlayer = this.findPlayer(args[1], message);
        if (targetPlayer == null) {
            return true;
        }
        UtilPlayer up = new UtilPlayer(this.plugin);
        if (up.setPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE, (Double)up.getPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE) + amount)) {
            String symbol = this.plugin.config.get("economy.symbol").toString();
            message.send("economy", "ecogive", new String[]{symbol + amount, targetPlayer.getName()});
            return true;
        }
        message.send("generic", "exception");
        this.plugin.log.warn("Unable to update player balance: player " + targetPlayer.getName() + " may be null");
        return false;
    }

    private boolean handleTakeCommand(String[] args, UtilMessage message) {
        if (args.length != 3) {
            message.send("economy", "ecotakeusage");
            return true;
        }
        Double amount = this.validateAmount(args[2], message, false);
        if (amount == null) {
            return true;
        }
        Player targetPlayer = this.findPlayer(args[1], message);
        if (targetPlayer == null) {
            return true;
        }
        UtilPlayer up = new UtilPlayer(this.plugin);
        if ((Double)up.getPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE) < amount) {
            message.send("economy", "insufficientfunds");
            return true;
        }
        if (up.setPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE, (Double)up.getPlayer(targetPlayer.getUniqueId(), UtilPlayer.KEYS.ECONOMY_BALANCE) - amount)) {
            String symbol = this.plugin.config.get("economy.symbol").toString();
            message.send("economy", "ecotake", new String[]{symbol + amount, targetPlayer.getName()});
            return true;
        }
        message.send("generic", "exception");
        this.plugin.log.warn("Unable to update player balance: player " + targetPlayer.getName() + " may be null");
        return false;
    }

    private Double validateAmount(String amountStr, UtilMessage message, boolean allowZero) {
        double amount;
        try {
            amount = Double.parseDouble(amountStr);
        }
        catch (NumberFormatException e) {
            message.send("economy", "invalidamount");
            return null;
        }
        if (allowZero && amount < 0.0) {
            message.send("economy", "negativeamount");
            return null;
        }
        if (!allowZero && amount <= 0.0) {
            message.send("economy", "positiveamount");
            return null;
        }
        return amount;
    }

    private Player findPlayer(String playerName, UtilMessage message) {
        Player targetPlayer = Bukkit.getPlayer((String)playerName);
        if (targetPlayer == null) {
            message.send("generic", "playernotfound");
            return null;
        }
        return targetPlayer;
    }

    private void showUsage(UtilMessage message) {
        message.send("economy", "ecousage");
    }
}

