/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.TypePlayer;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.external.Files;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class UtilPlayer {
    private final Essence plugin;

    public UtilPlayer(Essence plugin) {
        this.plugin = plugin;
    }

    public boolean setPlayer(UUID uuid, KEYS key, Object value) {
        if (this.plugin.players.containsKey(uuid)) {
            TypePlayer player = (TypePlayer)this.plugin.players.get(uuid);
            if (this.plugin.verbose) {
                this.plugin.log.info("DataCache > " + String.valueOf(uuid) + " > " + String.valueOf((Object)key) + " > " + String.valueOf(value));
            }
            Object object = value;
            int n = 0;
            block24: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class, String.class, String.class, String.class, String.class, List.class, Boolean.class, Double.class, Boolean.class, String.class, Double.class, Double.class, Double.class, Float.class, Float.class, String.class, Double.class, Double.class, Double.class, Float.class, Float.class}, (Object)object, n)) {
                    case 0: {
                        Boolean b = (Boolean)object;
                        if (key != KEYS.USER_ACCEPTING_TELEPORT_REQUESTS) {
                            n = 1;
                            continue block24;
                        }
                        player.user.acceptingTeleportRequests = b;
                        break block24;
                    }
                    case 1: {
                        String s = (String)object;
                        if (key != KEYS.USER_LAST_SEEN) {
                            n = 2;
                            continue block24;
                        }
                        player.user.lastSeen = s;
                        break block24;
                    }
                    case 2: {
                        String s = (String)object;
                        if (key != KEYS.USER_LAST_KNOWN_NAME) {
                            n = 3;
                            continue block24;
                        }
                        player.user.lastKnownName = s;
                        break block24;
                    }
                    case 3: {
                        String s = (String)object;
                        if (key != KEYS.USER_NICKNAME) {
                            n = 4;
                            continue block24;
                        }
                        player.user.nickname = s;
                        break block24;
                    }
                    case 4: {
                        String s = (String)object;
                        if (key != KEYS.USER_TEAM) {
                            n = 5;
                            continue block24;
                        }
                        player.user.team = s;
                        break block24;
                    }
                    case 5: {
                        String s = (String)object;
                        if (key != KEYS.USER_IP_ADDRESS) {
                            n = 6;
                            continue block24;
                        }
                        player.user.ipAddress = s;
                        break block24;
                    }
                    case 6: {
                        List objects = (List)object;
                        if (key != KEYS.USER_IGNORING_PLAYERS) {
                            n = 7;
                            continue block24;
                        }
                        if (objects.stream().allMatch(o -> o instanceof String)) {
                            player.user.ignoringPlayers = objects;
                            break block24;
                        }
                        return false;
                    }
                    case 7: {
                        Boolean v = (Boolean)object;
                        if (key != KEYS.USER_CONFIRM_CLEAR) {
                            n = 8;
                            continue block24;
                        }
                        player.user.confirmClear = v;
                        break block24;
                    }
                    case 8: {
                        Double v = (Double)object;
                        if (key != KEYS.ECONOMY_BALANCE) {
                            n = 9;
                            continue block24;
                        }
                        player.economy.balance = v;
                        break block24;
                    }
                    case 9: {
                        Boolean b = (Boolean)object;
                        if (key != KEYS.ECONOMY_ACCEPTING_PAYMENTS) {
                            n = 10;
                            continue block24;
                        }
                        player.economy.acceptingPayments = b;
                        break block24;
                    }
                    case 10: {
                        String s = (String)object;
                        if (key != KEYS.LAST_LOCATION_WORLD) {
                            n = 11;
                            continue block24;
                        }
                        player.lastLocation.world = s;
                        break block24;
                    }
                    case 11: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_LOCATION_X) {
                            n = 12;
                            continue block24;
                        }
                        player.lastLocation.x = v;
                        break block24;
                    }
                    case 12: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_LOCATION_Y) {
                            n = 13;
                            continue block24;
                        }
                        player.lastLocation.y = v;
                        break block24;
                    }
                    case 13: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_LOCATION_Z) {
                            n = 14;
                            continue block24;
                        }
                        player.lastLocation.z = v;
                        break block24;
                    }
                    case 14: {
                        Float v = (Float)object;
                        if (key != KEYS.LAST_LOCATION_YAW) {
                            n = 15;
                            continue block24;
                        }
                        player.lastLocation.yaw = v.floatValue();
                        break block24;
                    }
                    case 15: {
                        Float v = (Float)object;
                        if (key != KEYS.LAST_LOCATION_PITCH) {
                            n = 16;
                            continue block24;
                        }
                        player.lastLocation.pitch = v.floatValue();
                        break block24;
                    }
                    case 16: {
                        String s = (String)object;
                        if (key != KEYS.LAST_SLEEP_WORLD) {
                            n = 17;
                            continue block24;
                        }
                        player.lastSleep.world = s;
                        break block24;
                    }
                    case 17: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_SLEEP_X) {
                            n = 18;
                            continue block24;
                        }
                        player.lastSleep.x = v;
                        break block24;
                    }
                    case 18: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_SLEEP_Y) {
                            n = 19;
                            continue block24;
                        }
                        player.lastSleep.y = v;
                        break block24;
                    }
                    case 19: {
                        Double v = (Double)object;
                        if (key != KEYS.LAST_SLEEP_Z) {
                            n = 20;
                            continue block24;
                        }
                        player.lastSleep.z = v;
                        break block24;
                    }
                    case 20: {
                        Float v = (Float)object;
                        if (key != KEYS.LAST_SLEEP_YAW) {
                            n = 21;
                            continue block24;
                        }
                        player.lastSleep.yaw = v.floatValue();
                        break block24;
                    }
                    case 21: {
                        Float v = (Float)object;
                        if (key != KEYS.LAST_SLEEP_PITCH) {
                            n = 22;
                            continue block24;
                        }
                        player.lastSleep.pitch = v.floatValue();
                        break block24;
                    }
                    default: {
                        return false;
                    }
                }
                break;
            }
            this.plugin.players.put(uuid, player);
            return true;
        }
        return false;
    }

    public Object getPlayer(UUID uuid, KEYS key) {
        if (this.plugin.players.containsKey(uuid)) {
            TypePlayer player = (TypePlayer)this.plugin.players.get(uuid);
            return switch (key.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> player.user.acceptingTeleportRequests;
                case 1 -> player.user.lastSeen;
                case 2 -> player.user.lastKnownName;
                case 3 -> player.user.nickname;
                case 4 -> player.user.ipAddress;
                case 5 -> player.user.ignoringPlayers;
                case 7 -> player.user.confirmClear;
                case 6 -> player.user.team;
                case 8 -> player.economy.balance;
                case 9 -> player.economy.acceptingPayments;
                case 10 -> player.lastLocation.world;
                case 11 -> player.lastLocation.x;
                case 12 -> player.lastLocation.y;
                case 13 -> player.lastLocation.z;
                case 14 -> Float.valueOf(player.lastLocation.yaw);
                case 15 -> Float.valueOf(player.lastLocation.pitch);
                case 16 -> player.lastSleep.world;
                case 17 -> player.lastSleep.x;
                case 18 -> player.lastSleep.y;
                case 19 -> player.lastSleep.z;
                case 20 -> Float.valueOf(player.lastSleep.yaw);
                case 21 -> Float.valueOf(player.lastSleep.pitch);
            };
        }
        return null;
    }

    public boolean loadPlayer(UUID uuid) {
        Files f = new Files(this.plugin.foundryConfig, this.plugin);
        if (f.exists(f.playerDataFile(uuid))) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || p.getPlayer() == null) {
                return false;
            }
            f.load(f.playerDataFile(uuid));
            this.migratePlayerFile(f);
            TypePlayer player = new TypePlayer();
            player.user.acceptingTeleportRequests = f.get(KEYS.USER_ACCEPTING_TELEPORT_REQUESTS.toString()) != null ? f.getBoolean(KEYS.USER_ACCEPTING_TELEPORT_REQUESTS.toString()) : true;
            player.user.lastSeen = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            player.user.lastKnownName = p.getName();
            player.user.nickname = f.getString(KEYS.USER_NICKNAME.toString());
            player.user.team = f.getString(KEYS.USER_TEAM.toString());
            if (((Boolean)this.plugin.config.get("advanced.playerdata.store-ip-address")).booleanValue()) {
                Player onlinePlayer = p.getPlayer();
                if (onlinePlayer != null && onlinePlayer.getAddress() != null) {
                    f.set(KEYS.USER_IP_ADDRESS.toString(), onlinePlayer.getAddress().getAddress().getHostAddress());
                }
            } else {
                f.set(KEYS.USER_IP_ADDRESS.toString(), null);
            }
            if (f.get(KEYS.USER_IGNORING_PLAYERS.toString()) != null) {
                player.user.ignoringPlayers = f.getStringList(KEYS.USER_IGNORING_PLAYERS.toString());
            }
            player.user.confirmClear = f.get(KEYS.USER_CONFIRM_CLEAR.toString()) != null ? f.getBoolean(KEYS.USER_CONFIRM_CLEAR.toString()) : true;
            player.economy.balance = f.get(KEYS.ECONOMY_BALANCE.toString()) != null ? f.getDouble(KEYS.ECONOMY_BALANCE.toString()) : 0.0;
            player.economy.acceptingPayments = f.get(KEYS.ECONOMY_ACCEPTING_PAYMENTS.toString()) != null ? f.getBoolean(KEYS.ECONOMY_ACCEPTING_PAYMENTS.toString()) : true;
            player.lastLocation.world = f.getString(KEYS.LAST_LOCATION_WORLD.toString());
            player.lastLocation.x = f.get(KEYS.LAST_LOCATION_X.toString()) != null ? f.getDouble(KEYS.LAST_LOCATION_X.toString()) : 0.0;
            player.lastLocation.y = f.get(KEYS.LAST_LOCATION_Y.toString()) != null ? f.getDouble(KEYS.LAST_LOCATION_Y.toString()) : 0.0;
            player.lastLocation.z = f.get(KEYS.LAST_LOCATION_Z.toString()) != null ? f.getDouble(KEYS.LAST_LOCATION_Z.toString()) : 0.0;
            player.lastLocation.yaw = f.get(KEYS.LAST_LOCATION_YAW.toString()) != null ? (float)f.getDouble(KEYS.LAST_LOCATION_YAW.toString()) : 0.0f;
            player.lastLocation.pitch = f.get(KEYS.LAST_LOCATION_PITCH.toString()) != null ? (float)f.getDouble(KEYS.LAST_LOCATION_PITCH.toString()) : 0.0f;
            player.lastSleep.world = f.getString(KEYS.LAST_SLEEP_WORLD.toString());
            player.lastSleep.x = f.get(KEYS.LAST_SLEEP_X.toString()) != null ? f.getDouble(KEYS.LAST_SLEEP_X.toString()) : 0.0;
            player.lastSleep.y = f.get(KEYS.LAST_SLEEP_Y.toString()) != null ? f.getDouble(KEYS.LAST_SLEEP_Y.toString()) : 0.0;
            player.lastSleep.z = f.get(KEYS.LAST_SLEEP_Z.toString()) != null ? f.getDouble(KEYS.LAST_SLEEP_Z.toString()) : 0.0;
            player.lastSleep.yaw = f.get(KEYS.LAST_SLEEP_YAW.toString()) != null ? (float)f.getDouble(KEYS.LAST_SLEEP_YAW.toString()) : 0.0f;
            player.lastSleep.pitch = f.get(KEYS.LAST_SLEEP_PITCH.toString()) != null ? (float)f.getDouble(KEYS.LAST_SLEEP_PITCH.toString()) : 0.0f;
            this.plugin.players.put(uuid, player);
            if (this.plugin.verbose) {
                this.plugin.log.info("DataCache > " + String.valueOf(uuid) + " loaded into memory.");
            }
            return true;
        }
        return false;
    }

    public boolean savePlayer(UUID uuid) {
        Files f = new Files(this.plugin.foundryConfig, this.plugin);
        if (f.exists(f.playerDataFile(uuid))) {
            TypePlayer player = (TypePlayer)this.plugin.players.get(uuid);
            if (player == null) {
                return false;
            }
            f.load(f.playerDataFile(uuid));
            f.set(KEYS.USER_ACCEPTING_TELEPORT_REQUESTS.toString(), player.user.acceptingTeleportRequests);
            f.set(KEYS.USER_LAST_SEEN.toString(), player.user.lastSeen);
            f.set(KEYS.USER_LAST_KNOWN_NAME.toString(), player.user.lastKnownName);
            f.set(KEYS.USER_NICKNAME.toString(), player.user.nickname);
            f.set(KEYS.USER_TEAM.toString(), player.user.team);
            f.set(KEYS.USER_IP_ADDRESS.toString(), player.user.ipAddress);
            f.set(KEYS.USER_IGNORING_PLAYERS.toString(), player.user.ignoringPlayers);
            f.set(KEYS.USER_CONFIRM_CLEAR.toString(), player.user.confirmClear);
            f.set(KEYS.ECONOMY_BALANCE.toString(), player.economy.balance);
            f.set(KEYS.ECONOMY_ACCEPTING_PAYMENTS.toString(), player.economy.acceptingPayments);
            f.set(KEYS.LAST_LOCATION_WORLD.toString(), player.lastLocation.world);
            f.set(KEYS.LAST_LOCATION_X.toString(), player.lastLocation.x);
            f.set(KEYS.LAST_LOCATION_Y.toString(), player.lastLocation.y);
            f.set(KEYS.LAST_LOCATION_Z.toString(), player.lastLocation.z);
            f.set(KEYS.LAST_LOCATION_YAW.toString(), Float.valueOf(player.lastLocation.yaw));
            f.set(KEYS.LAST_LOCATION_PITCH.toString(), Float.valueOf(player.lastLocation.pitch));
            f.set(KEYS.LAST_SLEEP_WORLD.toString(), player.lastSleep.world);
            f.set(KEYS.LAST_SLEEP_X.toString(), player.lastSleep.x);
            f.set(KEYS.LAST_SLEEP_Y.toString(), player.lastSleep.y);
            f.set(KEYS.LAST_SLEEP_Z.toString(), player.lastSleep.z);
            f.set(KEYS.LAST_SLEEP_YAW.toString(), Float.valueOf(player.lastSleep.yaw));
            f.set(KEYS.LAST_SLEEP_PITCH.toString(), Float.valueOf(player.lastSleep.pitch));
            if (this.plugin.verbose) {
                this.plugin.log.info("DataCache > " + String.valueOf(uuid) + " saved to file.");
            }
            return f.save();
        }
        return false;
    }

    public void unloadPlayer(UUID uuid) {
        this.plugin.players.remove(uuid);
    }

    public boolean createPlayer(UUID uuid) {
        Files f = new Files(this.plugin.foundryConfig, this.plugin);
        if (!f.exists(f.playerDataFile(uuid))) {
            return f.create(f.playerDataFile(uuid));
        }
        return false;
    }

    public boolean playerIsIgnoring(UUID check, UUID target) {
        List ignoring = (List)this.getPlayer(check, KEYS.USER_IGNORING_PLAYERS);
        if (ignoring == null || ignoring.isEmpty()) {
            return false;
        }
        return ignoring.contains(target.toString());
    }

    public boolean setGamemode(CommandSender cs, Player p, GameMode gamemode) {
        UtilPermission permission = new UtilPermission(this.plugin, cs);
        UtilMessage message = new UtilMessage(this.plugin, cs);
        if (permission.has("essence.gamemode." + gamemode.toString().toLowerCase())) {
            if (cs == p) {
                message.send("gamemode", "done", new String[]{gamemode.toString().toLowerCase()});
                p.setGameMode(gamemode);
                return true;
            }
            if (permission.has("essence.gamemode.other")) {
                message.send("gamemode", "doneother", new String[]{p.getName(), gamemode.toString().toLowerCase()});
                message.sendTo((CommandSender)p, "gamemode", "doneby", new String[]{gamemode.toString().toLowerCase(), cs.getName()});
                p.setGameMode(gamemode);
                return true;
            }
            return permission.not();
        }
        return permission.not();
    }

    public String getPlayerPrefix(CommandSender cs) {
        if (this.plugin.integrations.chat != null && cs instanceof Player) {
            Player p = (Player)cs;
            String prefix = this.plugin.integrations.chat.getPlayerPrefix(p);
            if (prefix != null && !prefix.isEmpty()) {
                return "[" + prefix + "]";
            }
            return "";
        }
        return "";
    }

    public String getPlayerSuffix(CommandSender cs) {
        if (this.plugin.integrations.chat != null && cs instanceof Player) {
            Player p = (Player)cs;
            String suffix = this.plugin.integrations.chat.getPlayerSuffix(p);
            if (suffix != null && !suffix.isEmpty()) {
                return " " + suffix;
            }
            return "";
        }
        return "";
    }

    public String getDisplayname(CommandSender cs) {
        Player p;
        TypePlayer player;
        if (cs instanceof Player && (player = (TypePlayer)this.plugin.players.get((p = (Player)cs).getUniqueId())) != null && player.user.nickname != null) {
            return player.user.nickname;
        }
        return cs.getName();
    }

    public boolean setDisplayname(CommandSender cs, String nickname) {
        if (cs instanceof Player) {
            Player p = (Player)cs;
            TypePlayer player = (TypePlayer)this.plugin.players.get(p.getUniqueId());
            player.user.nickname = nickname;
            this.plugin.players.put(p.getUniqueId(), player);
            return true;
        }
        return false;
    }

    public boolean removeDisplayname(CommandSender cs) {
        if (cs instanceof Player) {
            Player p = (Player)cs;
            TypePlayer player = (TypePlayer)this.plugin.players.get(p.getUniqueId());
            player.user.nickname = null;
            this.plugin.players.put(p.getUniqueId(), player);
            return true;
        }
        return false;
    }

    public boolean givePlayerItem(Player p, String item, int amount) {
        try {
            PlayerInventory inventory = p.getInventory();
            Material mat = Material.matchMaterial((String)item);
            if (mat == null) {
                return false;
            }
            inventory.addItem(new ItemStack[]{new ItemStack(mat, amount)});
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void migratePlayerFile(Files f) {
        if (f.get("last-location.world") != null) {
            f.set("location.last-known.world", f.get("last-location.world"));
            f.set("location.last-known.x", f.get("last-location.x"));
            f.set("location.last-known.y", f.get("last-location.y"));
            f.set("location.last-known.z", f.get("last-location.z"));
            f.set("location.last-known.yaw", f.get("last-location.yaw"));
            f.set("location.last-known.pitch", f.get("last-location.pitch"));
        }
        if (f.get("user.last-sleep-location") != null) {
            f.set("location.last-sleep.world", f.get("user.last-sleep-location.world"));
            f.set("location.last-sleep.x", f.get("user.last-sleep-location.x"));
            f.set("location.last-sleep.y", f.get("user.last-sleep-location.y"));
            f.set("location.last-sleep.z", f.get("user.last-sleep-location.z"));
            f.set("location.last-sleep.yaw", f.get("user.last-sleep-location.yaw"));
            f.set("location.last-sleep.pitch", f.get("user.last-sleep-location.pitch"));
        }
        f.remove("last-location");
        f.remove("user.last-sleep-location");
    }

    public static enum KEYS {
        USER_ACCEPTING_TELEPORT_REQUESTS{

            public String toString() {
                return "user.accepting-teleport-requests";
            }
        }
        ,
        USER_LAST_SEEN{

            public String toString() {
                return "user.last-seen";
            }
        }
        ,
        USER_LAST_KNOWN_NAME{

            public String toString() {
                return "user.last-known-name";
            }
        }
        ,
        USER_NICKNAME{

            public String toString() {
                return "user.nickname";
            }
        }
        ,
        USER_IP_ADDRESS{

            public String toString() {
                return "user.ip-address";
            }
        }
        ,
        USER_IGNORING_PLAYERS{

            public String toString() {
                return "user.ignoring-players";
            }
        }
        ,
        USER_TEAM{

            public String toString() {
                return "user.team";
            }
        }
        ,
        USER_CONFIRM_CLEAR{

            public String toString() {
                return "user.confirm-clear";
            }
        }
        ,
        ECONOMY_BALANCE{

            public String toString() {
                return "economy.balance";
            }
        }
        ,
        ECONOMY_ACCEPTING_PAYMENTS{

            public String toString() {
                return "economy.accepting-payments";
            }
        }
        ,
        LAST_LOCATION_WORLD{

            public String toString() {
                return "location.last-known.world";
            }
        }
        ,
        LAST_LOCATION_X{

            public String toString() {
                return "location.last-known.x";
            }
        }
        ,
        LAST_LOCATION_Y{

            public String toString() {
                return "location.last-known.y";
            }
        }
        ,
        LAST_LOCATION_Z{

            public String toString() {
                return "location.last-known.z";
            }
        }
        ,
        LAST_LOCATION_YAW{

            public String toString() {
                return "location.last-known.yaw";
            }
        }
        ,
        LAST_LOCATION_PITCH{

            public String toString() {
                return "location.last-known.pitch";
            }
        }
        ,
        LAST_SLEEP_WORLD{

            public String toString() {
                return "location.last-sleep.world";
            }
        }
        ,
        LAST_SLEEP_X{

            public String toString() {
                return "location.last-sleep.x";
            }
        }
        ,
        LAST_SLEEP_Y{

            public String toString() {
                return "location.last-sleep.y";
            }
        }
        ,
        LAST_SLEEP_Z{

            public String toString() {
                return "location.last-sleep.z";
            }
        }
        ,
        LAST_SLEEP_YAW{

            public String toString() {
                return "location.last-sleep.yaw";
            }
        }
        ,
        LAST_SLEEP_PITCH{

            public String toString() {
                return "location.last-sleep.pitch";
            }
        };

    }
}

