/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence.core;

import java.util.List;
import java.util.Objects;
import net.lewmc.essence.Essence;
import net.lewmc.essence.core.UtilMessage;
import net.lewmc.essence.core.UtilPermission;
import net.lewmc.essence.core.UtilPlaceholder;
import net.lewmc.essence.core.UtilPlayer;
import net.lewmc.essence.external.Files;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.kit.UtilKit;
import net.lewmc.essence.teleportation.tp.UtilTeleport;
import org.bukkit.Bukkit;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class EventJoin
implements Listener {
    private final Essence plugin;

    public EventJoin(Essence plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Logger log = new Logger(this.plugin.foundryConfig);
        UtilPlayer up = new UtilPlayer(this.plugin);
        boolean firstJoin = false;
        if (up.createPlayer(event.getPlayer().getUniqueId())) {
            log.info("Player data file created.");
            firstJoin = true;
        } else if (this.plugin.verbose) {
            log.info("Player data file already exists.");
        }
        if (firstJoin) {
            this.firstJoin(event, log);
        }
        if (!up.loadPlayer(event.getPlayer().getUniqueId())) {
            this.plugin.log.severe("Unable to load player data.");
            this.plugin.log.warn("It wasn't possible to load " + event.getPlayer().getName() + "'s player data.");
            this.plugin.log.warn("The player data may be stale/outdated, Essence may have issues.");
        }
        this.playerJoinMessage(event);
        if (!Objects.equals(this.plugin.config.get("motd"), "false") && !Objects.equals(this.plugin.config.get("motd"), false)) {
            this.motd(event);
        }
        if (((Boolean)this.plugin.config.get("teleportation.spawn.always-spawn")).booleanValue() || firstJoin) {
            try {
                this.spawn(event, log);
            }
            catch (Exception e) {
                log.severe("Unknown exception: " + e.getMessage());
            }
        }
        if (this.plugin.hasPendingUpdate) {
            this.showUpdateAlert(event);
        }
    }

    private void spawn(PlayerJoinEvent event, Logger log) {
        UtilMessage message = new UtilMessage(this.plugin, (CommandSender)event.getPlayer());
        Object spawnConfig = this.plugin.config.get("teleportation.spawn.main-spawn-world");
        if (spawnConfig == null) {
            if (this.plugin.verbose) {
                log.severe("Config key 'teleportation.spawn.main-spawn-world' is not set; skipping join spawn teleport.");
            }
            return;
        }
        String spawnName = spawnConfig.toString();
        Files spawnConfiguration = new Files(this.plugin.foundryConfig, this.plugin);
        if (!spawnConfiguration.load("data/spawns.yml")) {
            log.severe("Unable to load configuration file 'data/spawns.yml'. Essence may be unable to teleport players to the correct spawn");
            return;
        }
        if (spawnConfiguration.get("spawn") == null) {
            if (Bukkit.getServer().getWorld(spawnName) == null) {
                message.send("spawn", "notexist");
                log.severe("The spawn world does not exist. Please check your Essence configuration.");
                return;
            }
            if (Bukkit.getServer().getWorld(spawnName) != null && Bukkit.getServer().getWorld(spawnName).getSpawnLocation() != null) {
                UtilTeleport tp = new UtilTeleport(this.plugin);
                tp.doTeleport(event.getPlayer(), Bukkit.getServer().getWorld(spawnName), Bukkit.getServer().getWorld(spawnName).getSpawnLocation().getX(), Bukkit.getServer().getWorld(spawnName).getSpawnLocation().getY(), Bukkit.getServer().getWorld(spawnName).getSpawnLocation().getZ(), Bukkit.getServer().getWorld(spawnName).getSpawnLocation().getYaw(), Bukkit.getServer().getWorld(spawnName).getSpawnLocation().getPitch(), 0, true);
            } else {
                message.send("spawn", "notexist");
                log.info("Failed to respawn player - world '" + String.valueOf(Bukkit.getServer().getWorld(spawnName)) + "' does not exist.");
            }
        } else {
            UtilTeleport tp = new UtilTeleport(this.plugin);
            if (Bukkit.getServer().getWorld(spawnName) == null) {
                WorldCreator creator = new WorldCreator(spawnName);
                creator.createWorld();
            }
            tp.doTeleport(event.getPlayer(), Bukkit.getServer().getWorld(spawnName), spawnConfiguration.getDouble("spawn." + spawnName + ".X"), spawnConfiguration.getDouble("spawn." + spawnName + ".Y"), spawnConfiguration.getDouble("spawn." + spawnName + ".Z"), (float)spawnConfiguration.getDouble("spawn." + spawnName + ".yaw"), (float)spawnConfiguration.getDouble("spawn." + spawnName + ".pitch"), 0, true);
        }
        spawnConfiguration.close();
    }

    private void firstJoin(PlayerJoinEvent event, Logger log) {
        UtilKit kit = new UtilKit(this.plugin, event.getPlayer());
        if (this.plugin.config.get("kit.spawn-kits") != null && !Objects.equals(this.plugin.config.get("kit.spawn-kits"), "false")) {
            for (String giveKit : (List)this.plugin.config.get("kit.spawn-kits")) {
                log.info("Giving player '" + event.getPlayer().getName() + "' spawn kit '" + giveKit + "'");
                kit.giveKit(giveKit);
            }
        }
    }

    private void motd(PlayerJoinEvent event) {
        String message;
        if (this.plugin.config.get("chat.motd") != null && (message = this.plugin.config.get("chat.motd").toString()) != null) {
            UtilPlaceholder tag = new UtilPlaceholder(this.plugin, (CommandSender)event.getPlayer());
            event.getPlayer().sendMessage(tag.replaceAll(message));
        }
    }

    private void playerJoinMessage(PlayerJoinEvent event) {
        UtilPlaceholder tag = new UtilPlaceholder(this.plugin, (CommandSender)event.getPlayer());
        if (event.getPlayer().hasPlayedBefore()) {
            event.setJoinMessage(tag.replaceAll((String)this.plugin.config.get("chat.broadcasts.join")));
        } else {
            event.setJoinMessage(tag.replaceAll((String)this.plugin.config.get("chat.broadcasts.first-join")));
        }
    }

    private void showUpdateAlert(PlayerJoinEvent event) {
        UtilMessage msg = new UtilMessage(this.plugin, (CommandSender)event.getPlayer());
        UtilPermission perms = new UtilPermission(this.plugin, (CommandSender)event.getPlayer());
        if (perms.has("essence.admin.updates") && this.plugin.hasPendingUpdate) {
            msg.send("other", "updatemsg");
            msg.send("other", "updatemore");
        }
    }
}

