/*
 * Decompiled with CFR 0.152.
 */
package net.lewmc.essence;

import java.lang.runtime.SwitchBootstraps;
import net.lewmc.essence.Essence;
import net.lewmc.essence.EssencePAPIExpansion;
import net.lewmc.essence.economy.UtilVaultEconomy;
import net.lewmc.essence.external.Logger;
import net.lewmc.essence.external.bukkit.Metrics;
import net.lewmc.essence.external.charts.SimplePie;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;

public class EssenceIntegrations {
    public boolean PAPIEnabled;
    public Chat chat;
    public Economy economy;
    private final Logger log;
    private final Essence plugin;

    public EssenceIntegrations(Essence plugin) {
        this.plugin = plugin;
        this.log = new Logger(plugin.foundryConfig);
    }

    public boolean loadPlaceholderAPI() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new EssencePAPIExpansion(this.plugin).register();
            this.PAPIEnabled = true;
            this.log.info("Placeholder API is installed, registered placeholders.");
        } else {
            this.PAPIEnabled = false;
            if (this.plugin.verbose) {
                this.log.info("Placeholder API is not installed, placeholders not registered.");
            }
        }
        return this.PAPIEnabled;
    }

    public boolean loadVaultEconomy() {
        if (this.plugin.verbose) {
            this.log.info("Config economy mode set to '" + String.valueOf(this.plugin.config.get("economy.mode")) + "'");
        }
        String string = (String)this.plugin.config.get("economy.mode");
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"VAULT", "true", "default", "ESSENCE", "INTERNAL", "NOVAULT", "OFF", "DISABLED", "DISABLE", "false"}, (Object)string, n)) {
            case 0: 
            case 1: 
            case 2: {
                if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
                    return false;
                }
                this.plugin.getServer().getServicesManager().register(Economy.class, (Object)new UtilVaultEconomy(this.plugin), (Plugin)this.plugin, ServicePriority.Highest);
                RegisteredServiceProvider ersp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
                if (ersp == null) {
                    this.log.severe("Something went wrong whilst setting up economy service.");
                    this.log.severe("Essence will fallback to internal-only economy mode.");
                    return false;
                }
                this.economy = (Economy)ersp.getProvider();
                this.log.info("Setup economy in Vault mode.");
                return this.economy != null;
            }
            case 3: 
            case 4: 
            case 5: {
                this.log.warn("Setup economy in Essence-only mode.");
                this.log.warn("Vault economy is disabled, but Essence commands will still use internal economy.");
                return false;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.log.warn("Economy is disabled.");
                return false;
            }
        }
        this.log.warn("Unknown economy mode, economy is disabled. Please set mode to 'VAULT', 'ESSENCE' or 'OFF'");
        return false;
    }

    public boolean loadVaultChat() {
        if (((Boolean)this.plugin.config.get("chat.manage-chat")).booleanValue()) {
            if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            this.log.info("Vault found, setting up chat service...");
            RegisteredServiceProvider crsp = this.plugin.getServer().getServicesManager().getRegistration(Chat.class);
            if (crsp != null) {
                this.chat = (Chat)crsp.getProvider();
            } else {
                this.log.severe("Something went wrong whilst setting up chat service.");
                this.log.severe("Some chat features may be disabled.");
            }
            return this.chat != null;
        }
        this.log.warn("Chat management is disabled.");
        return false;
    }

    public void loadMetrics() {
        int pluginId = 20768;
        Metrics metrics = new Metrics((Plugin)this.plugin, pluginId);
        metrics.addCustomChart(new SimplePie("language", () -> (String)this.plugin.config.get("language")));
        if (this.economy == null) {
            metrics.addCustomChart(new SimplePie("economy_enabled", () -> "false"));
        } else {
            metrics.addCustomChart(new SimplePie("economy_enabled", () -> "true"));
        }
        if (this.chat == null) {
            metrics.addCustomChart(new SimplePie("chat_enabled", () -> "false"));
        } else {
            metrics.addCustomChart(new SimplePie("chat_enabled", () -> "true"));
        }
        if (!this.PAPIEnabled) {
            metrics.addCustomChart(new SimplePie("papi_enabled", () -> "false"));
        } else {
            metrics.addCustomChart(new SimplePie("papi_enabled", () -> "true"));
        }
    }
}

