/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.platform;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.ProtocolPacketEvent;
import com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessageLegacy;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_16;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_1;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_19_3;
import com.github.retrooper.packetevents.protocol.chat.message.ChatMessage_v1_21_5;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerActionBar;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatMessage;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerChatPreview;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDisguisedChat;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetTitleSubtitle;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSetTitleText;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.listeners.packet.MessagePacketHandler;
import com.loohp.interactivechat.objectholders.ICPlayerFactory;
import com.loohp.interactivechat.utils.ChatComponentType;
import com.loohp.interactivechat.utils.ComponentStyling;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.MCVersion;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;

public class PacketEventsOutMessagePacketHelper {
    protected static final Map<PacketTypeCommon, PacketEventsHandler<?>> PACKET_HANDLERS = new HashMap();

    private static void initializeMessagePacketHandlers() {
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.DISGUISED_CHAT, new PacketEventsHandler<WrapperPlayServerDisguisedChat>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.chatListener), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getMessage(), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, false);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB = InteractiveChat.version.isLegacyRGB();
            String json = legacyRGB ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setMessage((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerDisguisedChat::new, p -> new WrapperPlayServerDisguisedChat(p.getMessage(), p.getChatFormatting())));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.CHAT_MESSAGE, new PacketEventsHandler<WrapperPlayServerChatMessage>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> {
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19_3)) {
                return InteractiveChat.chatListener;
            }
            WrapperPlayServerChatMessage packet = (WrapperPlayServerChatMessage)event.getLastUsedWrapper();
            if (packet.getMessage().getType().equals(ChatTypes.GAME_INFO)) {
                return InteractiveChat.titleListener;
            }
            return InteractiveChat.chatListener;
        }), (MessagePacketHandler.DeterminedSenderFinder<ProtocolPacketEvent>)((MessagePacketHandler.DeterminedSenderFinder)event -> {
            UUID uuid;
            WrapperPlayServerChatMessage packet = (WrapperPlayServerChatMessage)event.getLastUsedWrapper();
            ChatMessage chatMessage = packet.getMessage();
            if (chatMessage instanceof ChatMessage_v1_16 && (uuid = ((ChatMessage_v1_16)chatMessage).getSenderUUID()) != null) {
                return ICPlayerFactory.getICPlayer((UUID)uuid);
            }
            return null;
        }), (packet, player) -> {
            net.kyori.adventure.text.Component unsignedContent;
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            ChatMessage chatMessage = packet.getMessage();
            Component component = chatMessage instanceof ChatMessage_v1_21_5 ? ((unsignedContent = (net.kyori.adventure.text.Component)((ChatMessage_v1_21_5)chatMessage).getUnsignedChatContent().orElse(null)) == null ? type.convertFrom((Object)chatMessage.getChatContent(), player) : type.convertFrom((Object)unsignedContent, player)) : (chatMessage instanceof ChatMessage_v1_19_3 ? ((unsignedContent = (net.kyori.adventure.text.Component)((ChatMessage_v1_19_3)chatMessage).getUnsignedChatContent().orElse(null)) == null ? type.convertFrom((Object)chatMessage.getChatContent(), player) : type.convertFrom((Object)unsignedContent, player)) : (chatMessage instanceof ChatMessage_v1_19_1 ? ((unsignedContent = ((ChatMessage_v1_19_1)chatMessage).getUnsignedChatContent()) == null ? type.convertFrom((Object)chatMessage.getChatContent(), player) : type.convertFrom((Object)unsignedContent, player)) : (chatMessage instanceof ChatMessage_v1_19 ? ((unsignedContent = ((ChatMessage_v1_19)chatMessage).getUnsignedChatContent()) == null ? type.convertFrom((Object)chatMessage.getChatContent(), player) : type.convertFrom((Object)unsignedContent, player)) : type.convertFrom((Object)chatMessage.getChatContent(), player))));
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, false);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB = InteractiveChat.version.isLegacyRGB();
            String json = legacyRGB ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            ChatMessage chatMessage = packet.getMessage();
            if (chatMessage instanceof ChatMessage_v1_16 && sender != null) {
                ((ChatMessage_v1_16)chatMessage).setSenderUUID(sender);
            }
            net.kyori.adventure.text.Component bukkitComponent = (net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB);
            if (chatMessage instanceof ChatMessage_v1_21_5) {
                ((ChatMessage_v1_21_5)chatMessage).setUnsignedChatContent(bukkitComponent);
            } else if (chatMessage instanceof ChatMessage_v1_19_3) {
                ((ChatMessage_v1_19_3)chatMessage).setUnsignedChatContent(bukkitComponent);
            } else if (chatMessage instanceof ChatMessage_v1_19_1) {
                ((ChatMessage_v1_19_1)chatMessage).setUnsignedChatContent(bukkitComponent);
            } else if (chatMessage instanceof ChatMessage_v1_19) {
                ((ChatMessage_v1_19)chatMessage).setUnsignedChatContent(bukkitComponent);
            } else {
                chatMessage.setChatContent(bukkitComponent);
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerChatMessage::new, p -> {
            ChatMessageLegacy clonedChatMessage;
            ChatMessage chatMessage = p.getMessage();
            if (chatMessage instanceof ChatMessage_v1_21_5) {
                ChatMessage_v1_21_5 c = (ChatMessage_v1_21_5)chatMessage;
                clonedChatMessage = new ChatMessage_v1_21_5(c.getGlobalIndex(), c.getSenderUUID(), c.getIndex(), Arrays.copyOf(c.getSignature(), c.getSignature().length), c.getPlainContent(), c.getTimestamp(), c.getSalt(), c.getLastSeenMessagesPacked(), c.getChatContent(), c.getFilterMask(), c.getChatFormatting());
            } else if (chatMessage instanceof ChatMessage_v1_19_3) {
                ChatMessage_v1_19_3 c = (ChatMessage_v1_19_3)chatMessage;
                clonedChatMessage = new ChatMessage_v1_19_3(c.getSenderUUID(), c.getIndex(), Arrays.copyOf(c.getSignature(), c.getSignature().length), c.getPlainContent(), c.getTimestamp(), c.getSalt(), c.getLastSeenMessagesPacked(), c.getChatContent(), c.getFilterMask(), c.getChatFormatting());
            } else if (chatMessage instanceof ChatMessage_v1_19_1) {
                ChatMessage_v1_19_1 c = (ChatMessage_v1_19_1)chatMessage;
                clonedChatMessage = new ChatMessage_v1_19_1(c.getPlainContent(), c.getChatContent(), c.getUnsignedChatContent(), c.getSenderUUID(), c.getChatFormatting(), Arrays.copyOf(c.getPreviousSignature(), c.getPreviousSignature().length), Arrays.copyOf(c.getSignature(), c.getSignature().length), c.getTimestamp(), c.getSalt(), c.getLastSeenMessages(), c.getFilterMask());
            } else if (chatMessage instanceof ChatMessage_v1_19) {
                ChatMessage_v1_19 c = (ChatMessage_v1_19)chatMessage;
                clonedChatMessage = new ChatMessage_v1_19(c.getChatContent(), c.getUnsignedChatContent(), c.getType(), c.getSenderUUID(), c.getSenderDisplayName(), c.getTeamName(), c.getTimestamp(), c.getSalt(), Arrays.copyOf(c.getSignature(), c.getSignature().length));
            } else if (chatMessage instanceof ChatMessage_v1_16) {
                ChatMessage_v1_16 c = (ChatMessage_v1_16)chatMessage;
                clonedChatMessage = new ChatMessage_v1_16(c.getChatContent(), c.getType(), c.getSenderUUID());
            } else {
                clonedChatMessage = new ChatMessageLegacy(chatMessage.getChatContent(), chatMessage.getType());
            }
            return new WrapperPlayServerChatMessage((ChatMessage)clonedChatMessage);
        }));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.CHAT_PREVIEW_PACKET, new PacketEventsHandler<WrapperPlayServerChatPreview>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.chatListener), (MessagePacketHandler.DeterminedSenderFinder<ProtocolPacketEvent>)((MessagePacketHandler.DeterminedSenderFinder)event -> ICPlayerFactory.getICPlayer((Player)((Player)event.getPlayer()))), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getMessage().orElse(net.kyori.adventure.text.Component.empty()), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, true);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB;
            if (InteractiveChat.chatPreviewRemoveClickAndHover) {
                component = ComponentStyling.stripEvents((Component)component);
            }
            String json = (legacyRGB = InteractiveChat.version.isLegacyRGB()) ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setMessage((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            if (sender == null) {
                sender = MessagePacketHandler.UUID_NIL;
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerChatPreview::new, p -> new WrapperPlayServerChatPreview(p.getQueryId(), (net.kyori.adventure.text.Component)p.getMessage().orElse(null))));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.SYSTEM_CHAT_MESSAGE, new PacketEventsHandler<WrapperPlayServerSystemChatMessage>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.chatListener), (MessagePacketHandler.DeterminedSenderFinder<ProtocolPacketEvent>)((MessagePacketHandler.DeterminedSenderFinder)event -> ICPlayerFactory.getICPlayer((Player)((Player)event.getPlayer()))), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getMessage(), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, true);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB;
            if (InteractiveChat.chatPreviewRemoveClickAndHover) {
                component = ComponentStyling.stripEvents((Component)component);
            }
            String json = (legacyRGB = InteractiveChat.version.isLegacyRGB()) ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setMessage((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            if (sender == null) {
                sender = MessagePacketHandler.UUID_NIL;
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerSystemChatMessage::new, p -> {
            if (p.getType() == null) {
                return new WrapperPlayServerSystemChatMessage(p.isOverlay(), p.getMessage());
            }
            return new WrapperPlayServerSystemChatMessage(p.getType(), p.getMessage());
        }));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.SET_TITLE_TEXT, new PacketEventsHandler<WrapperPlayServerSetTitleText>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.titleListener), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getTitle(), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, false);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB = InteractiveChat.version.isLegacyRGB();
            String json = legacyRGB ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setTitle((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            if (sender == null) {
                sender = MessagePacketHandler.UUID_NIL;
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerSetTitleText::new, p -> new WrapperPlayServerSetTitleText(p.getTitle())));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.SET_TITLE_SUBTITLE, new PacketEventsHandler<WrapperPlayServerSetTitleSubtitle>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.titleListener), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getSubtitle(), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, false);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB = InteractiveChat.version.isLegacyRGB();
            String json = legacyRGB ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setSubtitle((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            if (sender == null) {
                sender = MessagePacketHandler.UUID_NIL;
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerSetTitleSubtitle::new, p -> new WrapperPlayServerSetTitleSubtitle(p.getSubtitle())));
        PACKET_HANDLERS.put((PacketTypeCommon)PacketType.Play.Server.ACTION_BAR, new PacketEventsHandler<WrapperPlayServerActionBar>((MessagePacketHandler.PreFilter<ProtocolPacketEvent>)((MessagePacketHandler.PreFilter)event -> InteractiveChat.titleListener), (packet, player) -> {
            ChatComponentType type = ChatComponentType.NativeAdventureComponent;
            Component component = type.convertFrom((Object)packet.getActionBarText(), player);
            return new MessagePacketHandler.PacketAccessorResult(component, type, 0, false);
        }, (packet, component, type, field, sender) -> {
            boolean legacyRGB = InteractiveChat.version.isLegacyRGB();
            String json = legacyRGB ? (String)InteractiveChatComponentSerializer.legacyGson().serialize(component) : (String)InteractiveChatComponentSerializer.gson().serialize(component);
            boolean longerThanMaxLength = InteractiveChat.sendOriginalIfTooLong && json.length() > InteractiveChat.packetStringMaxLength;
            packet.setActionBarText((net.kyori.adventure.text.Component)type.convertTo(component, legacyRGB));
            if (sender == null) {
                sender = MessagePacketHandler.UUID_NIL;
            }
            return new MessagePacketHandler.PacketWriterResult(longerThanMaxLength, json.length(), sender);
        }, WrapperPlayServerActionBar::new, p -> new WrapperPlayServerActionBar(p.getActionBarText())));
    }

    static {
        PacketEventsOutMessagePacketHelper.initializeMessagePacketHandlers();
    }

    public static class PacketEventsHandler<PacketTyped extends PacketWrapper<?>> {
        private final MessagePacketHandler<ProtocolPacketEvent, PacketWrapper<?>> handler;
        private final Function<PacketSendEvent, PacketTyped> wrapper;
        private final UnaryOperator<PacketWrapper<?>> cloner;

        public PacketEventsHandler(MessagePacketHandler.PreFilter<ProtocolPacketEvent> preFilter, MessagePacketHandler.PacketAccessor<PacketTyped> accessor, MessagePacketHandler.PacketWriter<PacketTyped> writer, Function<PacketSendEvent, PacketTyped> wrapper, UnaryOperator<PacketTyped> cloner) {
            this.handler = new MessagePacketHandler(preFilter, accessor, writer);
            this.wrapper = wrapper;
            this.cloner = p -> (PacketWrapper)cloner.apply(p);
        }

        public PacketEventsHandler(MessagePacketHandler.PreFilter<ProtocolPacketEvent> preFilter, MessagePacketHandler.DeterminedSenderFinder<ProtocolPacketEvent> determinedSenderFunction, MessagePacketHandler.PacketAccessor<PacketTyped> accessor, MessagePacketHandler.PacketWriter<PacketTyped> writer, Function<PacketSendEvent, PacketTyped> wrapper, UnaryOperator<PacketTyped> cloner) {
            this.handler = new MessagePacketHandler(preFilter, determinedSenderFunction, accessor, writer);
            this.wrapper = wrapper;
            this.cloner = p -> (PacketWrapper)cloner.apply(p);
        }

        public MessagePacketHandler<ProtocolPacketEvent, PacketWrapper<?>> getHandler() {
            return this.handler;
        }

        public Function<PacketSendEvent, PacketTyped> getWrapper() {
            return this.wrapper;
        }

        public UnaryOperator<PacketWrapper<?>> getCloner() {
            return this.cloner;
        }
    }
}

