/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ItemFrame;
import org.bukkit.util.Vector;

public class ItemFrameUtils {
    public static boolean isOnWalls(ItemFrame itemFrame) {
        BlockFace blockFace = itemFrame.getAttachedFace();
        return !blockFace.equals((Object)BlockFace.DOWN) && !blockFace.equals((Object)BlockFace.UP);
    }

    public static boolean isOnCeiling(ItemFrame itemFrame) {
        return itemFrame.getAttachedFace().equals((Object)BlockFace.UP);
    }

    public static Rotation getClosestMapRotation(float yaw) {
        float remaining;
        yaw -= 180.0f;
        while (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 360.0f) {
            yaw %= 360.0f;
        }
        Rotation rotation = Rotation.NONE;
        float i = 0.0f;
        while (!((remaining = yaw - i) < 45.0f)) {
            rotation = rotation.rotateClockwise();
            i += 90.0f;
        }
        return rotation;
    }

    public static Vector getClosestCardinalDirection(float yaw) {
        double rotation = (yaw - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        double alignedYaw = 0.0 <= rotation && rotation < 45.0 ? 90.0 : (45.0 <= rotation && rotation < 135.0 ? 180.0 : (135.0 <= rotation && rotation < 225.0 ? -90.0 : (225.0 <= rotation && rotation < 315.0 ? 0.0 : (315.0 <= rotation && rotation < 360.0 ? 90.0 : 0.0))));
        return new Vector(-Math.sin(Math.toRadians(alignedYaw)), 0.0, Math.cos(Math.toRadians(alignedYaw)));
    }
}

