/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.loohp.imageframe.nms.NMS;
import java.util.ArrayList;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;

public class FakeItemUtils {
    public static void sendFakeItemChange(Player player, Iterable<ItemFrameUpdateData> updateData) {
        ArrayList<Object> packets = new ArrayList<Object>();
        for (ItemFrameUpdateData itemFrameUpdateData : updateData) {
            packets.add(NMS.getInstance().createItemFrameItemChangePacket(itemFrameUpdateData.getEntityId(), itemFrameUpdateData.getItemStack()));
        }
        if (player.isOnline()) {
            for (ItemFrameUpdateData itemFrameUpdateData : packets) {
                NMS.getInstance().sendPacket(player, itemFrameUpdateData);
            }
        }
    }

    public static void sendFakeItemChange(Player player, int entityId, ItemStack itemStack) {
        Object packet = NMS.getInstance().createItemFrameItemChangePacket(entityId, itemStack);
        if (player.isOnline()) {
            NMS.getInstance().sendPacket(player, packet);
        }
    }

    public static class ItemFrameUpdateData {
        private final int entityId;
        private final ItemStack itemStack;
        private final int realMapId;
        private final MapView mapView;
        private final int currentPosition;

        public ItemFrameUpdateData(int entityId, ItemStack itemStack, int realMapId, MapView mapView, int currentPosition) {
            this.entityId = entityId;
            this.itemStack = itemStack;
            this.realMapId = realMapId;
            this.mapView = mapView;
            this.currentPosition = currentPosition;
        }

        public int getEntityId() {
            return this.entityId;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public int getRealMapId() {
            return this.realMapId;
        }

        public MapView getMapView() {
            return this.mapView;
        }

        public int getCurrentPosition() {
            return this.currentPosition;
        }
    }
}

