/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.storage;

import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.storage.FileImageFrameStorageLoader;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.storage.ImageFrameStorageLoader;
import com.loohp.imageframe.storage.JdbcImageFrameStorageLoader;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ImageFrameStorageLoaders {
    private static final Map<Key, ImageFrameStorageLoader<?>> LOADERS = new ConcurrentHashMap();
    public static final FileImageFrameStorageLoader FILE = ImageFrameStorageLoaders.register(new FileImageFrameStorageLoader());
    public static final JdbcImageFrameStorageLoader JDBC = ImageFrameStorageLoaders.register(new JdbcImageFrameStorageLoader());

    public static <T extends ImageFrameStorageLoader<S>, S extends ImageFrameStorage> T register(T loader) {
        LOADERS.put(loader.getIdentifier(), loader);
        return loader;
    }

    public static Collection<ImageFrameStorageLoader<?>> getRegisteredLoaders() {
        return Collections.unmodifiableCollection(LOADERS.values());
    }

    public static ImageFrameStorageLoader<?> getLoader(Key type) {
        ImageFrameStorageLoader<?> loader = LOADERS.get(type);
        if (loader == null) {
            throw new IllegalStateException("Unknown loader type " + type.asString());
        }
        return loader;
    }

    public static ImageFrameStorage create(Key type, File dataFolder, Map<String, String> options) {
        return ImageFrameStorageLoaders.getLoader(type).create(dataFolder, options);
    }
}

