/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapLoaderPriority;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.LazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMap;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMapCreateInfo;
import com.loohp.imageframe.objectholders.StandardLazyMappedBufferedImage;
import com.loohp.imageframe.utils.FutureUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.bukkit.World;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class MinecraftURLOverlayImageMapLoader
extends ImageMapLoader<MinecraftURLOverlayImageMap, MinecraftURLOverlayImageMapCreateInfo> {
    private static final Key IDENTIFIER = Key.key("imageframe", "url_static_overlay");
    private static final String LEGACY_TYPE = "com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMap";

    @Override
    public Key getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public String getLegacyType() {
        return LEGACY_TYPE;
    }

    @Override
    public Class<MinecraftURLOverlayImageMap> getImageMapClass() {
        return MinecraftURLOverlayImageMap.class;
    }

    @Override
    public Class<MinecraftURLOverlayImageMapCreateInfo> getImageMapCreateInfoClass() {
        return MinecraftURLOverlayImageMapCreateInfo.class;
    }

    @Override
    public List<String> getExtraPermissions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isSupported(String imageType) {
        return true;
    }

    @Override
    public ImageMapLoaderPriority getPriority(String imageType) {
        return ImageMapLoaderPriority.LOWEST;
    }

    @Override
    public Future<MinecraftURLOverlayImageMap> create(MinecraftURLOverlayImageMapCreateInfo createInfo) throws Exception {
        int mapsCount = createInfo.getWidth() * createInfo.getHeight();
        List<MapView> mapViews = createInfo.getMapViews();
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapsCount);
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            MapView mapView = mapViews.get(i);
            mapIds.add(mapView.getId());
            for (MapRenderer mapRenderer : mapView.getRenderers()) {
                if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMap.MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                mapView.removeRenderer(mapRenderer);
            }
            markers.add(new ConcurrentHashMap());
        }
        MinecraftURLOverlayImageMap map = new MinecraftURLOverlayImageMap(createInfo.getManager(), this, -1, createInfo.getName(), createInfo.getUrl(), new LazyMappedBufferedImage[mapsCount], mapViews, mapIds, markers, createInfo.getWidth(), createInfo.getHeight(), createInfo.getDitheringType(), createInfo.getCreator(), Collections.emptyMap(), System.currentTimeMillis());
        return FutureUtils.callAsyncMethod(() -> {
            FutureUtils.callSyncMethod(() -> {
                for (int i = 0; i < mapViews.size(); ++i) {
                    ((MapView)mapViews.get(i)).addRenderer((MapRenderer)new MinecraftURLOverlayImageMap.MinecraftURLOverlayImageMapRenderer(map, i));
                }
            }).get();
            map.update(false);
            return map;
        });
    }

    @Override
    public Future<MinecraftURLOverlayImageMap> load(ImageMapManager manager, JsonObject json) throws Exception {
        Map<UUID, ImageMapAccessPermissionType> hasAccess;
        int imageIndex = json.get("index").getAsInt();
        String name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        String url = json.get("url").getAsString();
        int width = json.get("width").getAsInt();
        int height = json.get("height").getAsInt();
        DitheringType ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        long creationTime = json.get("creationTime").getAsLong();
        UUID creator = UUID.fromString(json.get("creator").getAsString());
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            hasAccess = new HashMap(accessJson.size());
            for (Map.Entry<String, JsonElement> entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString(entry.getKey()), ImageMapAccessPermissionType.valueOf(entry.getValue().getAsString().toUpperCase()));
            }
        } else {
            hasAccess = Collections.emptyMap();
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapDataJson.size());
        LazyMappedBufferedImage[] cachedImages = new LazyMappedBufferedImage[mapDataJson.size()];
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapDataJson.size());
        World world = MapUtils.getMainWorld();
        int i = 0;
        for (JsonElement dataJson : mapDataJson) {
            JsonObject jsonObject = dataJson.getAsJsonObject();
            if (jsonObject.has("mapid")) {
                int n = jsonObject.get("mapid").getAsInt();
                mapViewsFuture.add(MapUtils.getMapOrCreateMissing(world, n));
            } else {
                mapViewsFuture.add(MapUtils.createMap(world));
            }
            cachedImages[i] = StandardLazyMappedBufferedImage.fromSource(manager.getStorage().getSource(imageIndex, jsonObject.get("image").getAsString()));
            ConcurrentHashMap<String, MapCursor> concurrentHashMap = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    concurrentHashMap.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            markers.add(concurrentHashMap);
            ++i;
        }
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapDataJson.size());
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapViewsFuture.size());
        for (Future future : mapViewsFuture) {
            MapView mapView = (MapView)future.get();
            mapViews.add(mapView);
            mapIds.add(mapView.getId());
        }
        MinecraftURLOverlayImageMap map = new MinecraftURLOverlayImageMap(manager, this, imageIndex, name, url, cachedImages, mapViews, mapIds, markers, width, height, ditheringType, creator, hasAccess, creationTime);
        return FutureUtils.callSyncMethod(() -> {
            for (int u = 0; u < mapViews.size(); ++u) {
                MapView mapView = (MapView)mapViews.get(u);
                for (MapRenderer mapRenderer : mapView.getRenderers()) {
                    if (!mapRenderer.getClass().getName().equals(MinecraftURLOverlayImageMap.MinecraftURLOverlayImageMapRenderer.class.getName())) continue;
                    mapView.removeRenderer(mapRenderer);
                }
                mapView.addRenderer((MapRenderer)new MinecraftURLOverlayImageMap.MinecraftURLOverlayImageMapRenderer(map, u));
            }
            return map;
        });
    }
}

