/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.imageframe.objectholders.PreferenceState;
import com.loohp.imageframe.objectholders.UnsetState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class LanguageState
implements UnsetState,
PreferenceState {
    public static final LanguageState UNSET = new LanguageState(null);
    public static final Supplier<Map<String, LanguageState>> VALUES_MAP_SUPPLIER = () -> {
        Map values = ImageFrame.languageManager.getLoadedLanguages().stream().collect(Collectors.toMap(e -> e, e -> new LanguageState((String)e), (x, y) -> y, LinkedHashMap::new));
        values.put("unset", UNSET);
        return values;
    };
    private final JsonElement jsonValue;
    private final String languageValue;

    public LanguageState(String languageValue) {
        this.jsonValue = languageValue == null ? UNSET_JSON : new JsonPrimitive(languageValue);
        this.languageValue = languageValue;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Override
    public String name() {
        return this.languageValue.toUpperCase();
    }

    @Override
    public JsonElement getJsonValue() {
        return this.jsonValue;
    }

    @Override
    public TextColor getDisplayColor() {
        return this.isUnset() ? NamedTextColor.GRAY : NamedTextColor.WHITE;
    }

    public String getRawValue() {
        return this.languageValue;
    }

    public String getRawValue(String unsetValue) {
        return this.languageValue == null ? unsetValue : this.languageValue;
    }

    public String getCalculatedValue(Supplier<String> unsetValueFunction) {
        return this.languageValue == null || !ImageFrame.languageManager.getLoadedLanguages().contains(this.languageValue) ? unsetValueFunction.get() : this.languageValue;
    }

    public static LanguageState fromString(String value) {
        return new LanguageState(value);
    }

    public static LanguageState fromJsonValue(JsonElement jsonValue) {
        return LanguageState.fromString(UnsetState.isUnset(jsonValue) ? null : jsonValue.getAsString());
    }
}

