/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapAddedEvent;
import com.loohp.imageframe.api.events.ImageMapDeletedEvent;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.IFPlayerManager;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapLoaders;
import com.loohp.imageframe.objectholders.ImageMapRenderEventListener;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.utils.MapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class ImageMapManager
implements AutoCloseable {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public static final int FAKE_MAP_ID_START_RANGE = 0x5FFFFFFD;
    private static final AtomicInteger FAKE_MAP_ID_COUNTER = new AtomicInteger(0x5FFFFFFD);
    private final ImageFrameStorage imageFrameStorage;
    private final Map<Integer, ImageMap> maps = new ConcurrentHashMap<Integer, ImageMap>();
    private final Map<MapView, ImageMap> mapsByView = new ConcurrentHashMap<MapView, ImageMap>();
    private final List<ImageMapRenderEventListener> renderEventListeners;
    private final Set<Integer> deletedMapIds;

    public static int getNextFakeMapId() {
        return FAKE_MAP_ID_COUNTER.getAndUpdate(i -> i < 0x5FFFFFFD ? 0x5FFFFFFD : i + 1);
    }

    public ImageMapManager(ImageFrameStorage imageFrameStorage) {
        this.imageFrameStorage = imageFrameStorage;
        this.renderEventListeners = new CopyOnWriteArrayList<ImageMapRenderEventListener>();
        this.deletedMapIds = ConcurrentHashMap.newKeySet();
    }

    public ImageFrameStorage getStorage() {
        return this.imageFrameStorage;
    }

    protected long getCurrentAnimationTick() {
        return System.currentTimeMillis() / 50L;
    }

    @Override
    public void close() {
        this.saveDeletedMaps();
    }

    public void appendRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.add(listener);
    }

    public void prependRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.add(0, listener);
    }

    public void removeRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.remove(listener);
    }

    protected void callRenderEventListener(ImageMapManager manager, ImageMap imageMap, MapView map, Player player, MutablePair<byte[], Collection<MapCursor>> renderData) {
        this.renderEventListeners.forEach(each -> each.accept(manager, imageMap, map, player, renderData));
    }

    public synchronized void addMap(ImageMap map) throws Exception {
        if (map.getManager() != this) {
            throw new IllegalArgumentException("ImageMap's manager is not set to this");
        }
        if (this.getFromCreator(map.getCreator(), map.getName()) != null) {
            throw new IllegalArgumentException("Duplicated map name for this creator");
        }
        int originalImageIndex = map.getImageIndex();
        this.imageFrameStorage.prepareImageIndex(map, i -> {
            map.imageIndex = i;
        });
        this.maps.put(map.getImageIndex(), map);
        for (MapView mapView : map.getMapViews()) {
            this.mapsByView.put(mapView, map);
            this.deletedMapIds.remove(mapView.getId());
        }
        try {
            map.save();
            Bukkit.getPluginManager().callEvent((Event)new ImageMapAddedEvent(map));
        }
        catch (Throwable e) {
            this.maps.remove(originalImageIndex);
            for (MapView mapView : map.getMapViews()) {
                this.mapsByView.remove(mapView);
            }
            throw e;
        }
        this.saveDeletedMaps();
    }

    public boolean hasMap(int imageIndex) {
        return this.maps.containsKey(imageIndex);
    }

    public Collection<ImageMap> getMaps() {
        return Collections.unmodifiableCollection(this.maps.values());
    }

    public ImageMap getFromMapId(int id) {
        MapView mapView = Bukkit.getMap((int)id);
        if (mapView == null) {
            return null;
        }
        return this.getFromMapView(Bukkit.getMap((int)id));
    }

    public ImageMap getFromImageId(int imageId) {
        return this.maps.get(imageId);
    }

    public ImageMap getFromMapView(MapView mapView) {
        return this.mapsByView.get(mapView);
    }

    public Set<ImageMap> getFromCreator(UUID uuid) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid)).collect(Collectors.toSet());
    }

    public List<ImageMap> getFromCreator(UUID uuid, Comparator<ImageMap> order) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid)).sorted(order).collect(Collectors.toList());
    }

    public ImageMap getFromCreator(UUID uuid, String name) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid) && each.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Set<UUID> getCreators() {
        return this.maps.values().stream().map(each -> each.getCreator()).collect(Collectors.toSet());
    }

    public ImageMap getFromFakeMapId(int fakeMapId) {
        return this.maps.values().stream().filter(each -> each.requiresAnimationService() && each.getFakeMapIds().contains(fakeMapId)).findFirst().orElse(null);
    }

    public boolean deleteMap(int imageIndex) {
        ImageMap imageMap = this.maps.remove(imageIndex);
        if (imageMap == null) {
            return false;
        }
        List<MapView> mapViews = imageMap.getMapViews();
        for (MapView mapView : mapViews) {
            this.mapsByView.remove(mapView);
        }
        if (imageMap.trackDeletedMaps()) {
            mapViews.forEach(each -> this.deletedMapIds.add(each.getId()));
        }
        imageMap.markInvalid();
        this.imageFrameStorage.deleteMap(imageIndex);
        imageMap.stop();
        this.saveDeletedMaps();
        Bukkit.getPluginManager().callEvent((Event)new ImageMapDeletedEvent(imageMap));
        Scheduler.runTask((Plugin)ImageFrame.plugin, () -> mapViews.forEach(each -> {
            if (each.getRenderers().isEmpty()) {
                each.addRenderer((MapRenderer)DeletedMapRenderer.INSTANCE);
            }
        }));
        return true;
    }

    public synchronized void updateMap(int imageIndex, boolean exist) {
        ImageMap imageMap = this.maps.get(imageIndex);
        try {
            if (imageMap == null) {
                if (exist) {
                    JsonObject json = this.imageFrameStorage.loadImageMapData(imageIndex);
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        try {
                            this.addMap(ImageMapLoaders.load(this, json).get());
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to update map " + imageIndex + " from source", e);
                        }
                    });
                }
            } else if (exist) {
                JsonObject json = this.imageFrameStorage.loadImageMapData(imageIndex);
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    if (imageMap.applyUpdate(json)) {
                        imageMap.reloadColorCache();
                        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap));
                    }
                });
            } else {
                this.deleteMap(imageIndex);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to update map " + imageIndex + " from source", e);
        }
    }

    public Set<Integer> getDeletedMapIds() {
        return Collections.unmodifiableSet(this.deletedMapIds);
    }

    public boolean isMapDeleted(int mapId) {
        return this.deletedMapIds.contains(mapId);
    }

    public boolean isMapDeleted(MapView mapView) {
        return this.isMapDeleted(mapView.getId());
    }

    public synchronized void loadMaps(IFPlayerManager ifPlayerManager) {
        this.maps.clear();
        this.mapsByView.clear();
        List<MutablePair<String, Future<? extends ImageMap>>> futures = this.imageFrameStorage.loadMaps(this, this.deletedMapIds, ifPlayerManager);
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
            int count = 0;
            for (MutablePair pair : futures) {
                try {
                    this.addMap((ImageMap)((Future)pair.getSecond()).get());
                    ++count;
                }
                catch (Throwable e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMap data in " + (String)pair.getFirst());
                    e.printStackTrace();
                }
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Data loading completed! Loaded " + count + " ImageMaps!");
        });
    }

    public void syncMaps() {
        this.syncMaps(false);
    }

    public synchronized void syncMaps(boolean verbose) {
        Set<Integer> indexesFromStorage = this.imageFrameStorage.getAllImageIndexes();
        Set<Integer> indexesFromLocal = this.maps.keySet();
        int added = 0;
        int deleted = 0;
        UnmodifiableIterator unmodifiableIterator = Sets.symmetricDifference(indexesFromStorage, indexesFromLocal).iterator();
        while (unmodifiableIterator.hasNext()) {
            int index = (Integer)unmodifiableIterator.next();
            try {
                boolean exist = indexesFromStorage.contains(index);
                this.updateMap(index, exist);
                if (exist) {
                    ++added;
                    continue;
                }
                ++deleted;
            }
            catch (Throwable e) {
                if (verbose) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to sync ImageMap data for index " + index);
                }
                e.printStackTrace();
            }
        }
        if (verbose) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Data sync completed! Newly loaded " + added + " and deleted " + deleted + " ImageMaps!");
        }
    }

    public synchronized void saveDeletedMaps() {
        this.imageFrameStorage.saveDeletedMaps(this.deletedMapIds);
    }

    public void sendAllMaps(Collection<? extends Player> players) {
        this.maps.values().forEach(m -> m.send(players));
    }

    public static class DeletedMapRenderer
    extends MapRenderer {
        public static final DeletedMapRenderer INSTANCE = new DeletedMapRenderer();

        private DeletedMapRenderer() {
        }

        public void render(MapView map, MapCanvas canvas, Player player) {
            List mapRenderers = map.getRenderers();
            if (mapRenderers.size() != 1 || mapRenderers.get(0) != this) {
                Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> map.removeRenderer((MapRenderer)this), 1L);
                return;
            }
            Random random = new Random(map.getId());
            byte[] colors = MapUtils.PALETTE_GRAYSCALE;
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    canvas.setPixel(x, y, colors[random.nextInt(colors.length)]);
                }
            }
        }
    }
}

