/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.imageframe.objectholders.PreferenceState;
import com.loohp.imageframe.objectholders.UnsetState;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;

public enum BooleanState implements UnsetState,
PreferenceState
{
    TRUE(new JsonPrimitive(true), true, NamedTextColor.GREEN),
    FALSE(new JsonPrimitive(false), false, NamedTextColor.RED),
    UNSET(UNSET_JSON, null, NamedTextColor.GRAY);

    public static final Map<String, BooleanState> STRING_VALUES_MAP;
    public static final Map<Boolean, BooleanState> BOOLEAN_VALUES_MAP;
    private final JsonElement jsonValue;
    private final Boolean booleanValue;
    private final TextColor displayColor;

    private BooleanState(JsonElement jsonValue, Boolean booleanValue, TextColor displayColor) {
        this.jsonValue = jsonValue;
        this.booleanValue = booleanValue;
        this.displayColor = displayColor;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    @Override
    public boolean isUnset() {
        return this.equals(UNSET);
    }

    @Override
    public JsonElement getJsonValue() {
        return this.jsonValue;
    }

    @Override
    public TextColor getDisplayColor() {
        return this.displayColor;
    }

    public Boolean getRawValue() {
        return this.booleanValue;
    }

    public boolean getRawValue(boolean unsetIsTrue) {
        return this.booleanValue == null ? unsetIsTrue : this.booleanValue;
    }

    public boolean getCalculatedValue(BooleanSupplier unsetValueFunction) {
        return this.booleanValue == null ? unsetValueFunction.getAsBoolean() : this.booleanValue.booleanValue();
    }

    public static BooleanState fromBoolean(boolean value) {
        return BooleanState.fromBoolean((Boolean)value);
    }

    public static BooleanState fromBoolean(Boolean value) {
        return BOOLEAN_VALUES_MAP.getOrDefault(value, UNSET);
    }

    public static BooleanState fromString(String value) {
        return STRING_VALUES_MAP.getOrDefault(value.toLowerCase(), UNSET);
    }

    public static BooleanState fromJsonValue(JsonElement jsonValue) {
        if (jsonValue.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonValue.getAsJsonPrimitive();
            if (jsonPrimitive.isBoolean()) {
                return BooleanState.fromBoolean(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isNumber()) {
                return BooleanState.fromBoolean(jsonPrimitive.getAsNumber().intValue() != 0);
            }
            if (jsonPrimitive.isString()) {
                return BooleanState.fromString(jsonPrimitive.getAsString());
            }
        }
        return UNSET;
    }

    static {
        STRING_VALUES_MAP = Collections.unmodifiableMap(Arrays.stream(BooleanState.values()).collect(Collectors.toMap(e -> e.toString(), e -> e, (x, y) -> y, LinkedHashMap::new)));
        BOOLEAN_VALUES_MAP = Collections.unmodifiableMap(Arrays.stream(BooleanState.values()).collect(Collectors.toMap(e -> e.booleanValue, e -> e, (x, y) -> y, LinkedHashMap::new)));
    }
}

