/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.migration;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.org.simpleyaml.configuration.file.YamlFile;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.ImageMapLoaders;
import com.loohp.imageframe.objectholders.NonUpdatableImageMapCreateInfo;
import com.loohp.imageframe.objectholders.NonUpdatableStaticImageMap;
import com.loohp.imageframe.objectholders.NonUpdatableStaticImageMapLoader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;

public class ImageOnMapMigration
implements ExternalPluginMigration {
    public static final String PLUGIN_NAME = "ImageOnMap";

    @Override
    public String externalPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean requirePlayer() {
        return false;
    }

    @Override
    public void migrate(UUID unused) {
        if (Bukkit.getPluginManager().isPluginEnabled(PLUGIN_NAME)) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] ImageOnMap must be disabled for migration to begin");
            return;
        }
        File migrationMarker = new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageOnMap/imageframe-migrated.bin");
        if (migrationMarker.exists()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[ImageFrame] ImageOnMap data already marked as migrated");
            return;
        }
        File userFolder = new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageOnMap/maps");
        if (!userFolder.exists() || !userFolder.isDirectory()) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] ImageOnMap plugin data folder not found");
            return;
        }
        NonUpdatableStaticImageMapLoader loader = ImageMapLoaders.getLoader(NonUpdatableStaticImageMapLoader.class);
        File imageFolder = new File(ImageFrame.plugin.getDataFolder().getParent() + "/ImageOnMap/images");
        for (File file : userFolder.listFiles()) {
            UUID owner;
            String fileNameWithoutExtension = file.getName().substring(0, file.getName().lastIndexOf("."));
            try {
                owner = UUID.fromString(fileNameWithoutExtension);
            }
            catch (IllegalArgumentException e) {
                owner = Bukkit.getOfflinePlayer((String)fileNameWithoutExtension).getUniqueId();
            }
            try {
                YamlFile yaml = YamlFile.loadConfiguration(file);
                List<?> mapList = yaml.getList("PlayerMapStore.mapList");
                if (mapList == null) continue;
                int index = 0;
                for (Map section : mapList) {
                    try {
                        int height;
                        int width;
                        BufferedImage[] images;
                        List<Integer> mapIds;
                        String name = ((String)section.get("name")).replace(" ", "_");
                        String iomId = (String)section.get("id");
                        String type = (String)section.get("type");
                        if (type.equalsIgnoreCase("SINGLE")) {
                            int mapId = (Integer)section.get("mapID");
                            mapIds = Collections.singletonList(mapId);
                            images = new BufferedImage[]{ImageIO.read(new File(imageFolder, "map" + mapId + ".png"))};
                            width = 1;
                            height = 1;
                        } else if (type.equalsIgnoreCase("POSTER")) {
                            mapIds = new ArrayList<Integer>((List)section.get("mapsIDs"));
                            images = new BufferedImage[mapIds.size()];
                            width = (Integer)section.get("columns");
                            height = (Integer)section.get("rows");
                            for (int i = 0; i < images.length; ++i) {
                                images[i] = ImageIO.read(new File(imageFolder, "map" + mapIds.get(i) + ".png"));
                            }
                        } else {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to migrate " + name + " ImageOnMap user file " + file.getName() + ": Unknown type " + type);
                            continue;
                        }
                        NonUpdatableStaticImageMap imageMap = ImageFrame.imageMapManager.getFromCreator(owner, name) == null ? loader.create(new NonUpdatableImageMapCreateInfo(ImageFrame.imageMapManager, name, images, mapIds, width, height, DitheringType.NEAREST_COLOR, owner)).get() : (ImageFrame.imageMapManager.getFromCreator(owner, iomId) == null ? loader.create(new NonUpdatableImageMapCreateInfo(ImageFrame.imageMapManager, iomId, images, mapIds, width, height, DitheringType.NEAREST_COLOR, owner)).get() : loader.create(new NonUpdatableImageMapCreateInfo(ImageFrame.imageMapManager, "ImageOnMap-" + iomId, images, mapIds, width, height, DitheringType.NEAREST_COLOR, owner)).get());
                        ImageFrame.imageMapManager.addMap(imageMap);
                        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Migrated ImageOnMap " + file.getName() + " to " + name + " of " + owner);
                    }
                    catch (Exception e) {
                        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to migrate ImageOnMap " + file.getName() + " of index " + index);
                        e.printStackTrace();
                    }
                    ++index;
                }
            }
            catch (IOException e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to migrate ImageOnMap user file " + file.getAbsolutePath());
                e.printStackTrace();
            }
        }
        try {
            migrationMarker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] ImageOnMap migration complete!");
    }
}

