/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.nms.NMS;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;

public class RateLimitedPacketSendingManager
implements Listener {
    private final Map<Player, Long> loginTime = new ConcurrentHashMap<Player, Long>();
    private final Map<Player, Queue<ScheduleEntry>> playerPacketQueue = new ConcurrentHashMap<Player, Queue<ScheduleEntry>>();
    private final ExecutorService packetSendingService = Executors.newFixedThreadPool(4);

    public RateLimitedPacketSendingManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
        Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, () -> this.run(), 0L, 1L);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.playerPacketQueue.put(player, new ConcurrentLinkedQueue());
        }
    }

    public boolean queue(Player player, Object packet, BiConsumer<Player, Boolean> completionCallback) {
        Queue<ScheduleEntry> queue = this.playerPacketQueue.get(player);
        if (queue != null) {
            return queue.add(new ScheduleEntry(packet, completionCallback));
        }
        if (completionCallback != null) {
            completionCallback.accept(player, false);
        }
        return false;
    }

    private void run() {
        int rateLimit = ImageFrame.rateLimit;
        long now = System.currentTimeMillis();
        for (Map.Entry<Player, Queue<ScheduleEntry>> entry : this.playerPacketQueue.entrySet()) {
            ScheduleEntry scheduleEntry;
            Player player = entry.getKey();
            if (now - this.loginTime.getOrDefault(player, now) < 500L) continue;
            Queue<ScheduleEntry> queue = entry.getValue();
            for (int counter = 0; (rateLimit < 0 || counter < rateLimit) && (scheduleEntry = queue.poll()) != null; ++counter) {
                this.packetSendingService.execute(() -> {
                    NMS.getInstance().sendPacket(player, scheduleEntry.getPacket());
                    BiConsumer<Player, Boolean> completionCallback = scheduleEntry.getCompletionCallback();
                    if (completionCallback != null) {
                        completionCallback.accept(player, true);
                    }
                });
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.loginTime.put(player, System.currentTimeMillis());
        this.playerPacketQueue.put(player, new ConcurrentLinkedQueue());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.loginTime.remove(player);
        this.playerPacketQueue.remove(player);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)ImageFrame.plugin)) {
            this.packetSendingService.shutdown();
        }
    }

    public static class ScheduleEntry {
        private final Object packet;
        private final BiConsumer<Player, Boolean> completionCallback;

        public ScheduleEntry(Object packet, BiConsumer<Player, Boolean> completionCallback) {
            this.packet = packet;
            this.completionCallback = completionCallback;
        }

        public Object getPacket() {
            return this.packet;
        }

        public BiConsumer<Player, Boolean> getCompletionCallback() {
            return this.completionCallback;
        }
    }
}

