/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class IFPlayerManager
implements AutoCloseable,
Listener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final File dataFolder;
    private final Map<UUID, IFPlayer> loadedPlayers;
    private final Set<IFPlayer> persistentLoadedPlayers;

    public IFPlayerManager(File dataFolder) {
        this.dataFolder = dataFolder;
        Cache playersCache = CacheBuilder.newBuilder().weakValues().build();
        this.loadedPlayers = playersCache.asMap();
        this.persistentLoadedPlayers = ConcurrentHashMap.newKeySet();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> this.persistentLoadedPlayers.add(this.getIFPlayer(event.getPlayer().getUniqueId())));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        IFPlayer ifPlayer = this.loadedPlayers.get(event.getPlayer().getUniqueId());
        if (ifPlayer != null) {
            Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                try {
                    ifPlayer.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.persistentLoadedPlayers.remove(ifPlayer);
            });
        }
    }

    public IFPlayer getIFPlayer(UUID uuid) {
        return this.loadedPlayers.computeIfAbsent(uuid, k -> {
            this.dataFolder.mkdirs();
            File file = new File(this.dataFolder, uuid + ".json");
            if (file.exists()) {
                IFPlayer iFPlayer;
                BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                try {
                    iFPlayer = IFPlayer.load(this, GSON.fromJson((Reader)reader, JsonObject.class));
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        new RuntimeException("Unable to load ImageFrame player data from " + file.getAbsolutePath(), e).printStackTrace();
                        try {
                            Files.copy(file.toPath(), new File(file.getParentFile(), file.getName() + ".bak").toPath(), new CopyOption[0]);
                        }
                        catch (IOException ex) {
                            new RuntimeException("Unable to backup ImageFrame player data from " + file.getAbsolutePath(), ex).printStackTrace();
                        }
                    }
                }
                reader.close();
                return iFPlayer;
            }
            return this.createNewIfPlayer(uuid);
        });
    }

    private IFPlayer createNewIfPlayer(UUID uuid) {
        try {
            return IFPlayer.create(this, uuid);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create ImageFrame player data for " + uuid, e);
        }
    }
}

