/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.objectholders.IFPlayerManager;
import com.loohp.imageframe.objectholders.IFPlayerPreference;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class IFPlayer {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final IFPlayerManager manager;
    private final UUID uuid;
    private final Map<IFPlayerPreference<?>, Object> preferences;

    public static IFPlayer create(IFPlayerManager manager, UUID player) throws Exception {
        IFPlayer ifPlayer = new IFPlayer(manager, player, Collections.emptyMap());
        ifPlayer.save();
        return ifPlayer;
    }

    public static IFPlayer load(IFPlayerManager manager, JsonObject json) {
        UUID uuid = UUID.fromString(json.get("uuid").getAsString());
        HashMap preferences = new HashMap();
        JsonObject preferenceJson = json.get("preferences").getAsJsonObject();
        for (IFPlayerPreference<?> preference : IFPlayerPreference.values()) {
            JsonElement element = preferenceJson.get(preference.getJsonName());
            if (element == null) continue;
            preferences.put(preference, preference.getDeserializer().apply(element));
        }
        return new IFPlayer(manager, uuid, preferences);
    }

    private IFPlayer(IFPlayerManager manager, UUID uuid, Map<IFPlayerPreference<?>, ?> preferences) {
        this.manager = manager;
        this.uuid = uuid;
        this.preferences = new ConcurrentHashMap(preferences);
    }

    public OfflinePlayer getLocalPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public String getName() {
        return this.getLocalPlayer().getName();
    }

    public UUID getUniqueId() {
        return this.uuid;
    }

    public Object getPreference(IFPlayerPreference<?> preference) {
        return this.preferences.computeIfAbsent(preference, k -> preference.getDefaultValue(this));
    }

    public <T> T getPreference(IFPlayerPreference<?> preference, Class<T> type) {
        return (T)this.preferences.computeIfAbsent(preference, k -> preference.getDefaultValue(this, type));
    }

    public void setPreference(IFPlayerPreference<?> preference, Object value) {
        this.preferences.put(preference, value);
    }

    public void save() throws Exception {
        this.manager.getDataFolder().mkdirs();
        File file = new File(this.manager.getDataFolder(), this.uuid + ".json");
        JsonObject json = new JsonObject();
        json.addProperty("uuid", this.uuid.toString());
        JsonObject preferenceJson = new JsonObject();
        for (Map.Entry<IFPlayerPreference<?>, Object> entry : this.preferences.entrySet()) {
            IFPlayerPreference<?> preference = entry.getKey();
            preferenceJson.add(preference.getJsonName(), preference.getSerializer(Object.class).apply(entry.getValue()));
        }
        json.add("preferences", preferenceJson);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(GSON.toJson(json));
            pw.flush();
        }
    }
}

