/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class BlockPosition {
    private final WeakReference<World> world;
    private final int x;
    private final int y;
    private final int z;

    public BlockPosition(World world, int x, int y, int z) {
        this.world = new WeakReference<World>(world);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean isWorldLoaded() {
        World world = (World)this.world.get();
        return world != null && Bukkit.getWorld((UUID)world.getUID()) != null;
    }

    public World getWorld() {
        return (World)this.world.get();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Block getBlock() {
        return this.getWorld().getBlockAt(this.x, this.y, this.z);
    }

    public Location toLocation() {
        return new Location(this.getWorld(), (double)this.x, (double)this.y, (double)this.z);
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public BoundingBox toBoundingBox() {
        return new BoundingBox((double)this.x, (double)this.y, (double)this.z, (double)(this.x + 1), (double)(this.y + 1), (double)(this.z + 1));
    }
}

