/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.migration.ExternalPluginMigration;
import com.loohp.imageframe.migration.PluginMigrationRegistry;
import com.loohp.imageframe.objectholders.BlockPosition;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.IFPlayerPreference;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessControl;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapCreationTask;
import com.loohp.imageframe.objectholders.ImageMapCreationTaskManager;
import com.loohp.imageframe.objectholders.ItemFrameSelectionManager;
import com.loohp.imageframe.objectholders.MapMarkerEditManager;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMap;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.URLAnimatedImageMap;
import com.loohp.imageframe.objectholders.URLImageMap;
import com.loohp.imageframe.objectholders.URLStaticImageMap;
import com.loohp.imageframe.updater.Updater;
import com.loohp.imageframe.upload.ImageUploadManager;
import com.loohp.imageframe.upload.PendingUpload;
import com.loohp.imageframe.utils.ChatColorUtils;
import com.loohp.imageframe.utils.CommandSenderUtils;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import com.loohp.imageframe.utils.ImageMapUtils;
import com.loohp.imageframe.utils.MCVersion;
import com.loohp.imageframe.utils.MapUtils;
import com.loohp.imageframe.utils.MathUtils;
import com.loohp.imageframe.utils.PlayerUtils;
import com.loohp.interactivechat.libs.com.loohp.platformscheduler.Scheduler;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class Commands
implements CommandExecutor,
TabCompleter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        ImageMap imageMap;
        if (args.length == 0) {
            CommandSenderUtils.sendMessage(sender, ChatColor.DARK_AQUA + "ImageFrame written by LOOHP!");
            CommandSenderUtils.sendMessage(sender, ChatColor.GOLD + "You are running ImageFrame version: " + ImageFrame.plugin.getDescription().getVersion());
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("imageframe.reload")) {
                ImageFrame.plugin.reloadConfig();
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageReloaded);
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
            return true;
        }
        if (args[0].equalsIgnoreCase("update")) {
            if (sender.hasPermission("imageframe.update")) {
                CommandSenderUtils.sendMessage(sender, ChatColor.DARK_AQUA + "[ImageFrame] ImageFrame written by LOOHP!");
                CommandSenderUtils.sendMessage(sender, ChatColor.GOLD + "[ImageFrame] You are running ImageFrame version: " + ImageFrame.plugin.getDescription().getVersion());
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    Updater.UpdaterResponse version = Updater.checkUpdate();
                    if (version.getResult().equals("latest")) {
                        if (version.isDevBuildLatest()) {
                            CommandSenderUtils.sendMessage(sender, ChatColor.GREEN + "[ImageFrame] You are running the latest version!");
                        } else {
                            Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId(), true);
                        }
                    } else {
                        Updater.sendUpdateMessage(sender, version.getResult(), version.getSpigotPluginId());
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
            return true;
        }
        if (args[0].equalsIgnoreCase("create")) {
            if (!sender.hasPermission("imageframe.create")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length != 4 && args.length != 5 && args.length != 6 && args.length != 7) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            try {
                int takenMaps;
                DitheringType ditheringType;
                int height;
                int width;
                ItemFrameSelectionManager.SelectedItemFrameResult selection;
                boolean combined;
                boolean isAdmin;
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                String name = pair.getSecond();
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                Player player = isConsole ? null : (Player)sender;
                UUID owner = pair.getFirst();
                boolean bl2 = isAdmin = isConsole || !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                boolean bl3 = combined = args.length == 6 && args[5].equalsIgnoreCase("combined") || args.length == 7 && args[6].equalsIgnoreCase("combined");
                if (args[3].equalsIgnoreCase("selection")) {
                    if (isConsole) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                        return true;
                    }
                    selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionNoSelection);
                        return true;
                    }
                } else {
                    if (args.length != 5 && args.length != 6 && args.length != 7) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                        return true;
                    }
                    selection = null;
                }
                if (selection == null) {
                    width = Integer.parseInt(args[3]);
                    height = Integer.parseInt(args[4]);
                    ditheringType = DitheringType.fromName(args.length > 5 && !args[5].equalsIgnoreCase("combined") ? args[5].toLowerCase() : null);
                } else {
                    width = selection.getWidth();
                    height = selection.getHeight();
                    ditheringType = DitheringType.fromName(args.length > 4 ? args[4].toLowerCase() : null);
                }
                if (width * height > ImageFrame.mapMaxSize) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageOversize.replace("{MaxSize}", ImageFrame.mapMaxSize + ""));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messagePlayerCreationLimitReached.replace("{Limit}", limit + ""));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageDuplicateMapName);
                    return true;
                }
                if (!ImageFrame.isURLAllowed(args[2])) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageURLRestricted);
                    return true;
                }
                if (ImageFrame.requireEmptyMaps && !isConsole) {
                    takenMaps = MapUtils.removeEmptyMaps(player, width * height, true);
                    if (takenMaps < 0) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotEnoughMaps.replace("{Amount}", width * height + ""));
                        return true;
                    }
                } else {
                    takenMaps = 0;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block15: {
                        ImageMapCreationTask<ImageMap> creationTask = null;
                        String url = "Pending...";
                        try {
                            url = args[2];
                            if (ImageFrame.uploadServiceEnabled && url.equalsIgnoreCase("upload")) {
                                UUID user = isConsole ? ImageMap.CONSOLE_CREATOR : player.getUniqueId();
                                PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                                Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadLink.replace("{URL}", pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user))), 2L);
                                url = pendingUpload.getFileBlocking().toURI().toURL().toString();
                            }
                            if (HTTPRequestUtils.getContentSize(url) > ImageFrame.maxImageFileSize) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageOverMaxFileSize.replace("{Size}", ImageFrame.maxImageFileSize + ""));
                                throw new IOException("Image over max file size");
                            }
                            String imageType = HTTPRequestUtils.getContentType(url);
                            if (imageType == null) {
                                imageType = URLConnection.guessContentTypeFromName(url);
                            }
                            imageType = imageType == null ? "" : imageType.trim();
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapProcessing);
                            String finalUrl = url;
                            String finalImageType = imageType;
                            creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, width, height, () -> {
                                if (finalImageType.equals("image/gif") && sender.hasPermission("imageframe.create.animated")) {
                                    return URLAnimatedImageMap.create(ImageFrame.imageMapManager, name, finalUrl, width, height, ditheringType, owner).get();
                                }
                                return URLStaticImageMap.create(ImageFrame.imageMapManager, name, finalUrl, width, height, ditheringType, owner).get();
                            });
                            ImageMap imageMap = (ImageMap)creationTask.get();
                            ImageFrame.imageMapManager.addMap(imageMap);
                            if (!isConsole) {
                                if (combined) {
                                    ImageFrame.combinedMapItemHandler.giveCombinedMap(imageMap, player);
                                } else if (selection == null) {
                                    imageMap.giveMaps(player, ImageFrame.mapItemFormat);
                                } else {
                                    AtomicBoolean flag = new AtomicBoolean(false);
                                    imageMap.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                                        ItemStack originalItem = frame.getItem();
                                        if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                                            return false;
                                        }
                                        return PlayerUtils.isInteractionAllowed(player, (Entity)frame);
                                    }, (frame, item) -> {
                                        PlayerUtils.giveItem(player, item);
                                        if (!flag.getAndSet(true)) {
                                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageItemFrameOccupied);
                                        }
                                    }, ImageFrame.mapItemFormat);
                                }
                            }
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapCreated);
                            creationTask.complete(ImageFrame.messageImageMapCreated);
                        }
                        catch (ImageUploadManager.LinkTimeoutException e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadExpired);
                            if (takenMaps > 0 && !isConsole) {
                                PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                            }
                        }
                        catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapAlreadyQueued);
                            if (takenMaps > 0 && !isConsole) {
                                PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                            }
                        }
                        catch (Exception e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                            if (creationTask != null) {
                                creationTask.complete(ImageFrame.messageUnableToLoadMap);
                            }
                            new IOException("Unable to download image. Make sure you are using a direct link to the image, they usually ends with a file extension like \".png\". Dispatcher: " + sender.getName() + " URL: " + url, e).printStackTrace();
                            if (takenMaps <= 0 || isConsole) break block15;
                            PlayerUtils.giveItem(player, new ItemStack(Material.MAP, takenMaps));
                        }
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("overlay")) {
            if (!sender.hasPermission("imageframe.overlay")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length != 3 && args.length != 4 && args.length != 5) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (!(sender instanceof Player)) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                return true;
            }
            try {
                DitheringType ditheringType;
                int height;
                int width;
                List<MapView> mapViews;
                boolean isAdmin;
                Player player = (Player)sender;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                String name = pair.getSecond();
                if (pair.getFirst() == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                UUID owner = pair.getFirst();
                boolean bl = isAdmin = !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if ((args.length == 4 || args.length == 5) && args[3].equalsIgnoreCase("selection")) {
                    ItemFrameSelectionManager.SelectedItemFrameResult selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        player.sendMessage(ImageFrame.messageSelectionNoSelection);
                        return true;
                    }
                    mapViews = selection.getMapViews();
                    width = selection.getWidth();
                    height = selection.getHeight();
                    ditheringType = DitheringType.fromName(args.length == 5 ? args[4].toLowerCase() : null);
                } else {
                    if (args.length != 3 && args.length != 4) {
                        player.sendMessage(ImageFrame.messageInvalidUsage);
                        return true;
                    }
                    mapViews = Collections.singletonList(MapUtils.getPlayerMapView(player));
                    width = 1;
                    height = 1;
                    ditheringType = DitheringType.fromName(args.length == 4 ? args[3].toLowerCase() : null);
                }
                if (mapViews.contains(null)) {
                    player.sendMessage(ImageFrame.messageSelectionInvalid);
                    return true;
                }
                if (mapViews.stream().anyMatch(each -> ImageFrame.imageMapManager.getFromMapView((MapView)each) != null) || mapViews.stream().distinct().count() < (long)mapViews.size()) {
                    player.sendMessage(ImageFrame.messageInvalidOverlayMap);
                    return true;
                }
                if (width * height > ImageFrame.mapMaxSize) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageOversize.replace("{MaxSize}", ImageFrame.mapMaxSize + ""));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messagePlayerCreationLimitReached.replace("{Limit}", limit + ""));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageDuplicateMapName);
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    ImageMapCreationTask<ImageMap> creationTask = null;
                    try {
                        String url = args[2];
                        if (ImageFrame.uploadServiceEnabled && url.equalsIgnoreCase("upload")) {
                            UUID user = player.getUniqueId();
                            PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                            Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadLink.replace("{URL}", pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user))), 2L);
                            url = pendingUpload.getFileBlocking().toURI().toURL().toString();
                        }
                        if (!ImageFrame.isURLAllowed(url)) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageURLRestricted);
                            return;
                        }
                        if (HTTPRequestUtils.getContentSize(url) > ImageFrame.maxImageFileSize) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageOverMaxFileSize.replace("{Size}", ImageFrame.maxImageFileSize + ""));
                            throw new IOException("Image over max file size");
                        }
                        String finalUrl = url;
                        creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, width, height, () -> MinecraftURLOverlayImageMap.create(ImageFrame.imageMapManager, name, finalUrl, mapViews, width, height, ditheringType, player.getUniqueId()).get());
                        ImageMap imageMap = (ImageMap)creationTask.get();
                        ImageFrame.imageMapManager.addMap(imageMap);
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapCreated);
                        creationTask.complete(ImageFrame.messageImageMapCreated);
                    }
                    catch (ImageUploadManager.LinkTimeoutException e) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadExpired);
                    }
                    catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapAlreadyQueued);
                    }
                    catch (Exception e) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                        if (creationTask != null) {
                            creationTask.complete(ImageFrame.messageUnableToLoadMap);
                        }
                        e.printStackTrace();
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("clone")) {
            if (!sender.hasPermission("imageframe.clone")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length != 3 && args.length != 4) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            try {
                int takenMaps;
                ImageMap imageMap2;
                ItemFrameSelectionManager.SelectedItemFrameResult selection;
                boolean combined;
                boolean isAdmin;
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[2]);
                String name = pair.getSecond();
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                Player player = isConsole ? null : (Player)sender;
                UUID owner = pair.getFirst();
                boolean bl4 = isAdmin = isConsole || !owner.equals(player.getUniqueId());
                if (isAdmin && !sender.hasPermission("imageframe.create.others")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                boolean bl5 = combined = args.length > 3 && args[3].equalsIgnoreCase("combined");
                if (args.length > 3 && args[3].equalsIgnoreCase("selection")) {
                    selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)player);
                    if (selection == null) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionNoSelection);
                        return true;
                    }
                } else {
                    selection = null;
                }
                if ((imageMap2 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1])) == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap2, sender, ImageMapAccessPermissionType.EDIT_CLONE)) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (selection != null && (imageMap2.getWidth() != selection.getWidth() || imageMap2.getHeight() != selection.getHeight())) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionIncorrectSize.replace("{Width}", imageMap2.getWidth() + "").replace("{Height}", imageMap2.getHeight() + ""));
                    return true;
                }
                int limit = isAdmin ? -1 : ImageFrame.getPlayerCreationLimit(player);
                Set<ImageMap> existingMaps = ImageFrame.imageMapManager.getFromCreator(owner);
                if (limit >= 0 && existingMaps.size() >= limit) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messagePlayerCreationLimitReached.replace("{Limit}", limit + ""));
                    return true;
                }
                if (existingMaps.stream().anyMatch(each -> each.getName().equalsIgnoreCase(name))) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageDuplicateMapName);
                    return true;
                }
                if (ImageFrame.requireEmptyMaps && !isConsole) {
                    takenMaps = MapUtils.removeEmptyMaps(player, imageMap2.getWidth() * imageMap2.getHeight(), true);
                    if (takenMaps < 0) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotEnoughMaps.replace("{Amount}", imageMap2.getWidth() * imageMap2.getHeight() + ""));
                        return true;
                    }
                } else {
                    takenMaps = 0;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block9: {
                        ImageMapCreationTask<ImageMap> creationTask = null;
                        try {
                            creationTask = ImageFrame.imageMapCreationTaskManager.enqueue(owner, name, imageMap2.getWidth(), imageMap2.getHeight(), () -> imageMap2.deepClone(name, owner));
                            ImageMap newImageMap = (ImageMap)creationTask.get();
                            ImageFrame.imageMapManager.addMap(newImageMap);
                            if (!isConsole) {
                                if (combined) {
                                    ImageFrame.combinedMapItemHandler.giveCombinedMap(newImageMap, player);
                                } else if (selection == null) {
                                    newImageMap.giveMaps(player, ImageFrame.mapItemFormat);
                                } else {
                                    AtomicBoolean flag = new AtomicBoolean(false);
                                    newImageMap.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                                        ItemStack originalItem = frame.getItem();
                                        if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                                            return false;
                                        }
                                        return PlayerUtils.isInteractionAllowed(player, (Entity)frame);
                                    }, (frame, item) -> {
                                        PlayerUtils.giveItem(player, item);
                                        if (!flag.getAndSet(true)) {
                                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageItemFrameOccupied);
                                        }
                                    }, ImageFrame.mapItemFormat);
                                }
                            }
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapCreated);
                            creationTask.complete(ImageFrame.messageImageMapCreated);
                        }
                        catch (ImageMapCreationTaskManager.EnqueueRejectedException e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapAlreadyQueued);
                        }
                        catch (Exception e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                            if (creationTask != null) {
                                creationTask.complete(ImageFrame.messageUnableToLoadMap);
                            }
                            e.printStackTrace();
                            if (takenMaps <= 0 || isConsole) break block9;
                            PlayerUtils.giveItem((Player)sender, new ItemStack(Material.MAP, takenMaps));
                        }
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("playback")) {
            if (!sender.hasPermission("imageframe.playback")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            try {
                boolean isConsole;
                MutablePair<UUID, String> pair = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, args[1]);
                boolean bl = isConsole = !(sender instanceof Player);
                if (pair.getFirst() == null && isConsole) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                ImageMap imageMap3 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                if (imageMap3 == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap3, sender, ImageMapAccessPermissionType.ADJUST_PLAYBACK)) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        if (args[2].equalsIgnoreCase("pause")) {
                            if (imageMap3.requiresAnimationService()) {
                                imageMap3.setAnimationPause(!imageMap3.isAnimationPaused());
                            }
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapTogglePaused);
                        } else if (args[2].equalsIgnoreCase("jumpto") && args.length > 3) {
                            try {
                                double seconds = Double.parseDouble(args[3]);
                                if (imageMap3.requiresAnimationService()) {
                                    imageMap3.setAnimationPlaybackTime(seconds);
                                }
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapPlaybackJumpTo.replace("{Seconds}", String.valueOf(seconds)));
                            }
                            catch (NumberFormatException e) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            catch (Exception e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                e.printStackTrace();
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("select")) {
            if (!sender.hasPermission("imageframe.select")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length == 1) {
                if (!(sender instanceof Player)) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                Player player = (Player)sender;
                if (ImageFrame.itemFrameSelectionManager.isInSelection((CommandSender)player)) {
                    ImageFrame.itemFrameSelectionManager.setInSelection((CommandSender)player, false);
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionClear);
                    return true;
                }
                ImageFrame.itemFrameSelectionManager.setInSelection((CommandSender)player, true);
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionBegin);
                return true;
            }
            if (args.length != 8 && args.length != 9) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            try {
                float yaw;
                World world = Bukkit.getWorld((String)args[1]);
                if (world == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                int x1 = Integer.parseInt(args[2]);
                int y1 = Integer.parseInt(args[3]);
                int z1 = Integer.parseInt(args[4]);
                int x2 = Integer.parseInt(args[5]);
                int y2 = Integer.parseInt(args[6]);
                int z2 = Integer.parseInt(args[7]);
                BlockPosition pos1 = new BlockPosition(world, x1, y1, z1);
                BlockPosition pos2 = new BlockPosition(world, x2, y2, z2);
                if (args.length == 9) {
                    yaw = Float.parseFloat(args[8]);
                } else {
                    float f = yaw = sender instanceof Player ? ((Player)sender).getLocation().getYaw() : 0.0f;
                }
                if (ImageFrame.itemFrameSelectionManager.isInSelection(sender)) {
                    ImageFrame.itemFrameSelectionManager.setInSelection(sender, false);
                }
                ImageFrame.itemFrameSelectionManager.applyDirectItemFrameSelection(sender, yaw, pos1, pos2);
                return true;
            }
            catch (NumberFormatException e) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
        }
        if (args[0].equalsIgnoreCase("marker")) {
            if (!sender.hasPermission("imageframe.marker")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (!(sender instanceof Player)) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                return true;
            }
            Player player = (Player)sender;
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (args[1].equalsIgnoreCase("add")) {
                if (args.length <= 5) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                ImageMap imageMap4 = ImageMapUtils.getFromPlayerPrefixedName((CommandSender)player, args[2]);
                if (imageMap4 == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                if (!ImageFrame.hasImageMapPermission(imageMap4, sender, ImageMapAccessPermissionType.MARKER)) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (ImageFrame.mapMarkerEditManager.isActiveEditing(player)) {
                    ImageFrame.mapMarkerEditManager.leaveActiveEditing(player);
                }
                try {
                    String name = args[3];
                    if (imageMap4.getMapMarker(name) != null) {
                        player.sendMessage(ImageFrame.messageMarkersDuplicateName);
                        return true;
                    }
                    byte direction = Byte.parseByte(args[4]);
                    MapCursor.Type type = MapCursor.Type.valueOf((String)args[5].toUpperCase());
                    String caption = args.length > 6 ? ChatColorUtils.translateAlternateColorCodes('&', String.join((CharSequence)" ", Arrays.copyOfRange(args, 6, args.length))) : null;
                    MapCursor mapCursor = new MapCursor(0, 0, direction, type, true, caption);
                    ImageFrame.mapMarkerEditManager.setActiveEditing(player, name, mapCursor, imageMap4);
                    if (!MapUtils.isRenderOnFrame(type)) {
                        player.sendMessage(ImageFrame.messageMarkersNotRenderOnFrameWarning);
                    }
                    player.sendMessage(ImageFrame.messageMarkersAddBegin.replace("{Name}", imageMap4.getName()));
                    return true;
                }
                catch (IllegalArgumentException e) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
            }
            if (args[1].equalsIgnoreCase("remove")) {
                if (args.length <= 3) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                ImageMap imageMap5 = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), args[2]);
                if (imageMap5 == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    for (Map<String, MapCursor> map : imageMap5.getMapMarkers()) {
                        if (map.remove(args[3]) == null) continue;
                        try {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageMarkersRemove);
                            Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap5));
                            imageMap5.send(imageMap5.getViewers());
                            imageMap5.save();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageMarkersNotAMarker);
                });
                return true;
            }
            if (args[1].equalsIgnoreCase("clear")) {
                if (args.length <= 2) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                ImageMap imageMap6 = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), args[2]);
                if (imageMap6 == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        imageMap6.getMapMarkers().forEach(each -> each.clear());
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageMarkersClear);
                        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(imageMap6));
                        imageMap6.send(imageMap6.getViewers());
                        imageMap6.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            if (args[1].equalsIgnoreCase("cancel")) {
                MapMarkerEditManager.MapMarkerEditData editData = ImageFrame.mapMarkerEditManager.leaveActiveEditing(player);
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageMarkersCancel);
                if (editData == null) return true;
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> editData.getImageMap().send(editData.getImageMap().getViewers()));
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
            return true;
        }
        if (args[0].equalsIgnoreCase("refresh")) {
            if (sender.hasPermission("imageframe.refresh")) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    block27: {
                        ImageMap imageMap = null;
                        String url = null;
                        DitheringType ditheringType = null;
                        if (args.length > 1) {
                            imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                            if (imageMap == null) {
                                ditheringType = DitheringType.fromNameOrNull(args[1].toLowerCase());
                                if (ditheringType == null) {
                                    url = args[1];
                                }
                            } else if (args.length > 2 && (ditheringType = DitheringType.fromNameOrNull(args[2].toLowerCase())) == null) {
                                url = args[2];
                            }
                        }
                        if (imageMap == null) {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                return;
                            }
                            MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                            if (mapView == null) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                                return;
                            }
                            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                        }
                        if (imageMap == null) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                        } else if (ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.EDIT)) {
                            try {
                                if (imageMap instanceof URLImageMap) {
                                    URLImageMap urlImageMap = (URLImageMap)imageMap;
                                    String imageType = HTTPRequestUtils.getContentType(url);
                                    if (imageType == null) {
                                        imageType = URLConnection.guessContentTypeFromName(url);
                                    }
                                    imageType = imageType == null ? "" : imageType.trim();
                                    if (!ImageFrame.isURLAllowed(url)) {
                                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageURLRestricted);
                                        return;
                                    }
                                    if (imageType.equals("image/gif") == urlImageMap.requiresAnimationService()) {
                                        String oldUrl = urlImageMap.getUrl();
                                        if (url != null) {
                                            urlImageMap.setUrl(url);
                                        }
                                        if (ImageFrame.uploadServiceEnabled && urlImageMap.getUrl().equalsIgnoreCase("upload")) {
                                            UUID user = !(sender instanceof Player) ? ImageMap.CONSOLE_CREATOR : ((Player)sender).getUniqueId();
                                            PendingUpload pendingUpload = ImageFrame.imageUploadManager.newPendingUpload(user);
                                            Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, () -> CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadLink.replace("{URL}", pendingUpload.getUrl(ImageFrame.uploadServiceDisplayURL, user))), 2L);
                                            String newUrl = pendingUpload.getFileBlocking().toURI().toURL().toString();
                                            if (HTTPRequestUtils.getContentSize(newUrl) > ImageFrame.maxImageFileSize) {
                                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageOverMaxFileSize.replace("{Size}", ImageFrame.maxImageFileSize + ""));
                                                throw new IOException("Image over max file size");
                                            }
                                            urlImageMap.setUrl(newUrl);
                                        }
                                        if (ditheringType != null) {
                                            urlImageMap.setDitheringType(ditheringType);
                                        }
                                        try {
                                            imageMap.update();
                                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapRefreshed);
                                        }
                                        catch (Throwable e) {
                                            urlImageMap.setUrl(oldUrl);
                                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                                            e.printStackTrace();
                                        }
                                    } else {
                                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToChangeImageType);
                                    }
                                    break block27;
                                }
                                if (ditheringType != null) {
                                    imageMap.setDitheringType(ditheringType);
                                }
                                imageMap.update();
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapRefreshed);
                            }
                            catch (ImageUploadManager.LinkTimeoutException e) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUploadExpired);
                            }
                            catch (Exception e) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnableToLoadMap);
                                e.printStackTrace();
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                        }
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
            return true;
        }
        if (args[0].equalsIgnoreCase("rename")) {
            if (!sender.hasPermission("imageframe.rename")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length <= 2) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            ImageMap imageMap7 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
            if (imageMap7 == null) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                return true;
            }
            if (!ImageFrame.hasImageMapPermission(imageMap7, sender, ImageMapAccessPermissionType.EDIT)) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            String newName = args[2];
            if (ImageFrame.imageMapManager.getFromCreator(imageMap7.getCreator(), newName) == null) {
                Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                    try {
                        imageMap7.rename(newName);
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapRenamed);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                return true;
            }
            CommandSenderUtils.sendMessage(sender, ImageFrame.messageDuplicateMapName);
            return true;
        }
        if (args[0].equalsIgnoreCase("info")) {
            MapView mapView;
            if (!sender.hasPermission("imageframe.info")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length > 1) {
                imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                if (imageMap == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                    return true;
                }
                mapView = imageMap.getMapViews().get(0);
            } else {
                mapView = sender instanceof Player ? MapUtils.getPlayerMapView((Player)sender) : null;
            }
            if (mapView == null) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                return true;
            }
            imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
            if (imageMap == null) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                return true;
            }
        } else {
            Player target;
            if (args[0].equalsIgnoreCase("list")) {
                if (sender.hasPermission("imageframe.list")) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        OfflinePlayer player = null;
                        if (args.length > 1) {
                            player = Bukkit.getOfflinePlayer((String)args[1]);
                        } else if (sender instanceof Player) {
                            player = (Player)sender;
                        }
                        if (player == null) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                        } else if (!player.equals((Object)sender) && !sender.hasPermission("imageframe.list.others")) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                        } else {
                            String prefix = ImageFrame.messageMapLookup.replace("{CreatorName}", player.getName() == null ? "" : player.getName()).replace("{CreatorUUID}", player.getUniqueId().toString());
                            String message = ImageFrame.imageMapManager.getFromCreator(player.getUniqueId(), Comparator.comparing(each -> each.getCreationTime())).stream().map(each -> each.getName()).collect(Collectors.joining(", ", prefix + " [", "]"));
                            CommandSenderUtils.sendMessage(sender, message);
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args[0].equalsIgnoreCase("delete")) {
                if (!sender.hasPermission("imageframe.delete")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length > 1) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        try {
                            ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                            if (imageMap == null) {
                                if (!(sender instanceof Player)) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                    return;
                                }
                                MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                                if (mapView == null) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                                    return;
                                }
                                imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                            }
                            if (imageMap == null) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                            } else if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.ALL)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                            } else {
                                ImageFrame.imageMapManager.deleteMap(imageMap.getImageIndex());
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapDeleted);
                                if (sender instanceof Player) {
                                    Player player = (Player)sender;
                                    Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                                        PlayerInventory inventory = player.getInventory();
                                        for (int i = 0; i < inventory.getSize(); ++i) {
                                            ItemStack currentItem = inventory.getItem(i);
                                            MapView currentMapView = MapUtils.getItemMapView(currentItem);
                                            if (currentMapView == null || !ImageFrame.imageMapManager.isMapDeleted(currentMapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) continue;
                                            inventory.setItem(i, new ItemStack(Material.MAP, currentItem.getAmount()));
                                        }
                                    }, (Entity)player);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (args[0].equalsIgnoreCase("purge")) {
                if (!sender.hasPermission("imageframe.purge")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length > 1) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        Set<UUID> uuids;
                        if (args[1].equalsIgnoreCase("*")) {
                            if (sender.hasPermission("imageframe.purge.all")) {
                                uuids = ImageFrame.imageMapManager.getCreators();
                            } else {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                                uuids = Collections.emptySet();
                            }
                        } else {
                            UUID uuid;
                            try {
                                uuid = UUID.fromString(args[1]);
                            }
                            catch (IllegalArgumentException e) {
                                uuid = Bukkit.getOfflinePlayer((String)args[1]).getUniqueId();
                            }
                            uuids = Collections.singleton(uuid);
                        }
                        for (UUID uuid : uuids) {
                            ArrayList<String> names = new ArrayList<String>();
                            for (ImageMap imageMap : ImageFrame.imageMapManager.getFromCreator(uuid)) {
                                if (!ImageFrame.imageMapManager.deleteMap(imageMap.getImageIndex())) continue;
                                names.add(imageMap.getName());
                            }
                            String playerName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapPlayerPurge.replace("{Amount}", String.valueOf(names.size())).replace("{CreatorName}", playerName == null ? "???" : playerName).replace("{CreatorUUID}", uuid.toString()).replace("{ImageMapNames}", String.join((CharSequence)", ", names)));
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (args[0].equalsIgnoreCase("setaccess")) {
                if (!sender.hasPermission("imageframe.setaccess")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length > 3) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        try {
                            ImageMap imageMap = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                            if (imageMap == null) {
                                if (!(sender instanceof Player)) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                    return;
                                }
                                MapView mapView = MapUtils.getPlayerMapView((Player)sender);
                                if (mapView == null) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                                    return;
                                }
                                imageMap = ImageFrame.imageMapManager.getFromMapView(mapView);
                            }
                            if (imageMap == null) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                            } else if (!ImageFrame.hasImageMapPermission(imageMap, sender, ImageMapAccessPermissionType.ALL)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                            } else {
                                String targetPlayer = args[2];
                                boolean isEveryone = targetPlayer.equals("*");
                                UUID uuid = isEveryone ? ImageMapAccessControl.EVERYONE : Bukkit.getOfflinePlayer((String)targetPlayer).getUniqueId();
                                String permissionTypeStr = args[3].toUpperCase();
                                try {
                                    ImageMapAccessControl accessControl = imageMap.getAccessControl();
                                    ImageMapAccessPermissionType permissionType = permissionTypeStr.equals("NONE") ? null : ImageMapAccessPermissionType.valueOf(permissionTypeStr);
                                    accessControl.setPermission(uuid, permissionType);
                                    ImageMapAccessPermissionType newPermission = accessControl.getPermission(uuid);
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageAccessUpdated.replace("{PlayerName}", targetPlayer).replace("{PlayerUUID}", uuid.toString()).replace("{Permission}", newPermission == null ? ImageFrame.messageAccessNoneType : (CharSequence)ImageFrame.messageAccessTypes.get(newPermission)));
                                }
                                catch (IllegalArgumentException e) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                                }
                                catch (Exception e) {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageUnknownError);
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (args[0].equalsIgnoreCase("get")) {
                Player senderPlayer;
                if (!sender.hasPermission("imageframe.get")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                Player player = senderPlayer = sender instanceof Player ? (Player)sender : null;
                if (args.length <= 1) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                try {
                    Player player2;
                    ItemFrameSelectionManager.SelectedItemFrameResult selection;
                    boolean combined;
                    boolean bl = combined = args.length > 2 && args[2].equalsIgnoreCase("combined");
                    if (args.length > 2 && args[2].equalsIgnoreCase("selection") && senderPlayer != null) {
                        selection = ImageFrame.itemFrameSelectionManager.getConfirmedSelections((CommandSender)senderPlayer);
                        if (selection == null) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionNoSelection);
                            return true;
                        }
                    } else {
                        selection = null;
                    }
                    if (selection == null && sender.hasPermission("imageframe.get.others")) {
                        int pos;
                        int n = pos = combined ? 3 : 2;
                        if (args.length > pos) {
                            player2 = Bukkit.getPlayer((String)args[pos]);
                            if (player2 == null) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messagePlayerNotFound);
                                return true;
                            }
                        } else {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                return true;
                            }
                            player2 = (Player)sender;
                        }
                    } else {
                        if (!(sender instanceof Player)) {
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                            return true;
                        }
                        player2 = (Player)sender;
                    }
                    ImageMap imageMap8 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                    if (imageMap8 == null) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                        return true;
                    }
                    if (!ImageFrame.hasImageMapPermission(imageMap8, sender, ImageMapAccessPermissionType.GET)) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                        return true;
                    }
                    if (selection != null && (imageMap8.getWidth() != selection.getWidth() || imageMap8.getHeight() != selection.getHeight())) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageSelectionIncorrectSize.replace("{Width}", imageMap8.getWidth() + "").replace("{Height}", imageMap8.getHeight() + ""));
                        return true;
                    }
                    if (ImageFrame.requireEmptyMaps && senderPlayer != null && MapUtils.removeEmptyMaps(senderPlayer, imageMap8.getMapViews().size(), true) < 0) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotEnoughMaps.replace("{Amount}", imageMap8.getMapViews().size() + ""));
                        return true;
                    }
                    if (combined) {
                        ImageFrame.combinedMapItemHandler.giveCombinedMap(imageMap8, player2);
                    } else if (selection == null) {
                        imageMap8.giveMaps(player2, ImageFrame.mapItemFormat);
                    } else {
                        AtomicBoolean flag = new AtomicBoolean(false);
                        imageMap8.fillItemFrames(selection.getItemFrames(), selection.getRotation(), (frame, item) -> {
                            ItemStack originalItem = frame.getItem();
                            if (originalItem != null && !originalItem.getType().equals((Object)Material.AIR)) {
                                return false;
                            }
                            return PlayerUtils.isInteractionAllowed(player2, (Entity)frame);
                        }, (frame, item) -> {
                            PlayerUtils.giveItem(player2, item);
                            if (!flag.getAndSet(true)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageItemFrameOccupied);
                            }
                        }, ImageFrame.mapItemFormat);
                    }
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapCreated);
                    return true;
                }
                catch (NumberFormatException e) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("admindelete")) {
                if (!sender.hasPermission("imageframe.admindelete")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length <= 1) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                try {
                    int imageId = Integer.parseInt(args[1]);
                    ImageMap imageMap9 = ImageFrame.imageMapManager.getFromImageId(imageId);
                    if (imageMap9 == null) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                        return true;
                    }
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        ImageFrame.imageMapManager.deleteMap(imageMap9.getImageIndex());
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageImageMapDeleted);
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                                PlayerInventory inventory = player.getInventory();
                                for (int i = 0; i < inventory.getSize(); ++i) {
                                    ItemStack currentItem = inventory.getItem(i);
                                    MapView currentMapView = MapUtils.getItemMapView(currentItem);
                                    if (currentMapView == null || !ImageFrame.imageMapManager.isMapDeleted(currentMapView) || ImageFrame.exemptMapIdsFromDeletion.satisfies(currentMapView.getId())) continue;
                                    inventory.setItem(i, new ItemStack(Material.MAP, currentItem.getAmount()));
                                }
                            }, (Entity)player);
                        }
                    });
                    return true;
                }
                catch (NumberFormatException e) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("adminsetcreator")) {
                if (!sender.hasPermission("imageframe.adminsetcreator")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length <= 2) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                try {
                    int imageId = Integer.parseInt(args[1]);
                    ImageMap imageMap10 = ImageFrame.imageMapManager.getFromImageId(imageId);
                    if (imageMap10 == null) {
                        CommandSenderUtils.sendMessage(sender, ImageFrame.messageNotAnImageMap);
                        return true;
                    }
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        try {
                            OfflinePlayer player = Bukkit.getOfflinePlayer((String)args[2]);
                            imageMap10.changeCreator(player.getUniqueId());
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messageSetCreator.replace("{ImageID}", imageMap10.getImageIndex() + "").replace("{CreatorName}", imageMap10.getCreatorName()).replace("{CreatorUUID}", imageMap10.getCreator().toString()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                    return true;
                }
                catch (NumberFormatException e) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("adminmigrate")) {
                if (!sender.hasPermission("imageframe.adminmigrate")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length > 1) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        ExternalPluginMigration migration = PluginMigrationRegistry.getMigration(args[1]);
                        if (migration != null) {
                            if (migration.requirePlayer()) {
                                if (sender instanceof Player) {
                                    CommandSenderUtils.sendMessage(sender, ChatColor.YELLOW + "Migration has begun, see console for progress, completion and errors");
                                    migration.migrate(((Player)sender).getUniqueId());
                                } else {
                                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                }
                            } else {
                                CommandSenderUtils.sendMessage(sender, ChatColor.YELLOW + "Migration has begun, see console for progress, completion and errors");
                                migration.migrate();
                            }
                        } else {
                            CommandSenderUtils.sendMessage(sender, args[1] + " is not a supported plugin for migration");
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (args[0].equalsIgnoreCase("preference")) {
                if (!sender.hasPermission("imageframe.preference")) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                    return true;
                }
                if (args.length <= 2) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                IFPlayerPreference<?> preference = IFPlayerPreference.valueOf(args[1].toUpperCase());
                if (preference == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                    return true;
                }
                IFPlayerPreference.StringDeserializerResult<?> result = preference.getStringDeserializer().apply(args[2]);
                if (result.isAccepted()) {
                    Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                        UUID player;
                        if (args.length > 3) {
                            if (!sender.hasPermission("imageframe.preference.others")) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                                return;
                            }
                            player = Bukkit.getOfflinePlayer((String)args[3]).getUniqueId();
                        } else {
                            if (!(sender instanceof Player)) {
                                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                                return;
                            }
                            player = ((Player)sender).getUniqueId();
                        }
                        Object value = result.getValue();
                        IFPlayer ifPlayer = ImageFrame.ifPlayerManager.getIFPlayer(player);
                        ifPlayer.setPreference(preference, value);
                        try {
                            ifPlayer.save();
                            CommandSenderUtils.sendMessage(sender, ImageFrame.messagePreferencesUpdate.replace("{Preference}", ImageFrame.getPreferenceTranslatedName(preference)).replace("{Value}", ImageFrame.getPreferenceTranslatedValue(value)));
                            return;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    return true;
                }
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (!args[0].equalsIgnoreCase("giveinvisibleframe")) {
                CommandSenderUtils.sendMessage(sender, ChatColorUtils.translateAlternateColorCodes('&', Bukkit.spigot().getConfig().getString("messages.unknown-command")));
                return true;
            }
            if (args.length <= 1) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageInvalidUsage);
                return true;
            }
            if (!sender.hasPermission("imageframe.giveinvisibleframe")) {
                CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoPermission);
                return true;
            }
            if (args.length > 3) {
                target = Bukkit.getPlayer((String)args[3]);
                if (target == null) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messagePlayerNotFound);
                    return true;
                }
            } else {
                if (!(sender instanceof Player)) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageNoConsole);
                    return true;
                }
                target = (Player)sender;
            }
            String type = args[1];
            int amount = 1;
            try {
                amount = args.length > 2 ? Integer.parseInt(args[2]) : 1;
            }
            catch (NumberFormatException player) {
                // empty catch block
            }
            amount = Math.max(1, amount);
            ItemStack itemStack = type.equalsIgnoreCase("glowing") && ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_17) ? new ItemStack(Material.valueOf((String)"GLOW_ITEM_FRAME")) : new ItemStack(Material.ITEM_FRAME);
            ItemStack modified = ImageFrame.invisibleFrameManager.withInvisibleItemFrameData(itemStack);
            PrimitiveIterator.OfInt itr = MathUtils.splitToChunksOf(amount, 64);
            while (true) {
                if (!itr.hasNext()) {
                    CommandSenderUtils.sendMessage(sender, ImageFrame.messageGivenInvisibleFrame.replace("{Amount}", String.valueOf(amount)).replace("{Player}", target.getName()));
                    return true;
                }
                ItemStack finalStack = modified.clone();
                finalStack.setAmount(itr.nextInt());
                PlayerUtils.giveItem(target, finalStack);
            }
        }
        Iterator<String> e = ImageFrame.messageURLImageMapInfo.iterator();
        while (e.hasNext()) {
            String line = e.next();
            String access = imageMap.getAccessControl().getPermissions().entrySet().stream().map(each -> {
                UUID uuid = (UUID)each.getKey();
                String playerName = uuid.equals(ImageMapAccessControl.EVERYONE) ? "*" : Bukkit.getOfflinePlayer((UUID)uuid).getName();
                String permission = ImageFrame.messageAccessTypes.get(each.getValue());
                if (playerName == null) {
                    return ((UUID)each.getKey()).toString() + " - " + permission;
                }
                return playerName + " - " + permission;
            }).sorted().collect(Collectors.joining(", ", "[", "]"));
            String message = ChatColorUtils.translateAlternateColorCodes('&', line.replace("{ImageID}", imageMap.getImageIndex() + "").replace("{Name}", imageMap.getName()).replace("{Width}", imageMap.getWidth() + "").replace("{Height}", imageMap.getHeight() + "").replace("{DitheringType}", imageMap.getDitheringType().getName()).replace("{CreatorName}", imageMap.getCreatorName()).replace("{Access}", access).replace("{CreatorUUID}", imageMap.getCreator().toString()).replace("{TimeCreated}", ImageFrame.dateFormat.format(new Date(imageMap.getCreationTime()))).replace("{Markers}", imageMap.getMapMarkers().stream().flatMap(each -> each.keySet().stream()).collect(Collectors.joining(", ", "[", "]"))));
            message = imageMap instanceof URLImageMap ? message.replace("{URL}", ((URLImageMap)imageMap).getUrl()) : message.replace("{URL}", "-");
            CommandSenderUtils.sendMessage(sender, message);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        LinkedList<String> tab = new LinkedList<String>();
        switch (args.length) {
            case 0: {
                if (sender.hasPermission("imageframe.reload")) {
                    tab.add("reload");
                }
                if (sender.hasPermission("imageframe.create")) {
                    tab.add("create");
                }
                if (sender.hasPermission("imageframe.overlay")) {
                    tab.add("overlay");
                }
                if (sender.hasPermission("imageframe.clone")) {
                    tab.add("clone");
                }
                if (sender.hasPermission("imageframe.playback")) {
                    tab.add("playback");
                }
                if (sender.hasPermission("imageframe.select")) {
                    tab.add("select");
                }
                if (sender.hasPermission("imageframe.refresh")) {
                    tab.add("refresh");
                }
                if (sender.hasPermission("imageframe.rename")) {
                    tab.add("rename");
                }
                if (sender.hasPermission("imageframe.info")) {
                    tab.add("info");
                }
                if (sender.hasPermission("imageframe.list")) {
                    tab.add("list");
                }
                if (sender.hasPermission("imageframe.delete")) {
                    tab.add("delete");
                }
                if (sender.hasPermission("imageframe.purge")) {
                    tab.add("purge");
                }
                if (sender.hasPermission("imageframe.get")) {
                    tab.add("get");
                }
                if (sender.hasPermission("imageframe.update")) {
                    tab.add("update");
                }
                if (sender.hasPermission("imageframe.marker")) {
                    tab.add("marker");
                }
                if (sender.hasPermission("imageframe.setaccess")) {
                    tab.add("setaccess");
                }
                if (sender.hasPermission("imageframe.admindelete")) {
                    tab.add("admindelete");
                }
                if (sender.hasPermission("imageframe.adminsetcreator")) {
                    tab.add("adminsetcreator");
                }
                if (sender.hasPermission("imageframe.adminmigrate")) {
                    tab.add("adminmigrate");
                }
                if (sender.hasPermission("imageframe.preference")) {
                    tab.add("preference");
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe")) {
                    tab.add("giveinvisibleframe");
                }
                return tab;
            }
            case 1: {
                if (sender.hasPermission("imageframe.reload") && "reload".startsWith(args[0].toLowerCase())) {
                    tab.add("reload");
                }
                if (sender.hasPermission("imageframe.create") && "create".startsWith(args[0].toLowerCase())) {
                    tab.add("create");
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".startsWith(args[0].toLowerCase())) {
                    tab.add("overlay");
                }
                if (sender.hasPermission("imageframe.clone") && "clone".startsWith(args[0].toLowerCase())) {
                    tab.add("clone");
                }
                if (sender.hasPermission("imageframe.playback") && "playback".startsWith(args[0].toLowerCase())) {
                    tab.add("playback");
                }
                if (sender.hasPermission("imageframe.select") && "select".startsWith(args[0].toLowerCase())) {
                    tab.add("select");
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".startsWith(args[0].toLowerCase())) {
                    tab.add("refresh");
                }
                if (sender.hasPermission("imageframe.rename") && "rename".startsWith(args[0].toLowerCase())) {
                    tab.add("rename");
                }
                if (sender.hasPermission("imageframe.info") && "info".startsWith(args[0].toLowerCase())) {
                    tab.add("info");
                }
                if (sender.hasPermission("imageframe.list") && "list".startsWith(args[0].toLowerCase())) {
                    tab.add("list");
                }
                if (sender.hasPermission("imageframe.delete") && "delete".startsWith(args[0].toLowerCase())) {
                    tab.add("delete");
                }
                if (sender.hasPermission("imageframe.purge") && "purge".startsWith(args[0].toLowerCase())) {
                    tab.add("purge");
                }
                if (sender.hasPermission("imageframe.get") && "get".startsWith(args[0].toLowerCase())) {
                    tab.add("get");
                }
                if (sender.hasPermission("imageframe.update") && "update".startsWith(args[0].toLowerCase())) {
                    tab.add("update");
                }
                if (sender.hasPermission("imageframe.marker") && "marker".startsWith(args[0].toLowerCase())) {
                    tab.add("marker");
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".startsWith(args[0].toLowerCase())) {
                    tab.add("setaccess");
                }
                if (sender.hasPermission("imageframe.admindelete") && "admindelete".startsWith(args[0].toLowerCase())) {
                    tab.add("admindelete");
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".startsWith(args[0].toLowerCase())) {
                    tab.add("adminsetcreator");
                }
                if (sender.hasPermission("imageframe.adminmigrate") && "adminmigrate".startsWith(args[0].toLowerCase())) {
                    tab.add("adminmigrate");
                }
                if (sender.hasPermission("imageframe.preference") && "preference".startsWith(args[0].toLowerCase())) {
                    tab.add("preference");
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".startsWith(args[0].toLowerCase())) {
                    tab.add("giveinvisibleframe");
                }
                return tab;
            }
            case 2: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    tab.add("<name>");
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    tab.add("<name>");
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1], ImageMapAccessPermissionType.ADJUST_PLAYBACK, imageMap -> imageMap.requiresAnimationService()));
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".equalsIgnoreCase(args[0])) {
                    tab.add("[url]");
                    if (ImageFrame.uploadServiceEnabled && "upload".startsWith(args[1].toLowerCase())) {
                        tab.add("upload");
                    }
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[1].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.select") && "list".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.list.others") && "list".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.rename") && "rename".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.info") && "info".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.delete") && "delete".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.purge") && "purge".equalsIgnoreCase(args[0])) {
                    tab.add("<player>");
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    if ("add".startsWith(args[1].toLowerCase())) {
                        tab.add("add");
                    }
                    if ("remove".startsWith(args[1].toLowerCase())) {
                        tab.add("remove");
                    }
                    if ("clear".startsWith(args[1].toLowerCase())) {
                        tab.add("clear");
                    }
                    if (sender instanceof Player && ImageFrame.mapMarkerEditManager.isActiveEditing((Player)sender) && "cancel".startsWith(args[1].toLowerCase())) {
                        tab.add("cancel");
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[1]));
                }
                if (sender.hasPermission("imageframe.admindelete") && "admindelete".equalsIgnoreCase(args[0])) {
                    tab.add("<image-id>");
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".equalsIgnoreCase(args[0])) {
                    tab.add("<image-id>");
                }
                if (sender.hasPermission("imageframe.adminmigrate") && "adminmigrate".equalsIgnoreCase(args[0])) {
                    for (String string : PluginMigrationRegistry.getPluginNames()) {
                        if (!string.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.preference") && "preference".equalsIgnoreCase(args[0])) {
                    for (IFPlayerPreference iFPlayerPreference : IFPlayerPreference.values()) {
                        if (!iFPlayerPreference.name().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        tab.add(iFPlayerPreference.name().toLowerCase());
                    }
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    if ("regular".startsWith(args[1].toLowerCase())) {
                        tab.add("regular");
                    }
                    if (ImageFrame.version.isNewerOrEqualTo(MCVersion.V1_17) && "glowing".startsWith(args[1].toLowerCase())) {
                        tab.add("glowing");
                    }
                }
                return tab;
            }
            case 3: {
                IFPlayerPreference<?> preference;
                Object imageMap2;
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    tab.add("<url>");
                    if (ImageFrame.uploadServiceEnabled && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    tab.add("<url>");
                    if (ImageFrame.uploadServiceEnabled && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    tab.add("<new-name>");
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0])) {
                    if ("pause".startsWith(args[2].toUpperCase())) {
                        tab.add("pause");
                    }
                    if ("jumpto".startsWith(args[2].toLowerCase())) {
                        tab.add("jumpto");
                    }
                }
                if (sender.hasPermission("imageframe.refresh") && "refresh".equalsIgnoreCase(args[0]) && (imageMap2 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1])) != null) {
                    tab.add("[url]");
                    if (ImageFrame.uploadServiceEnabled && "upload".startsWith(args[2].toLowerCase())) {
                        tab.add("upload");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[2].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0])) {
                    if (sender instanceof Player && "selection".startsWith(args[2].toLowerCase())) {
                        tab.add("selection");
                    }
                    if ("combined".startsWith(args[2].toLowerCase())) {
                        tab.add("combined");
                    }
                    if (sender.hasPermission("imageframe.get.others")) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                            tab.add(player.getName());
                        }
                    }
                }
                if (sender.hasPermission("imageframe.rename") && "rename".equalsIgnoreCase(args[0])) {
                    tab.add("<new-name>");
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    if ("add".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                    if ("remove".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                    if ("clear".equalsIgnoreCase(args[1])) {
                        tab.addAll(ImageMapUtils.getImageMapNameSuggestions(sender, args[2]));
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    ImageMap imageMap3 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[1]);
                    UUID uUID = imageMap3 == null ? null : imageMap3.getCreator();
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (player.getUniqueId().equals(uUID) || !player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                    if ("*".startsWith(args[2].toLowerCase())) {
                        tab.add("*");
                    }
                }
                if (sender.hasPermission("imageframe.adminsetcreator") && "adminsetcreator".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.preference") && "preference".equalsIgnoreCase(args[0]) && (preference = IFPlayerPreference.valueOf(args[1].toUpperCase())) != null) {
                    tab.addAll(preference.getSuggestedValues().keySet());
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    tab.add("<amount>");
                }
                return tab;
            }
            case 4: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    if (args[3].matches("(?i)[0-9]*")) {
                        tab.add("<width>");
                    }
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0])) {
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[3].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.clone") && "clone".equalsIgnoreCase(args[0])) {
                    if ("selection".startsWith(args[3].toLowerCase())) {
                        tab.add("selection");
                    }
                    if ("combined".startsWith(args[3].toLowerCase())) {
                        tab.add("combined");
                    }
                }
                if (sender.hasPermission("imageframe.playback") && "playback".equalsIgnoreCase(args[0]) && "jumpto".equalsIgnoreCase(args[2])) {
                    tab.add("0.0");
                }
                if (sender.hasPermission("imageframe.get") && "get".equalsIgnoreCase(args[0]) && args[2].equalsIgnoreCase("combined") && sender.hasPermission("imageframe.get.others")) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0])) {
                    Object imageMap3;
                    if ("add".equalsIgnoreCase(args[1])) {
                        tab.add("<marker-name>");
                    }
                    if ("remove".equalsIgnoreCase(args[1]) && sender instanceof Player && (imageMap3 = ImageMapUtils.getFromPlayerPrefixedName(sender, args[2])) != null) {
                        for (Map<String, MapCursor> map : ((ImageMap)imageMap3).getMapMarkers()) {
                            for (String name : map.keySet()) {
                                if (!name.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                                tab.add(name);
                            }
                        }
                    }
                }
                if (sender.hasPermission("imageframe.setaccess") && "setaccess".equalsIgnoreCase(args[0])) {
                    for (String string : ImageMapAccessPermissionType.values().keySet()) {
                        if (!string.toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(string);
                    }
                    if ("NONE".toLowerCase().startsWith(args[3].toLowerCase())) {
                        tab.add("NONE");
                    }
                }
                if (sender.hasPermission("imageframe.preference.others") && "preference".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                if (sender.hasPermission("imageframe.giveinvisibleframe") && "giveinvisibleframe".equalsIgnoreCase(args[0])) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.getName().toLowerCase().startsWith(args[3].toLowerCase())) continue;
                        tab.add(player.getName());
                    }
                }
                return tab;
            }
            case 5: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0])) {
                    if (!args[3].equalsIgnoreCase("selection")) {
                        tab.add("<height>");
                    } else {
                        for (String string : DitheringType.values().keySet()) {
                            if (!string.startsWith(args[4].toLowerCase())) continue;
                            tab.add(string);
                        }
                    }
                }
                if (sender.hasPermission("imageframe.overlay") && "overlay".equalsIgnoreCase(args[0]) && args[3].equalsIgnoreCase("selection")) {
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[4].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
                    for (int i = 0; i < 16; ++i) {
                        if (!String.valueOf(i).startsWith(args[4])) continue;
                        tab.add(String.valueOf(i));
                    }
                }
                return tab;
            }
            case 6: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0]) && !args[3].equalsIgnoreCase("selection")) {
                    if ("combined".startsWith(args[5].toLowerCase())) {
                        tab.add("combined");
                    }
                    for (String string : DitheringType.values().keySet()) {
                        if (!string.startsWith(args[5].toLowerCase())) continue;
                        tab.add(string);
                    }
                }
                if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
                    void var8_49;
                    MapCursor.Type[] typeArray = MapCursor.Type.values();
                    int n = typeArray.length;
                    boolean bl = false;
                    while (var8_49 < n) {
                        Object type = typeArray[var8_49];
                        if (type.name().toLowerCase().startsWith(args[5].toLowerCase())) {
                            tab.add(type.name().toLowerCase());
                        }
                        ++var8_49;
                    }
                }
                return tab;
            }
            case 7: {
                if (sender.hasPermission("imageframe.create") && "create".equalsIgnoreCase(args[0]) && !args[3].equalsIgnoreCase("selection") && !args[5].equalsIgnoreCase("combined") && "combined".startsWith(args[6].toLowerCase())) {
                    tab.add("combined");
                }
                return tab;
            }
        }
        if (sender.hasPermission("imageframe.marker") && "marker".equalsIgnoreCase(args[0]) && "add".equalsIgnoreCase(args[1])) {
            tab.add("[caption]...");
        }
        return tab;
    }
}

