/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;

public class JsonUtils {
    public static JsonElement merge(JsonElement first, JsonElement second) {
        if (first.isJsonObject() && second.isJsonObject()) {
            JsonObject firstObj = first.getAsJsonObject();
            JsonObject secondObj = second.getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : secondObj.entrySet()) {
                String key = entry.getKey();
                JsonElement value = entry.getValue();
                if (firstObj.has(key)) {
                    firstObj.add(key, JsonUtils.merge(firstObj.get(key), value));
                    continue;
                }
                firstObj.add(key, value);
            }
            return firstObj;
        }
        if (first.isJsonArray() && second.isJsonArray()) {
            JsonArray firstArray = first.getAsJsonArray();
            JsonArray secondArray = second.getAsJsonArray();
            for (int i = 0; i < Math.min(firstArray.size(), secondArray.size()); ++i) {
                firstArray.set(i, JsonUtils.merge(firstArray.get(i), secondArray.get(i)));
            }
            return firstArray;
        }
        return second;
    }
}

