/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.nms.NMS;
import com.loohp.imageframe.objectholders.FilledMapItemInfo;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.utils.SlotAccessor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;

public class ImageFilledMapUtils {
    public static void processImageFilledMaps(SlotAccessor slotAccess, int size) {
        ImageFilledMapUtils.processImageFilledMaps(slotAccess, 0, size);
    }

    public static void processImageFilledMaps(SlotAccessor slotAccess, int begin, int size) {
        for (int i = begin; i < size; ++i) {
            ItemStack replacement = ImageFilledMapUtils.processImageFilledMap(slotAccess.get(i));
            if (replacement == null) continue;
            slotAccess.set(i, replacement);
        }
    }

    public static ItemStack processImageFilledMap(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (!itemStack.getType().equals((Object)Material.FILLED_MAP)) {
            return null;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof MapMeta)) {
            return null;
        }
        MapMeta mapMeta = (MapMeta)itemMeta;
        MapView mapView = mapMeta.getMapView();
        FilledMapItemInfo info = NMS.getInstance().getFilledMapItemInfo(itemStack);
        if (info == null) {
            ImageMap imageMap;
            if (mapView != null && (imageMap = ImageFrame.imageMapManager.getFromMapView(mapView)) != null) {
                int imageIndex = imageMap.getImageIndex();
                int partIndex = imageMap.getMapIds().indexOf(mapView.getId());
                if (partIndex >= 0) {
                    return NMS.getInstance().withFilledMapItemInfo(itemStack, new FilledMapItemInfo(imageIndex, partIndex));
                }
            }
        } else {
            ImageMap imageMap = ImageFrame.imageMapManager.getFromImageId(info.getImageMapIndex());
            MapView correctMapView = imageMap.getMapViews().get(info.getMapPartIndex());
            if (mapView == null || correctMapView.getId() != mapView.getId()) {
                mapMeta.setMapView(correctMapView);
                itemStack.setItemMeta((ItemMeta)mapMeta);
            }
        }
        return null;
    }
}

