/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.objectholders.LazyDataSource;
import com.loohp.imageframe.objectholders.LazyMappedBufferedImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.ref.WeakReference;
import javax.imageio.ImageIO;

public class StandardLazyMappedBufferedImage
implements LazyMappedBufferedImage {
    private static final LazyDataSource.Reader<BufferedImage> IMAGE_READER = in -> ImageIO.read(in);
    private LazyDataSource source;
    private BufferedImage strongReference;
    private WeakReference<BufferedImage> weakReference;

    protected static LazyDataSource.Reader<BufferedImage> imageReader() {
        return IMAGE_READER;
    }

    protected static LazyDataSource.Writer imageWriter(BufferedImage image) {
        return out -> ImageIO.write((RenderedImage)image, "png", out);
    }

    public static StandardLazyMappedBufferedImage fromSource(LazyDataSource source) {
        return new StandardLazyMappedBufferedImage(source, null, null);
    }

    public static StandardLazyMappedBufferedImage fromImage(BufferedImage image) {
        return new StandardLazyMappedBufferedImage(null, image, null);
    }

    public static StandardLazyMappedBufferedImage fromImageToFile(LazyDataSource source, BufferedImage image) throws IOException {
        source.save(StandardLazyMappedBufferedImage.imageWriter(image));
        return new StandardLazyMappedBufferedImage(source, null, new WeakReference<BufferedImage>(image));
    }

    private StandardLazyMappedBufferedImage(LazyDataSource source, BufferedImage strongReference, WeakReference<BufferedImage> weakReference) {
        if (source == null && strongReference == null) {
            throw new IllegalArgumentException("One of source and strongReference must not be null");
        }
        if (source != null && strongReference != null) {
            throw new IllegalArgumentException("Source and strongReference cannot both be not null");
        }
        this.source = source;
        this.strongReference = strongReference;
        this.weakReference = weakReference;
    }

    @Override
    public LazyDataSource getSource() {
        return this.source;
    }

    @Override
    public boolean canSetSource(LazyDataSource source) {
        if (this.source != null) {
            return this.source.equals(source);
        }
        return source != null;
    }

    @Override
    public synchronized void setSource(LazyDataSource source) {
        if (this.source != null) {
            if (this.source.equals(source)) {
                return;
            }
            throw new IllegalStateException("Cannot change source location");
        }
        if (source == null) {
            throw new IllegalArgumentException("Cannot set source to null");
        }
        try {
            source.save(StandardLazyMappedBufferedImage.imageWriter(this.strongReference));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.source = source;
        this.weakReference = new WeakReference<BufferedImage>(this.strongReference);
        this.strongReference = null;
    }

    @Override
    public void saveCopy(LazyDataSource source) {
        try {
            source.save(StandardLazyMappedBufferedImage.imageWriter(this.get()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized BufferedImage get() {
        BufferedImage image;
        if (this.strongReference != null) {
            return this.strongReference;
        }
        if (this.weakReference != null && (image = (BufferedImage)this.weakReference.get()) != null) {
            return image;
        }
        try {
            image = this.source.load(StandardLazyMappedBufferedImage.imageReader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.weakReference = new WeakReference<BufferedImage>(image);
        return image;
    }

    @Override
    public synchronized BufferedImage getIfLoaded() {
        if (this.strongReference != null) {
            return this.strongReference;
        }
        return (BufferedImage)this.weakReference.get();
    }
}

