/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.text.Component;
import com.loohp.imageframe.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.imageframe.objectholders.BlockPosition;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.CommandSenderUtils;
import com.loohp.imageframe.utils.ComponentUtils;
import com.loohp.imageframe.utils.ItemFrameUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class ItemFrameSelectionManager
implements Listener,
AutoCloseable {
    private final Set<Player> inSelectionMode = ConcurrentHashMap.newKeySet();
    private final Set<Player> cancelOffhand = ConcurrentHashMap.newKeySet();
    private final Map<Player, ItemFrame> activeFirstCorners = new ConcurrentHashMap<Player, ItemFrame>();
    private final Map<CommandSender, SelectedItemFrameResult> confirmedSelection = new ConcurrentHashMap<CommandSender, SelectedItemFrameResult>();

    public ItemFrameSelectionManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    public void setInSelection(CommandSender sender, boolean value) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (value) {
                this.confirmedSelection.remove(player);
                this.activeFirstCorners.remove(player);
                this.inSelectionMode.add(player);
            } else {
                this.activeFirstCorners.remove(player);
                this.inSelectionMode.remove(player);
            }
        }
    }

    public boolean isInSelection(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return false;
        }
        return this.inSelectionMode.contains((Player)sender);
    }

    public SelectedItemFrameResult getConfirmedSelections(CommandSender sender) {
        return this.confirmedSelection.get(sender);
    }

    public SelectedItemFrameResult clearConfirmedSelections(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.activeFirstCorners.remove(player);
            this.inSelectionMode.remove(player);
        }
        return this.confirmedSelection.remove(sender);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.clearConfirmedSelections((CommandSender)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        boolean isOffhand = event.getHand().equals((Object)EquipmentSlot.OFF_HAND);
        if (isOffhand && this.cancelOffhand.contains(player)) {
            event.setCancelled(true);
            return;
        }
        if (!this.inSelectionMode.contains(player)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof ItemFrame)) {
            return;
        }
        event.setCancelled(true);
        if (isOffhand) {
            return;
        }
        ItemFrame selection = this.activeFirstCorners.remove(player);
        if (selection == null) {
            this.activeFirstCorners.put(player, (ItemFrame)entity);
            CommandSenderUtils.sendMessage((CommandSender)player, Component.translatable("imageframe.messages.selection.corner1").color(NamedTextColor.GREEN));
        } else {
            CommandSenderUtils.sendMessage((CommandSender)player, Component.translatable("imageframe.messages.selection.corner2").color(NamedTextColor.GREEN));
            this.inSelectionMode.remove(player);
            this.cancelOffhand.add(player);
            Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> this.cancelOffhand.remove(player), 1L, (Entity)player);
            SelectedItemFrameResult result = this.getSelectedItemFrames(player.getLocation().getYaw(), selection, (ItemFrame)entity);
            if (result == null) {
                CommandSenderUtils.sendMessage((CommandSender)player, Component.translatable("imageframe.messages.selection.invalid").color(NamedTextColor.RED));
            } else if (result.isOverSize()) {
                CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.oversize", ImageFrame.mapMaxSize).color(NamedTextColor.RED));
            } else {
                this.confirmedSelection.put((CommandSender)player, result);
                CommandSenderUtils.sendMessage((CommandSender)player, ComponentUtils.translatable("imageframe.messages.selection.success", result.getWidth(), result.getHeight()).color(NamedTextColor.GREEN));
            }
        }
    }

    public boolean applyDirectItemFrameSelection(CommandSender sender, float yaw, BlockPosition pos1, BlockPosition pos2) {
        Collection pos1Entity = pos1.getWorld().getNearbyEntities(pos1.toBoundingBox());
        Collection pos2Entity = pos2.getWorld().getNearbyEntities(pos2.toBoundingBox());
        MutablePair pair = pos1Entity.stream().filter(e -> e instanceof ItemFrame).map(e -> {
            ItemFrame i = (ItemFrame)e;
            BlockFace facing = i.getAttachedFace();
            return pos2Entity.stream().filter(e2 -> e2 instanceof ItemFrame && ((ItemFrame)e2).getAttachedFace().equals((Object)facing)).findFirst().map(e2 -> new MutablePair<ItemFrame, ItemFrame>(i, (ItemFrame)e2)).orElse(null);
        }).filter(p -> p != null).findFirst().orElse(null);
        if (pair == null) {
            CommandSenderUtils.sendMessage(sender, Component.translatable("imageframe.messages.selection.invalid").color(NamedTextColor.RED));
            return false;
        }
        SelectedItemFrameResult result = this.getSelectedItemFrames(yaw, (ItemFrame)pair.getFirst(), (ItemFrame)pair.getSecond());
        if (result == null) {
            CommandSenderUtils.sendMessage(sender, Component.translatable("imageframe.messages.selection.invalid").color(NamedTextColor.RED));
        } else if (result.isOverSize()) {
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.oversize", ImageFrame.mapMaxSize).color(NamedTextColor.RED));
        } else {
            this.confirmedSelection.put(sender, result);
            CommandSenderUtils.sendMessage(sender, ComponentUtils.translatable("imageframe.messages.selection.success", result.getWidth(), result.getHeight()).color(NamedTextColor.GREEN));
            return true;
        }
        return false;
    }

    public SelectedItemFrameResult getSelectedItemFrames(float yaw, ItemFrame left, ItemFrame right) {
        ToIntFunction<ItemFrame> heightFunction;
        Comparator<ItemFrame> comparator;
        Rotation rotation;
        BlockFace facing;
        World world;
        boolean oversize;
        BoundingBox boundingBox;
        block18: {
            block19: {
                block17: {
                    if (left == null || right == null) {
                        return null;
                    }
                    if (left.equals((Object)right)) {
                        Rotation rotation2 = ItemFrameUtils.isOnWalls(left) ? Rotation.NONE : ItemFrameUtils.getClosestMapRotation(yaw + (ItemFrameUtils.isOnCeiling(left) ? 180.0f : 0.0f));
                        return SelectedItemFrameResult.result(Collections.singletonList(left), 1, 1, rotation2, false);
                    }
                    if (!left.getAttachedFace().equals((Object)right.getAttachedFace())) {
                        return null;
                    }
                    Block leftBlock = left.getLocation().getBlock();
                    Block rightBlock = right.getLocation().getBlock();
                    if (leftBlock.getX() != rightBlock.getX() && leftBlock.getY() != rightBlock.getY() && leftBlock.getZ() != rightBlock.getZ()) {
                        return null;
                    }
                    boundingBox = BoundingBox.of((Block)leftBlock, (Block)rightBlock);
                    oversize = Math.round(boundingBox.getVolume()) > (long)ImageFrame.mapMaxSize;
                    world = left.getWorld();
                    facing = left.getFacing();
                    if (!ItemFrameUtils.isOnWalls(left)) break block17;
                    rotation = Rotation.NONE;
                    Vector vector = facing.getDirection().rotateAroundY(Math.toRadians(90.0));
                    comparator = Comparator.comparingDouble(each -> each.getLocation().getY()).reversed();
                    comparator = Math.abs(vector.getX()) > 1.0E-6 ? (vector.getX() < 0.0 ? comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getX()).reversed()) : comparator.thenComparingDouble(each -> each.getLocation().getX())) : (vector.getZ() < 0.0 ? comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getZ()).reversed()) : comparator.thenComparingDouble(each -> each.getLocation().getZ()));
                    heightFunction = each -> each.getLocation().getBlockY();
                    break block18;
                }
                rotation = ItemFrameUtils.getClosestMapRotation(yaw);
                if (!ItemFrameUtils.isOnCeiling(left)) break block19;
                switch (rotation) {
                    case NONE: 
                    case FLIPPED: {
                        comparator = Comparator.comparingDouble(each -> each.getLocation().getZ()).reversed();
                        comparator = comparator.thenComparingDouble(each -> each.getLocation().getX());
                        heightFunction = each -> each.getLocation().getBlockZ();
                        break block18;
                    }
                    case CLOCKWISE_45: 
                    case FLIPPED_45: {
                        comparator = Comparator.comparingDouble(each -> each.getLocation().getX());
                        comparator = comparator.thenComparingDouble(each -> each.getLocation().getZ());
                        heightFunction = each -> each.getLocation().getBlockX();
                        rotation = rotation.rotateCounterClockwise().rotateCounterClockwise();
                        break block18;
                    }
                    case CLOCKWISE: 
                    case COUNTER_CLOCKWISE: {
                        comparator = Comparator.comparingDouble(each -> each.getLocation().getZ());
                        comparator = comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getX()).reversed());
                        heightFunction = each -> each.getLocation().getBlockZ();
                        break block18;
                    }
                    case CLOCKWISE_135: 
                    case COUNTER_CLOCKWISE_45: {
                        comparator = Comparator.comparingDouble(each -> each.getLocation().getX()).reversed();
                        comparator = comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getZ()).reversed());
                        heightFunction = each -> each.getLocation().getBlockX();
                        rotation = rotation.rotateCounterClockwise().rotateCounterClockwise();
                        break block18;
                    }
                    default: {
                        throw new RuntimeException("invalid rotation for maps on item frames: " + rotation.name());
                    }
                }
            }
            switch (rotation) {
                case NONE: 
                case FLIPPED: {
                    comparator = Comparator.comparingDouble(each -> each.getLocation().getZ());
                    comparator = comparator.thenComparingDouble(each -> each.getLocation().getX());
                    heightFunction = each -> each.getLocation().getBlockZ();
                    break;
                }
                case CLOCKWISE_45: 
                case FLIPPED_45: {
                    comparator = Comparator.comparingDouble(each -> each.getLocation().getX()).reversed();
                    comparator = comparator.thenComparingDouble(each -> each.getLocation().getZ());
                    heightFunction = each -> each.getLocation().getBlockX();
                    break;
                }
                case CLOCKWISE: 
                case COUNTER_CLOCKWISE: {
                    comparator = Comparator.comparingDouble(each -> each.getLocation().getZ()).reversed();
                    comparator = comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getX()).reversed());
                    heightFunction = each -> each.getLocation().getBlockZ();
                    break;
                }
                case CLOCKWISE_135: 
                case COUNTER_CLOCKWISE_45: {
                    comparator = Comparator.comparingDouble(each -> each.getLocation().getX());
                    comparator = comparator.thenComparing(Comparator.comparingDouble(each -> each.getLocation().getZ()).reversed());
                    heightFunction = each -> each.getLocation().getBlockX();
                    break;
                }
                default: {
                    throw new RuntimeException("invalid rotation for maps on item frames: " + rotation.name());
                }
            }
        }
        List<ItemFrame> itemFrames = world.getNearbyEntities(boundingBox, e -> e instanceof ItemFrame && e.getFacing().equals((Object)facing)).stream().map(each -> (ItemFrame)each).sorted(comparator).collect(Collectors.toList());
        IntSummaryStatistics statistics = itemFrames.stream().mapToInt(heightFunction).summaryStatistics();
        int height = statistics.getMax() - statistics.getMin() + 1;
        int width = itemFrames.size() / height;
        if (itemFrames.size() != width * height) {
            return null;
        }
        return SelectedItemFrameResult.result(itemFrames, width, height, rotation, oversize);
    }

    public static class SelectedItemFrameResult {
        private final List<ItemFrame> itemFrames;
        private final int width;
        private final int height;
        private final Rotation rotation;
        private final boolean overSize;

        public static SelectedItemFrameResult result(List<ItemFrame> itemFrames, int width, int height, Rotation rotation, boolean overSize) {
            return new SelectedItemFrameResult(itemFrames, width, height, rotation, overSize);
        }

        private SelectedItemFrameResult(List<ItemFrame> itemFrames, int width, int height, Rotation rotation, boolean overSize) {
            this.itemFrames = itemFrames;
            this.width = width;
            this.height = height;
            this.rotation = rotation;
            this.overSize = overSize;
        }

        public List<ItemFrame> getItemFrames() {
            return this.itemFrames;
        }

        public List<MapView> getMapViews() {
            return this.itemFrames.stream().map(each -> MapUtils.getItemMapView(each.getItem())).collect(Collectors.toList());
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public boolean isOverSize() {
            return this.overSize;
        }
    }
}

