/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import java.util.Arrays;
import java.util.Objects;

public class IntRange {
    private final int start;
    private final int end;

    public static IntRange of(String input) {
        String[] parts = (String[])Arrays.stream(input.split("-")).map(s -> s.trim()).filter(s -> !s.isEmpty()).toArray(String[]::new);
        if (parts.length == 1) {
            return IntRange.of(Integer.parseInt(parts[0]));
        }
        if (parts.length == 2) {
            return IntRange.of(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
        }
        throw new IllegalArgumentException("Invalid range format: " + input);
    }

    public static IntRange of(int value) {
        return new IntRange(value, value);
    }

    public static IntRange of(int start, int end) {
        return start <= end ? new IntRange(start, end) : new IntRange(end, start);
    }

    private IntRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean satisfies(int value) {
        return this.start <= value && value <= this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntRange intRange = (IntRange)o;
        return this.start == intRange.start && this.end == intRange.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

