/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImageMapAccessPermissionType
implements Comparable<ImageMapAccessPermissionType> {
    private static final Map<String, ImageMapAccessPermissionType> TYPES = new ConcurrentHashMap<String, ImageMapAccessPermissionType>();
    public static final ImageMapAccessPermissionType GET = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("GET", new ImageMapAccessPermissionType[0]));
    public static final ImageMapAccessPermissionType ADJUST_PLAYBACK = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("ADJUST_PLAYBACK", GET));
    public static final ImageMapAccessPermissionType MARKER = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("MARKER", GET));
    public static final ImageMapAccessPermissionType EDIT = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("EDIT", MARKER));
    public static final ImageMapAccessPermissionType EDIT_CLONE = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("EDIT_CLONE", EDIT));
    public static final ImageMapAccessPermissionType ALL = ImageMapAccessPermissionType.register(new ImageMapAccessPermissionType("ALL", EDIT_CLONE));
    public static final ImageMapAccessPermissionType BASE = new ImageMapAccessPermissionType("BASE", new ImageMapAccessPermissionType[0]){

        @Override
        public boolean containsPermission(ImageMapAccessPermissionType type) {
            return TYPES.containsKey(type.name());
        }
    };
    private final String name;
    private final Set<ImageMapAccessPermissionType> inheritance;

    public static ImageMapAccessPermissionType register(ImageMapAccessPermissionType type) {
        TYPES.put(type.name(), type);
        return type;
    }

    public static ImageMapAccessPermissionType valueOf(String name) {
        ImageMapAccessPermissionType type = TYPES.get(name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException(name + " is not a registered ImageMapAccessPermissionType");
    }

    public static Map<String, ImageMapAccessPermissionType> values() {
        return Collections.unmodifiableMap(TYPES);
    }

    public ImageMapAccessPermissionType(String name, ImageMapAccessPermissionType ... inheritance) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.inheritance = Collections.unmodifiableSet(new HashSet<ImageMapAccessPermissionType>(Arrays.asList(inheritance)));
    }

    public String name() {
        return this.name;
    }

    public boolean containsPermission(ImageMapAccessPermissionType type) {
        if (this.equals(type)) {
            return true;
        }
        for (ImageMapAccessPermissionType inheritedType : this.inheritance) {
            if (inheritedType.equals(this) || !inheritedType.containsPermission(type)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageMapAccessPermissionType type = (ImageMapAccessPermissionType)o;
        return this.name.equals(type.name) && this.inheritance.equals(type.inheritance);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inheritance);
    }

    private int calculateDepth() {
        if (this == BASE) {
            return 0;
        }
        return 1 + this.inheritance.stream().mapToInt(ImageMapAccessPermissionType::calculateDepth).max().orElse(0);
    }

    @Override
    public int compareTo(ImageMapAccessPermissionType o) {
        int depthOther;
        if (this == BASE && o == BASE) {
            return 0;
        }
        if (this == BASE) {
            return -1;
        }
        if (o == BASE) {
            return 1;
        }
        int depthThis = this.calculateDepth();
        int diff = Integer.compare(depthThis, depthOther = o.calculateDepth());
        if (diff != 0) {
            return diff;
        }
        return this.name.compareTo(o.name);
    }
}

