/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonElement;
import com.loohp.imageframe.objectholders.BooleanState;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.LanguageState;
import com.loohp.imageframe.objectholders.PreferenceState;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class IFPlayerPreference<T extends PreferenceState> {
    private static final Map<String, IFPlayerPreference<?>> VALUES = new ConcurrentHashMap();
    public static final IFPlayerPreference<BooleanState> VIEW_ANIMATED_MAPS = IFPlayerPreference.register(new IFPlayerPreference<BooleanState>("VIEW_ANIMATED_MAPS", "viewAnimatedMaps", BooleanState.class, () -> BooleanState.STRING_VALUES_MAP, i -> BooleanState.UNSET, v -> v.getJsonValue(), j -> BooleanState.fromJsonValue(j), s -> StringDeserializerResult.accepted(BooleanState.fromString(s))));
    public static final IFPlayerPreference<LanguageState> LANGUAGE = IFPlayerPreference.register(new IFPlayerPreference<LanguageState>("LANGUAGE", "language", LanguageState.class, LanguageState.VALUES_MAP_SUPPLIER, i -> LanguageState.UNSET, v -> v.getJsonValue(), j -> LanguageState.fromJsonValue(j), s -> StringDeserializerResult.accepted(LanguageState.fromString(s))));
    private final String name;
    private final String jsonName;
    private final Class<T> type;
    private final Supplier<Map<String, T>> suggestedValues;
    private final Function<IFPlayer, T> defaultValue;
    private final Function<T, JsonElement> serializer;
    private final Function<JsonElement, T> deserializer;
    private final Function<String, StringDeserializerResult<T>> stringDeserializer;

    public static <T extends IFPlayerPreference<?>> T register(T preference) {
        VALUES.put(preference.name(), preference);
        return preference;
    }

    public static Collection<IFPlayerPreference<?>> values() {
        return Collections.unmodifiableCollection(VALUES.values());
    }

    public static IFPlayerPreference<?> valueOf(String name) {
        return VALUES.get(name.toUpperCase());
    }

    IFPlayerPreference(String name, String jsonName, Class<T> type, Supplier<Map<String, T>> suggestedValues, Function<IFPlayer, T> defaultValue, Function<T, JsonElement> serializer, Function<JsonElement, T> deserializer, Function<String, StringDeserializerResult<T>> stringDeserializer) {
        this.name = name;
        this.jsonName = jsonName;
        this.type = type;
        this.suggestedValues = suggestedValues;
        this.defaultValue = defaultValue;
        this.serializer = serializer;
        this.deserializer = deserializer;
        this.stringDeserializer = stringDeserializer;
    }

    public String name() {
        return this.name;
    }

    public String getJsonName() {
        return this.jsonName;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Map<String, T> getSuggestedValues() {
        return this.suggestedValues.get();
    }

    public Function<T, JsonElement> getSerializer() {
        return this.serializer;
    }

    public <E extends PreferenceState> Function<E, JsonElement> getSerializer(Class<E> type) {
        return this.serializer;
    }

    public Function<JsonElement, T> getDeserializer() {
        return this.deserializer;
    }

    public <E extends PreferenceState> Function<JsonElement, E> getDeserializer(Class<E> type) {
        return this.deserializer;
    }

    public Function<String, StringDeserializerResult<T>> getStringDeserializer() {
        return this.stringDeserializer;
    }

    public <E extends PreferenceState> Function<String, StringDeserializerResult<E>> getStringDeserializer(Class<E> type) {
        return this.stringDeserializer;
    }

    public T getDefaultValue(IFPlayer ifPlayer) {
        return (T)((PreferenceState)this.defaultValue.apply(ifPlayer));
    }

    public <E extends PreferenceState> E getDefaultValue(IFPlayer ifPlayer, Class<E> type) {
        return (E)((PreferenceState)this.defaultValue.apply(ifPlayer));
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IFPlayerPreference that = (IFPlayerPreference)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class StringDeserializerResult<T extends PreferenceState> {
        public static StringDeserializerResult<?> REJECTED_INSTANCE = new StringDeserializerResult<Object>(false, null);
        private final boolean accepted;
        private final T value;

        public static <T extends PreferenceState> StringDeserializerResult<T> rejected() {
            return REJECTED_INSTANCE;
        }

        public static <T extends PreferenceState> StringDeserializerResult<T> accepted(T result) {
            return new StringDeserializerResult<T>(true, result);
        }

        private StringDeserializerResult(boolean accepted, T value) {
            this.accepted = accepted;
            this.value = value;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public T getValue() {
            return this.value;
        }
    }
}

