/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import java.io.ByteArrayOutputStream;

public class SizeLimitedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final long maxSize;

    public SizeLimitedByteArrayOutputStream(long maxSize) {
        this.maxSize = maxSize;
    }

    private void ensureSize(int added) {
        if ((long)(this.size() + added) > this.maxSize) {
            throw new OversizeException("Size exceeded max size of " + this.maxSize + " bytes");
        }
    }

    @Override
    public synchronized void write(int b) {
        this.ensureSize(1);
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureSize(len);
        super.write(b, off, len);
    }

    public static class OversizeException
    extends RuntimeException {
        public OversizeException(String message) {
            super(message);
        }
    }
}

