/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.com.zaxxer.hikari.HikariConfig;
import com.loohp.imageframe.libs.com.zaxxer.hikari.HikariDataSource;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.objectholders.IFPlayerManager;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapLoaders;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.LazyBufferedImageSource;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.storage.ImageFrameStorageLoaders;
import com.loohp.imageframe.storage.JdbcImageFrameStorageLoader;
import com.loohp.imageframe.utils.JsonUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class JdbcImageFrameStorage
implements ImageFrameStorage {
    public static final Gson GSON = new GsonBuilder().serializeNulls().create();
    private final File localDataFolder;
    private final HikariDataSource dataSource;
    private final UUID instanceId;
    private final int activePollInterval;
    private AtomicLong lastUpdateFetch;
    private ScheduledTask updateFetchTask;
    private ScheduledTask periodicSyncTask;

    public JdbcImageFrameStorage(File localDataFolder, String jdbcUrl, String username, String password, int activePollInterval) {
        block23: {
            this.localDataFolder = localDataFolder;
            this.activePollInterval = activePollInterval;
            this.localDataFolder.mkdirs();
            File localDataFile = new File(localDataFolder, "data.json");
            if (localDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(localDataFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                    JsonObject json = GSON.fromJson((Reader)reader, JsonObject.class);
                    this.instanceId = UUID.fromString(json.get("instanceId").getAsString());
                    break block23;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Unable to read " + localDataFile.getAbsolutePath(), e);
                }
            }
            JsonObject json = new JsonObject();
            this.instanceId = UUID.randomUUID();
            json.addProperty("instanceId", this.instanceId.toString());
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(localDataFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                pw.println(GSON.toJson(json));
                pw.flush();
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to save " + localDataFile.getAbsolutePath(), e);
            }
        }
        try {
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(jdbcUrl);
            config.setUsername(username);
            config.setPassword(password);
            config.setMaximumPoolSize(10);
            this.dataSource = new HikariDataSource(config);
            try (Connection connection = this.dataSource.getConnection();){
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Successfully connected to database.");
            }
            this.prepareDatabase();
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to connect to database", e);
        }
    }

    private void setupTasks(ImageMapManager imageMapManager, IFPlayerManager ifPlayerManager) {
        if (this.lastUpdateFetch == null) {
            this.lastUpdateFetch = new AtomicLong(System.currentTimeMillis());
        } else {
            this.lastUpdateFetch.set(System.currentTimeMillis());
        }
        if (this.updateFetchTask != null) {
            this.updateFetchTask.cancel();
        }
        this.updateFetchTask = Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, () -> this.activeUpdate(imageMapManager, ifPlayerManager), this.activePollInterval + 100, this.activePollInterval);
        if (this.periodicSyncTask != null) {
            this.periodicSyncTask.cancel();
        }
        this.periodicSyncTask = Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, () -> imageMapManager.syncMaps(), (long)this.activePollInterval * 12L + 100L, (long)this.activePollInterval * 12L);
    }

    private void prepareDatabase() {
        block47: {
            try (Connection connection = this.dataSource.getConnection();
                 Statement stmt = connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS IMAGE_MAPS (IMAGE_INDEX INT NOT NULL PRIMARY KEY, DATA LONGTEXT NOT NULL)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS IMAGE_MAP_IMAGES (IMAGE_INDEX INT NOT NULL, FILE_NAME VARCHAR(255) NOT NULL, IMAGE LONGBLOB NOT NULL, PRIMARY KEY (IMAGE_INDEX, FILE_NAME))");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS INSTANCE_IMAGE_MAP_DATA (IMAGE_INDEX INT NOT NULL, INSTANCE_ID CHAR(36) NOT NULL, DATA LONGTEXT NOT NULL, PRIMARY KEY (IMAGE_INDEX, INSTANCE_ID))");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS DELETED_MAPS (INSTANCE_ID CHAR(36) NOT NULL, MAP_ID INT NOT NULL, PRIMARY KEY (INSTANCE_ID, MAP_ID))");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS IMAGE_MAP_INDEX_SEQUENCE (ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS IMAGE_MAP_UPDATE_STATE (IMAGE_INDEX INT NOT NULL PRIMARY KEY, LAST_UPDATED TIMESTAMP(3) NOT NULL, UPDATED_BY_INSTANCE CHAR(36) NOT NULL)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS PLAYERS (UUID CHAR(36) NOT NULL PRIMARY KEY, DATA LONGTEXT NOT NULL)");
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS PLAYER_UPDATE_STATE (UUID CHAR(36) NOT NULL PRIMARY KEY, LAST_UPDATED TIMESTAMP NOT NULL, UPDATED_BY_INSTANCE CHAR(36) NOT NULL)");
                try (Statement s2 = connection.createStatement();
                     ResultSet rsCount = s2.executeQuery("SELECT COUNT(*) FROM IMAGE_MAP_INDEX_SEQUENCE");){
                    int count = 0;
                    if (rsCount.next()) {
                        count = rsCount.getInt(1);
                    }
                    if (count != 0) break block47;
                    int nextVal = 1;
                    try (Statement s3 = connection.createStatement();
                         ResultSet rsMax = s3.executeQuery("SELECT MAX(IMAGE_INDEX) FROM IMAGE_MAPS");){
                        if (rsMax.next()) {
                            int max = rsMax.getInt(1);
                            if (!rsMax.wasNull()) {
                                nextVal = max + 1;
                            }
                        }
                    }
                    try (Statement alter = connection.createStatement();){
                        alter.executeUpdate("ALTER TABLE IMAGE_MAP_INDEX_SEQUENCE AUTO_INCREMENT = " + nextVal);
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to prepare database schema", e);
            }
        }
    }

    public File getLocalDataFolder() {
        return this.localDataFolder;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public UUID getInstanceId() {
        return this.instanceId;
    }

    public JdbcImageFrameStorageLoader getLoader() {
        return ImageFrameStorageLoaders.JDBC;
    }

    @Override
    public LazyBufferedImageSource getSource(int imageIndex, String fileName) {
        return new MySqlLazyBufferedImageSource(this, imageIndex, fileName);
    }

    @Override
    public Set<Integer> getAllImageIndexes() {
        String sql = "SELECT IMAGE_INDEX FROM IMAGE_MAPS";
        HashSet<Integer> result = new HashSet<Integer>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(rs.getInt("IMAGE_INDEX"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to fetch all ImageMap indexes from database", e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean hasImageMapData(int imageIndex) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void prepareImageIndex(ImageMap map, IntConsumer imageIndexSetter) {
        int originalImageIndex = map.getImageIndex();
        if (originalImageIndex < 0) {
            try {
                int newIndex = this.allocateNewImageIndex();
                imageIndexSetter.accept(newIndex);
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to allocate new image index from database", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int allocateNewImageIndex() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteMap(int imageIndex) {
        String selectInstanceDataSql = "SELECT INSTANCE_ID, DATA FROM INSTANCE_IMAGE_MAP_DATA WHERE IMAGE_INDEX = ?";
        String insertDeletedSql = "INSERT INTO DELETED_MAPS (INSTANCE_ID, MAP_ID) VALUES (?, ?) ON DUPLICATE KEY UPDATE MAP_ID = MAP_ID";
        String deleteImagesSql = "DELETE FROM IMAGE_MAP_IMAGES WHERE IMAGE_INDEX = ?";
        String deleteInstanceDataSql = "DELETE FROM INSTANCE_IMAGE_MAP_DATA WHERE IMAGE_INDEX = ?";
        String deleteMapSql = "DELETE FROM IMAGE_MAPS WHERE IMAGE_INDEX = ?";
        String sqlUpdateState = "INSERT INTO IMAGE_MAP_UPDATE_STATE (IMAGE_INDEX, LAST_UPDATED, UPDATED_BY_INSTANCE) VALUES (?, NOW(), ?) ON DUPLICATE KEY UPDATE LAST_UPDATED = VALUES(LAST_UPDATED), UPDATED_BY_INSTANCE = VALUES(UPDATED_BY_INSTANCE)";
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement psSelect = connection.prepareStatement(selectInstanceDataSql);){
                psSelect.setInt(1, imageIndex);
                try (ResultSet rs = psSelect.executeQuery();
                     PreparedStatement psInsert = connection.prepareStatement(insertDeletedSql);){
                    while (rs.next()) {
                        JsonObject obj;
                        String instId = rs.getString("INSTANCE_ID");
                        String json = rs.getString("DATA");
                        if (json == null || (obj = GSON.fromJson(json, JsonObject.class)) == null || !obj.has("mapdata") || !obj.get("mapdata").isJsonArray()) continue;
                        JsonArray mapdataArray = obj.getAsJsonArray("mapdata");
                        for (JsonElement el : mapdataArray) {
                            JsonObject entry;
                            if (!el.isJsonObject() || !(entry = el.getAsJsonObject()).has("mapid")) continue;
                            int mapId = entry.get("mapid").getAsInt();
                            psInsert.setString(1, instId);
                            psInsert.setInt(2, mapId);
                            psInsert.addBatch();
                        }
                    }
                    psInsert.executeBatch();
                }
            }
            try (PreparedStatement ps = connection.prepareStatement(deleteImagesSql);){
                ps.setInt(1, imageIndex);
                ps.executeUpdate();
            }
            ps = connection.prepareStatement(deleteInstanceDataSql);
            try {
                ps.setInt(1, imageIndex);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = connection.prepareStatement(deleteMapSql);
            try {
                ps.setInt(1, imageIndex);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = connection.prepareStatement(sqlUpdateState);
            try {
                ps.setInt(1, imageIndex);
                ps.setString(2, this.instanceId.toString());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Error while deleting ImageMap " + imageIndex + " from database.");
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public JsonObject loadImageMapData(int imageIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<MutablePair<String, Future<? extends ImageMap>>> loadMaps(ImageMapManager imageMapManager, Set<Integer> deletedMapIds, IFPlayerManager ifPlayerManager) {
        ArrayList<MutablePair<String, Future<? extends ImageMap>>> futures = new ArrayList<MutablePair<String, Future<? extends ImageMap>>>();
        String sqlMaps = "SELECT BASE.IMAGE_INDEX AS IMAGE_INDEX, BASE.DATA AS BASE_DATA, INST.DATA AS INST_DATA FROM IMAGE_MAPS BASE LEFT JOIN INSTANCE_IMAGE_MAP_DATA INST ON INST.IMAGE_INDEX = BASE.IMAGE_INDEX AND INST.INSTANCE_ID = ? ORDER BY BASE.IMAGE_INDEX ASC";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sqlMaps);){
            ps.setString(1, this.instanceId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int imageIndex = rs.getInt("IMAGE_INDEX");
                    String baseJsonString = rs.getString("BASE_DATA");
                    JsonObject baseJson = GSON.fromJson(baseJsonString, JsonObject.class);
                    String instanceJsonString = rs.getString("INST_DATA");
                    JsonObject instanceJson = instanceJsonString == null ? new JsonObject() : GSON.fromJson(instanceJsonString, JsonObject.class);
                    JsonObject mergedJson = JsonUtils.merge(baseJson, instanceJson).getAsJsonObject();
                    Future<? extends ImageMap> future = ImageMapLoaders.load(imageMapManager, mergedJson);
                    futures.add(new MutablePair<String, Future<? extends ImageMap>>("database:" + imageIndex, future));
                }
            }
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMap data from database.");
            e.printStackTrace();
        }
        deletedMapIds.addAll(this.loadDeletedMaps());
        this.setupTasks(imageMapManager, ifPlayerManager);
        return futures;
    }

    public void activeUpdate(ImageMapManager imageMapManager, IFPlayerManager ifPlayerManager) {
        try {
            long lastUpdated = this.lastUpdateFetch.get();
            List<ImageMapUpdateInfo> imageMapUpdateInfo = this.getUpdatedImageIndexesSince(lastUpdated);
            for (ImageMapUpdateInfo info : imageMapUpdateInfo) {
                try {
                    imageMapManager.updateMap(info.getImageIndex(), info.exists());
                    lastUpdated = Math.max(lastUpdated, info.getLastUpdated());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            List<PlayerUpdateInfo> playerUpdateInfo = this.getUpdatedPlayersSince(lastUpdated);
            Map<UUID, JsonObject> playerInfo = this.loadPlayerDataBulk(playerUpdateInfo.stream().map(p -> p.getUniqueId()).collect(Collectors.toSet()));
            for (PlayerUpdateInfo info : playerUpdateInfo) {
                try {
                    UUID uuid = info.getUniqueId();
                    IFPlayer ifPlayer = ifPlayerManager.getIFPlayerIfLoaded(uuid);
                    JsonObject playerJson = playerInfo.get(uuid);
                    if (ifPlayer != null && playerJson != null) {
                        ifPlayer.applyUpdate(playerJson);
                    }
                    lastUpdated = Math.max(lastUpdated, info.getLastUpdated());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.lastUpdateFetch.set(lastUpdated);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveImageMapData(int imageIndex, JsonObject json) throws IOException {
        JsonObject instanceJson = new JsonObject();
        JsonArray instanceMapDataJson = new JsonArray();
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        for (JsonElement dataJson : mapDataJson) {
            int mapId = dataJson.getAsJsonObject().remove("mapid").getAsInt();
            JsonObject instanceDataJson = new JsonObject();
            instanceDataJson.addProperty("mapid", mapId);
            instanceMapDataJson.add(instanceDataJson);
        }
        instanceJson.add("mapdata", instanceMapDataJson);
        String sqlMain = "INSERT INTO IMAGE_MAPS (IMAGE_INDEX, DATA) VALUES (?, ?) ON DUPLICATE KEY UPDATE DATA = VALUES(DATA)";
        String sqlInst = "INSERT INTO INSTANCE_IMAGE_MAP_DATA (IMAGE_INDEX, INSTANCE_ID, DATA) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE DATA = VALUES(DATA)";
        String sqlUpdateState = "INSERT INTO IMAGE_MAP_UPDATE_STATE (IMAGE_INDEX, LAST_UPDATED, UPDATED_BY_INSTANCE) VALUES (?, NOW(), ?) ON DUPLICATE KEY UPDATE LAST_UPDATED = VALUES(LAST_UPDATED), UPDATED_BY_INSTANCE = VALUES(UPDATED_BY_INSTANCE)";
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement ps = connection.prepareStatement(sqlMain);){
                ps.setInt(1, imageIndex);
                ps.setString(2, GSON.toJson(json));
                ps.executeUpdate();
            }
            ps = connection.prepareStatement(sqlInst);
            try {
                ps.setInt(1, imageIndex);
                ps.setString(2, this.instanceId.toString());
                ps.setString(3, GSON.toJson(instanceJson));
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            ps = connection.prepareStatement(sqlUpdateState);
            try {
                ps.setInt(1, imageIndex);
                ps.setString(2, this.instanceId.toString());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IOException("Unable to save ImageMap data for image index " + imageIndex, e);
        }
    }

    @Override
    public Set<Integer> loadDeletedMaps() {
        HashSet<Integer> deletedMapIds = new HashSet<Integer>();
        String sqlDeleted = "SELECT MAP_ID FROM DELETED_MAPS WHERE INSTANCE_ID = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement ps = connection.prepareStatement(sqlDeleted);){
            ps.setString(1, this.instanceId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    deletedMapIds.add(rs.getInt("MAP_ID"));
                }
            }
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load deleted ImageMap IDs from database.");
            e.printStackTrace();
        }
        return deletedMapIds;
    }

    @Override
    public void saveDeletedMaps(Set<Integer> deletedMapIds) {
        String deleteSql = "DELETE FROM DELETED_MAPS WHERE INSTANCE_ID = ?";
        String insertSql = "INSERT INTO DELETED_MAPS (INSTANCE_ID, MAP_ID) VALUES (?, ?)";
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement ps = connection.prepareStatement(deleteSql);){
                ps.setString(1, this.instanceId.toString());
                ps.executeUpdate();
            }
            ps = connection.prepareStatement(insertSql);
            try {
                for (int mapId : deletedMapIds) {
                    ps.setString(1, this.instanceId.toString());
                    ps.setInt(2, mapId);
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to save deleted ImageMap IDs for instance " + this.instanceId);
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public JsonObject loadPlayerData(IFPlayerManager manager, UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Map<UUID, JsonObject> loadPlayerDataBulk(Set<UUID> uuids) {
        HashMap<UUID, JsonObject> result;
        block29: {
            if (uuids == null || uuids.isEmpty()) {
                return Collections.emptyMap();
            }
            result = new HashMap<UUID, JsonObject>();
            StringBuilder sqlBuilder = new StringBuilder("SELECT UUID, DATA FROM PLAYERS WHERE UUID IN (");
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < uuids.size(); ++i) {
                joiner.add("?");
            }
            sqlBuilder.append(joiner).append(")");
            String sql = sqlBuilder.toString();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement ps = connection.prepareStatement(sql);){
                int index = 1;
                for (UUID uuid : uuids) {
                    ps.setString(index++, uuid.toString());
                }
                ResultSet rs = ps.executeQuery();
                block23: while (true) {
                    while (rs.next()) {
                        UUID uuid;
                        String uuidStr = rs.getString("UUID");
                        String jsonString = rs.getString("DATA");
                        try {
                            uuid = UUID.fromString(uuidStr);
                        }
                        catch (IllegalArgumentException ignored) {
                            continue;
                        }
                        try {
                            JsonObject json = GSON.fromJson(jsonString, JsonObject.class);
                            if (json == null) continue block23;
                            result.put(uuid, json);
                            continue block23;
                        }
                        catch (Exception exception) {
                        }
                    }
                    break block29;
                    {
                        continue block23;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to bulk load player data from database", e);
            }
        }
        return result;
    }

    @Override
    public void savePlayerData(UUID uuid, JsonObject json) throws IOException {
        String sqlPlayer = "INSERT INTO PLAYERS (UUID, DATA) VALUES (?, ?) ON DUPLICATE KEY UPDATE DATA = VALUES(DATA)";
        String sqlUpdateState = "INSERT INTO PLAYER_UPDATE_STATE (UUID, LAST_UPDATED, UPDATED_BY_INSTANCE) VALUES (?, NOW(), ?) ON DUPLICATE KEY UPDATE LAST_UPDATED = VALUES(LAST_UPDATED), UPDATED_BY_INSTANCE = VALUES(UPDATED_BY_INSTANCE)";
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement ps = connection.prepareStatement(sqlPlayer);){
                ps.setString(1, uuid.toString());
                ps.setString(2, GSON.toJson(json));
                ps.executeUpdate();
            }
            ps = connection.prepareStatement(sqlUpdateState);
            try {
                ps.setString(1, uuid.toString());
                ps.setString(2, this.instanceId.toString());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            throw new IOException("Unable to save ImageFrame player data for " + uuid + " to database", e);
        }
    }

    @Override
    public Set<UUID> getAllSavedPlayerData() {
        HashSet<UUID> result;
        block24: {
            String sql = "SELECT UUID FROM PLAYERS";
            result = new HashSet<UUID>();
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement ps = connection.prepareStatement(sql);){
                ResultSet rs = ps.executeQuery();
                block19: while (true) {
                    while (rs.next()) {
                        String uuidStr = rs.getString("uuid");
                        try {
                            result.add(UUID.fromString(uuidStr));
                            continue block19;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                    break block24;
                    {
                        continue block19;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Unable to load ImageFrame player data list from database", e);
            }
        }
        return result;
    }

    public List<ImageMapUpdateInfo> getUpdatedImageIndexesSince(long sinceMillis) throws IOException {
        String sql = "SELECT UPD.IMAGE_INDEX AS IMAGE_INDEX, UPD.LAST_UPDATED AS LAST_UPDATED, BASE.IMAGE_INDEX AS EXISTS_FLAG FROM IMAGE_MAP_UPDATE_STATE UPD LEFT JOIN IMAGE_MAPS BASE ON BASE.IMAGE_INDEX = UPD.IMAGE_INDEX WHERE UPD.LAST_UPDATED > ? AND UPD.UPDATED_BY_INSTANCE <> ?";
        String pruneSql = "DELETE FROM IMAGE_MAP_UPDATE_STATE WHERE LAST_UPDATED < (NOW() - INTERVAL 14 DAY)";
        ArrayList<ImageMapUpdateInfo> result = new ArrayList<ImageMapUpdateInfo>();
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setTimestamp(1, new Timestamp(sinceMillis));
                ps.setString(2, this.instanceId.toString());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int imageIndex = rs.getInt("IMAGE_INDEX");
                        boolean exists = rs.getObject("EXISTS_FLAG") != null;
                        Timestamp lastUpdated = rs.getTimestamp("LAST_UPDATED");
                        result.add(new ImageMapUpdateInfo(imageIndex, exists, lastUpdated.getTime()));
                    }
                }
            }
            try (PreparedStatement prune = connection.prepareStatement(pruneSql);){
                prune.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new IOException("Unable to fetch updated image indices since " + sinceMillis, e);
        }
        return result;
    }

    public List<PlayerUpdateInfo> getUpdatedPlayersSince(long sinceMillis) throws IOException {
        String sql = "SELECT PUS.UUID AS UUID, PUS.LAST_UPDATED AS LAST_UPDATED FROM PLAYER_UPDATE_STATE PUS WHERE PUS.LAST_UPDATED > ? AND PUS.UPDATED_BY_INSTANCE <> ?";
        String pruneSql = "DELETE FROM PLAYER_UPDATE_STATE WHERE LAST_UPDATED < (NOW() - INTERVAL 14 DAY)";
        ArrayList<PlayerUpdateInfo> result = new ArrayList<PlayerUpdateInfo>();
        try (Connection connection = this.dataSource.getConnection();){
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setTimestamp(1, new Timestamp(sinceMillis));
                ps.setString(2, this.instanceId.toString());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        UUID uuid;
                        String uuidStr = rs.getString("UUID");
                        Timestamp lastUpdated = rs.getTimestamp("LAST_UPDATED");
                        try {
                            uuid = UUID.fromString(uuidStr);
                        }
                        catch (IllegalArgumentException e) {
                            continue;
                        }
                        long lastUpdatedMillis = lastUpdated != null ? lastUpdated.getTime() : 0L;
                        result.add(new PlayerUpdateInfo(uuid, lastUpdatedMillis));
                    }
                }
            }
            try (PreparedStatement prune = connection.prepareStatement(pruneSql);){
                prune.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new IOException("Unable to fetch updated players since " + sinceMillis, e);
        }
        return result;
    }

    @Override
    public void close() {
        if (this.updateFetchTask != null) {
            this.updateFetchTask.cancel();
        }
        if (this.periodicSyncTask != null) {
            this.periodicSyncTask.cancel();
        }
        this.dataSource.close();
    }

    public static class MySqlLazyBufferedImageSource
    implements LazyBufferedImageSource {
        private final JdbcImageFrameStorage storage;
        private final int imageIndex;
        private final String fileName;

        public MySqlLazyBufferedImageSource(JdbcImageFrameStorage storage, int imageIndex, String fileName) {
            this.storage = storage;
            this.imageIndex = imageIndex;
            this.fileName = fileName;
        }

        /*
         * Exception decompiling
         */
        @Override
        public BufferedImage loadImage() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 32[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void saveImage(BufferedImage image) throws IOException {
            String sql = "INSERT INTO IMAGE_MAP_IMAGES (IMAGE_INDEX, FILE_NAME, IMAGE) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE IMAGE = VALUES(IMAGE)";
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, "png", outputStream);
                byte[] bytes = outputStream.toByteArray();
                try (Connection connection = this.storage.getDataSource().getConnection();
                     PreparedStatement ps = connection.prepareStatement(sql);){
                    ps.setInt(1, this.imageIndex);
                    ps.setString(2, this.fileName);
                    ps.setBytes(3, bytes);
                    ps.executeUpdate();
                }
            }
            catch (SQLException e) {
                throw new IOException("Unable to save image data for imageIndex=" + this.imageIndex + ", fileName=" + this.fileName, e);
            }
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public MySqlLazyBufferedImageSource withFileName(String fileName) {
            return new MySqlLazyBufferedImageSource(this.storage, this.imageIndex, fileName);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MySqlLazyBufferedImageSource that = (MySqlLazyBufferedImageSource)o;
            return this.imageIndex == that.imageIndex && Objects.equals(this.storage.dataSource, that.storage.dataSource) && Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.storage.dataSource, this.imageIndex, this.fileName);
        }
    }

    public static class ImageMapUpdateInfo {
        private final int imageIndex;
        private final boolean exists;
        private final long lastUpdated;

        public ImageMapUpdateInfo(int imageIndex, boolean exists, long lastUpdated) {
            this.imageIndex = imageIndex;
            this.exists = exists;
            this.lastUpdated = lastUpdated;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        public boolean exists() {
            return this.exists;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }
    }

    public static class PlayerUpdateInfo {
        private final UUID uuid;
        private final long lastUpdated;

        public PlayerUpdateInfo(UUID uuid, long lastUpdated) {
            this.uuid = uuid;
            this.lastUpdated = lastUpdated;
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }
    }
}

