/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.nms.NMS;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.ImageMapAccessControl;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapCacheControlTask;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MapPacketSentCallback;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.storage.ImageFrameStorage;
import com.loohp.imageframe.utils.MapUtils;
import com.loohp.imageframe.utils.PlayerUtils;
import com.loohp.imageframe.utils.StringUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public abstract class ImageMap {
    public static final UUID CONSOLE_CREATOR = new UUID(0L, 0L);
    public static final String CONSOLE_CREATOR_NAME = "Console";
    public static final String UNKNOWN_CREATOR_NAME = "???";
    protected final ImageMapManager manager;
    protected final ImageMapLoader<?, ?> loader;
    protected int imageIndex;
    protected String name;
    protected final List<MapView> mapViews;
    protected final List<Integer> mapIds;
    protected final List<Map<String, MapCursor>> mapMarkers;
    protected final int width;
    protected final int height;
    protected DitheringType ditheringType;
    protected UUID creator;
    protected ImageMapAccessControl accessControl;
    protected final long creationTime;
    protected final ImageMapCacheControlTask cacheControlTask;
    private boolean isValid;

    public ImageMap(ImageMapManager manager, ImageMapLoader<?, ?> loader, int imageIndex, String name, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime) {
        if (mapViews.size() != width * height) {
            throw new IllegalArgumentException("mapViews size does not equal width * height");
        }
        if (mapViews.size() != mapMarkers.size()) {
            throw new IllegalArgumentException("mapViews size does not equal mapMarkers size");
        }
        if (mapViews.size() != mapIds.size()) {
            throw new IllegalArgumentException("mapViews size does not equal mapIds size");
        }
        this.manager = manager;
        this.loader = loader;
        this.imageIndex = imageIndex;
        this.name = StringUtils.sanitize(name);
        this.mapViews = Collections.unmodifiableList(mapViews);
        this.mapIds = Collections.unmodifiableList(mapIds);
        this.mapMarkers = Collections.unmodifiableList(mapMarkers);
        this.width = width;
        this.height = height;
        this.ditheringType = ditheringType;
        this.creator = creator;
        this.accessControl = new ImageMapAccessControl(this, hasAccess);
        this.creationTime = creationTime;
        this.cacheControlTask = ImageFrame.cacheControlMode.newInstance(this);
        this.isValid = true;
        this.accessControl.setPermissionWithoutSave(creator, null);
    }

    public ImageMapManager getManager() {
        return this.manager;
    }

    public Key getType() {
        return this.loader.getIdentifier();
    }

    @Deprecated
    public String getLegacyType() {
        return this.loader.getLegacyType();
    }

    public boolean applyUpdate(JsonObject json) {
        this.name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        this.creator = UUID.fromString(json.get("creator").getAsString());
        DitheringType previousDitheringType = this.ditheringType;
        this.ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            HashMap<UUID, ImageMapAccessPermissionType> hasAccess = new HashMap<UUID, ImageMapAccessPermissionType>(accessJson.size());
            for (Map.Entry entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString((String)entry.getKey()), ImageMapAccessPermissionType.valueOf(((JsonElement)entry.getValue()).getAsString().toUpperCase()));
            }
            this.accessControl.reapply(hasAccess);
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        int i = 0;
        for (JsonElement jsonElement : mapDataJson) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            ConcurrentHashMap<String, MapCursor> mapCursors = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    mapCursors.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            Map<String, MapCursor> markers = this.mapMarkers.get(i++);
            markers.clear();
            markers.putAll(mapCursors);
        }
        return previousDitheringType != this.ditheringType;
    }

    protected abstract void loadColorCache();

    protected void reloadColorCache() {
        if (this.hasColorCached()) {
            this.loadColorCache();
        } else {
            this.cacheControlTask.loadCacheIfManual();
        }
    }

    protected abstract boolean hasColorCached();

    protected abstract void unloadColorCache();

    public BufferedImage getOriginalImage(int mapId) {
        return null;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String name) throws Exception {
        this.name = StringUtils.sanitize(name);
        this.save();
    }

    public List<Integer> getMapIds() {
        return this.mapIds;
    }

    protected void markInvalid() {
        this.isValid = false;
        this.cacheControlTask.close();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void stop() {
        for (MapView mapView : this.mapViews) {
            for (MapRenderer mapRenderer : mapView.getRenderers()) {
                mapView.removeRenderer(mapRenderer);
            }
        }
    }

    public boolean requiresAnimationService() {
        return false;
    }

    public int getCurrentPositionInSequenceWithOffset() {
        return 0;
    }

    public boolean isAnimationPaused() {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public void setAnimationPause(boolean pause) throws Exception {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public void setCurrentPositionInSequence(int position) {
    }

    public void setAnimationPlaybackTime(double seconds) throws Exception {
    }

    public int getCurrentPositionInSequence() {
        return this.getCurrentPositionInSequenceWithOffset() % this.getSequenceLength();
    }

    public int getSequenceLength() {
        return 1;
    }

    public byte[] getRawAnimationColors(int currentTick, int index) {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public int getAnimationFakeMapId(int currentTick, int index, boolean lookbehind) {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public void sendAnimationFakeMaps(Collection<? extends Player> players, MapPacketSentCallback completionCallback) {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public Set<Integer> getFakeMapIds() {
        throw new UnsupportedOperationException("this map does not require animation");
    }

    public boolean trackDeletedMaps() {
        return true;
    }

    public DitheringType getDitheringType() {
        return this.ditheringType == null ? DitheringType.NEAREST_COLOR : this.ditheringType;
    }

    public void setDitheringType(DitheringType ditheringType) throws Exception {
        this.ditheringType = ditheringType;
        this.save();
    }

    public abstract ImageMap deepClone(String var1, UUID var2) throws Exception;

    public abstract void update(boolean var1) throws Exception;

    public void update() throws Exception {
        this.update(true);
    }

    public void send(Player player) {
        this.send(Collections.singleton(player));
    }

    public void send(Collection<? extends Player> players) {
        for (MapView mapView : this.mapViews) {
            MapUtils.sendImageMap(mapView, players);
        }
    }

    public void save() throws Exception {
        this.save(this.manager.getStorage(), false);
    }

    public abstract void save(ImageFrameStorage var1, boolean var2) throws Exception;

    public ItemStack getMap(int x, int y, String mapNameFormat) {
        return this.getMap(x, y, mapNameFormat, itemStack -> itemStack);
    }

    public ItemStack getMap(int x, int y, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        if (x >= this.width || y >= this.height) {
            throw new IndexOutOfBoundsException("x, y position out of image map size");
        }
        MapView mapView = this.mapViews.get(y * this.width + x);
        ItemStack itemStack = new ItemStack(Material.FILLED_MAP);
        MapMeta mapMeta = (MapMeta)itemStack.getItemMeta();
        mapMeta.setMapView(mapView);
        mapMeta.setLore(Collections.singletonList(mapNameFormat.replace("{ImageID}", this.getImageIndex() + "").replace("{X}", x + "").replace("{Y}", y + "").replace("{Name}", this.getName()).replace("{Width}", this.getWidth() + "").replace("{Height}", this.getHeight() + "").replace("{DitheringType}", this.getDitheringType().getName()).replace("{CreatorName}", this.getCreatorName()).replace("{CreatorUUID}", this.getCreator().toString()).replace("{TimeCreated}", ImageFrame.dateFormat.format(new Date(this.getCreationTime())))));
        itemStack.setItemMeta((ItemMeta)mapMeta);
        return postCreationFunction.apply(itemStack);
    }

    public List<ItemStack> getMaps(String mapNameFormat) {
        return this.getMaps(mapNameFormat, itemStack -> itemStack);
    }

    public List<ItemStack> getMaps(String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        ArrayList<ItemStack> maps = new ArrayList<ItemStack>(this.mapViews.size());
        int i = 0;
        for (MapView mapView : this.mapViews) {
            ItemStack itemStack = new ItemStack(Material.FILLED_MAP);
            MapMeta mapMeta = (MapMeta)itemStack.getItemMeta();
            mapMeta.setMapView(mapView);
            mapMeta.setLore(Collections.singletonList(mapNameFormat.replace("{ImageID}", this.getImageIndex() + "").replace("{X}", i % this.width + "").replace("{Y}", i / this.width + "").replace("{Name}", this.getName()).replace("{Width}", this.getWidth() + "").replace("{Height}", this.getHeight() + "").replace("{DitheringType}", this.getDitheringType().getName()).replace("{CreatorName}", this.getCreatorName()).replace("{CreatorUUID}", this.getCreator().toString()).replace("{TimeCreated}", ImageFrame.dateFormat.format(new Date(this.getCreationTime())))));
            itemStack.setItemMeta((ItemMeta)mapMeta);
            maps.add(postCreationFunction.apply(itemStack));
            ++i;
        }
        return maps;
    }

    public void giveMap(Player player, int x, int y, String mapNameFormat) {
        this.giveMap(Collections.singleton(player), x, y, mapNameFormat, (ItemStack itemStack) -> itemStack);
    }

    public void giveMap(Player player, int x, int y, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        this.giveMap(Collections.singleton(player), x, y, mapNameFormat, postCreationFunction);
    }

    public void giveMap(Collection<? extends Player> players, int x, int y, String mapNameFormat) {
        this.giveMap(players, x, y, mapNameFormat, (ItemStack itemStack) -> itemStack);
    }

    public void giveMap(Collection<? extends Player> players, int x, int y, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        ItemStack map = this.getMap(x, y, mapNameFormat, postCreationFunction);
        for (Player player : players) {
            PlayerUtils.giveItem(player, map.clone());
        }
    }

    public void giveMaps(Player player, String mapNameFormat) {
        this.giveMaps(Collections.singleton(player), mapNameFormat, (ItemStack itemStack) -> itemStack);
    }

    public void giveMaps(Player player, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        this.giveMaps(Collections.singleton(player), mapNameFormat, postCreationFunction);
    }

    public void giveMaps(Collection<? extends Player> players, String mapNameFormat) {
        this.giveMaps(players, mapNameFormat, (ItemStack itemStack) -> itemStack);
    }

    public void giveMaps(Collection<? extends Player> players, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        List<ItemStack> maps = this.getMaps(mapNameFormat, postCreationFunction);
        for (ItemStack map : maps) {
            for (Player player : players) {
                PlayerUtils.giveItem(player, map.clone());
            }
        }
    }

    public void fillItemFrames(List<ItemFrame> itemFrames, Rotation rotation, BiPredicate<ItemFrame, ItemStack> prePlaceCheck, BiConsumer<ItemFrame, ItemStack> unableToPlaceAction, String mapNameFormat) {
        this.fillItemFrames(itemFrames, rotation, prePlaceCheck, unableToPlaceAction, mapNameFormat, itemStack -> itemStack);
    }

    public void fillItemFrames(List<ItemFrame> itemFrames, Rotation rotation, BiPredicate<ItemFrame, ItemStack> prePlaceCheck, BiConsumer<ItemFrame, ItemStack> unableToPlaceAction, String mapNameFormat, Function<ItemStack, ItemStack> postCreationFunction) {
        if (itemFrames.size() != this.mapViews.size()) {
            throw new IllegalArgumentException("itemFrames size does not equal to mapView size");
        }
        List<ItemStack> items = this.getMaps(mapNameFormat, postCreationFunction);
        Iterator<ItemFrame> itr0 = itemFrames.iterator();
        Iterator<ItemStack> itr1 = items.iterator();
        while (itr0.hasNext() && itr1.hasNext()) {
            ItemFrame frame = itr0.next();
            ItemStack item = itr1.next();
            Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                if (frame.isValid() && prePlaceCheck.test(frame, item)) {
                    frame.setItem(item, false);
                    frame.setRotation(rotation);
                    return;
                }
                unableToPlaceAction.accept(frame, item);
            }, (Entity)frame);
        }
    }

    public Set<Player> getViewers() {
        return this.mapViews.stream().flatMap(m -> NMS.getInstance().getViewers((MapView)m).stream()).collect(Collectors.toSet());
    }

    public boolean hasViewers() {
        return this.mapViews.stream().anyMatch(m -> NMS.getInstance().hasViewers((MapView)m));
    }

    public UUID getCreator() {
        return this.creator;
    }

    public void changeCreator(UUID creator) throws Exception {
        this.creator = creator;
        this.accessControl.setPermissionWithoutSave(creator, null);
        this.save();
    }

    public ImageMapAccessControl getAccessControl() {
        return this.accessControl;
    }

    public String getCreatorName() {
        if (this.creator.equals(CONSOLE_CREATOR)) {
            return CONSOLE_CREATOR_NAME;
        }
        String name = Bukkit.getOfflinePlayer((UUID)this.creator).getName();
        return name == null ? UNKNOWN_CREATOR_NAME : name;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public List<MapView> getMapViews() {
        return this.mapViews;
    }

    public MapView getMapViewFromMapId(int mapId) {
        return this.mapViews.get(this.mapIds.indexOf(mapId));
    }

    public List<Map<String, MapCursor>> getMapMarkers() {
        return this.mapMarkers;
    }

    public Map<String, MapCursor> getMapMarkers(MapView mapView) {
        return this.mapMarkers.get(this.mapViews.indexOf(mapView));
    }

    public MapCursor getMapMarker(String name) {
        return this.mapMarkers.stream().flatMap(each -> each.entrySet().stream()).filter(each -> ((String)each.getKey()).equalsIgnoreCase(name)).findFirst().map(each -> (MapCursor)each.getValue()).orElse(null);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static abstract class ImageMapRenderer
    extends MapRenderer {
        protected final ImageMapManager manager;
        protected final ImageMap imageMap;
        protected final int index;

        public ImageMapRenderer(ImageMapManager manager, ImageMap imageMap, int index) {
            super(ImageFrame.mapRenderersContextual);
            this.manager = manager;
            this.imageMap = imageMap;
            this.index = index;
        }

        public void render(MapView mapView, MapCanvas canvas, Player player) {
            MutablePair<byte[], Collection<MapCursor>> renderData = this.renderMap(mapView, 0, player);
            this.manager.callRenderEventListener(this.manager, this.imageMap, mapView, player, renderData);
            byte[] colors = renderData.getFirst();
            if (colors != null) {
                for (int i = 0; i < colors.length; ++i) {
                    canvas.setPixel(i % 128, i / 128, colors[i]);
                }
            }
            canvas.setCursors(MapUtils.toMapCursorCollection(renderData.getSecond()));
        }

        public MutablePair<byte[], Collection<MapCursor>> renderPacketData(MapView mapView, int currentTick, Player player) {
            MutablePair<byte[], Collection<MapCursor>> renderData = this.renderMap(mapView, currentTick, player);
            this.manager.callRenderEventListener(this.manager, this.imageMap, mapView, player, renderData);
            return renderData;
        }

        public MutablePair<byte[], Collection<MapCursor>> renderPacketData(MapView mapView, Player player) {
            MutablePair<byte[], Collection<MapCursor>> renderData = this.renderMap(mapView, player);
            this.manager.callRenderEventListener(this.manager, this.imageMap, mapView, player, renderData);
            return renderData;
        }

        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, int currentTick, Player player) {
            return this.renderMap(mapView, player);
        }

        public abstract MutablePair<byte[], Collection<MapCursor>> renderMap(MapView var1, Player var2);
    }
}

