/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.IFPlayer;
import com.loohp.imageframe.storage.ImageFrameStorage;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class IFPlayerManager
implements AutoCloseable,
Listener {
    private final ImageFrameStorage imageFrameStorage;
    private final Map<UUID, IFPlayer> loadedPlayers;
    private final Set<IFPlayer> persistentLoadedPlayers;

    public IFPlayerManager(ImageFrameStorage imageFrameStorage) {
        this.imageFrameStorage = imageFrameStorage;
        Cache playersCache = CacheBuilder.newBuilder().weakValues().build();
        this.loadedPlayers = playersCache.asMap();
        this.persistentLoadedPlayers = ConcurrentHashMap.newKeySet();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)ImageFrame.plugin);
    }

    public ImageFrameStorage getStorage() {
        return this.imageFrameStorage;
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> this.persistentLoadedPlayers.add(this.getIFPlayer(event.getPlayer().getUniqueId())));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        IFPlayer ifPlayer = this.loadedPlayers.get(event.getPlayer().getUniqueId());
        if (ifPlayer != null) {
            Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
                try {
                    ifPlayer.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.persistentLoadedPlayers.remove(ifPlayer);
            });
        }
    }

    public IFPlayer getIFPlayer(UUID uuid) {
        return this.loadedPlayers.computeIfAbsent(uuid, id -> {
            JsonObject json = this.imageFrameStorage.loadPlayerData(this, (UUID)id);
            if (json != null) {
                return IFPlayer.load(this, json);
            }
            return this.createNewIfPlayer((UUID)id);
        });
    }

    public IFPlayer getIFPlayerIfLoaded(UUID uuid) {
        return this.loadedPlayers.get(uuid);
    }

    private IFPlayer createNewIfPlayer(UUID uuid) {
        try {
            return IFPlayer.create(this, uuid);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create ImageFrame player data for " + uuid, e);
        }
    }
}

