/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.utils;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.MutablePair;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ImageMapUtils {
    public static MutablePair<UUID, String> extractImageMapPlayerPrefixedName(CommandSender sender, String str) {
        int index = str.indexOf(58);
        if (index < 0) {
            return new MutablePair<UUID, String>(sender instanceof Player ? ((Player)sender).getUniqueId() : null, str);
        }
        String playerName = str.substring(0, index);
        String imageMapName = str.substring(index + 1);
        if (playerName.isEmpty() || playerName.trim().isEmpty()) {
            return new MutablePair<UUID, String>(sender instanceof Player ? ((Player)sender).getUniqueId() : null, imageMapName);
        }
        UUID playerUUID = Bukkit.getOfflinePlayer((String)playerName).getUniqueId();
        return new MutablePair<UUID, String>(playerUUID, imageMapName);
    }

    public static ImageMap getFromPlayerPrefixedName(CommandSender sender, String str) {
        ImageMap imageMap;
        if (sender instanceof Player && (imageMap = ImageFrame.imageMapManager.getFromCreator(((Player)sender).getUniqueId(), str)) != null) {
            return imageMap;
        }
        MutablePair<UUID, String> extraction = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, str);
        return ImageFrame.imageMapManager.getFromCreator(extraction.getFirst(), extraction.getSecond());
    }

    public static Set<String> getImageMapNameSuggestions(CommandSender sender, String str) {
        return ImageMapUtils.getImageMapNameSuggestions(sender, str, ImageMapAccessPermissionType.BASE, imageMap -> true);
    }

    public static Set<String> getImageMapNameSuggestions(CommandSender sender, String str, ImageMapAccessPermissionType permissionType, Predicate<ImageMap> predicate) {
        LinkedHashSet<String> tab = new LinkedHashSet<String>();
        if (sender instanceof Player) {
            for (ImageMap imageMap : ImageFrame.imageMapManager.getFromCreator(((Player)sender).getUniqueId())) {
                if (!imageMap.getName().toLowerCase().startsWith(str.toLowerCase()) || !predicate.test(imageMap)) continue;
                tab.add(imageMap.getName());
            }
        }
        if (!str.contains(":")) {
            return tab;
        }
        MutablePair<UUID, String> extraction = ImageMapUtils.extractImageMapPlayerPrefixedName(sender, str);
        UUID uuid = extraction.getFirst();
        if (uuid == null) {
            return tab;
        }
        for (ImageMap imageMap : ImageFrame.imageMapManager.getFromCreator(extraction.getFirst())) {
            String prefixedName;
            if (!ImageFrame.hasImageMapPermission(imageMap, sender, permissionType) || !(prefixedName = imageMap.getCreatorName() + ":" + imageMap.getName()).toLowerCase().startsWith(str.toLowerCase()) || !predicate.test(imageMap)) continue;
            tab.add(prefixedName);
        }
        return tab;
    }
}

