/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.URLAnimatedImageMap;
import com.loohp.imageframe.objectholders.URLImageMapCreateInfo;
import com.loohp.imageframe.utils.FutureUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLAnimatedImageMapLoader
extends ImageMapLoader<URLAnimatedImageMap, URLImageMapCreateInfo> {
    private static final Key IDENTIFIER = Key.key("imageframe", "url_animated");
    private static final String LEGACY_TYPE = "com.loohp.imageframe.objectholders.URLAnimatedImageMap";

    @Override
    public Key getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public String getLegacyType() {
        return LEGACY_TYPE;
    }

    @Override
    public Class<URLAnimatedImageMap> getImageMapClass() {
        return URLAnimatedImageMap.class;
    }

    @Override
    public Class<URLImageMapCreateInfo> getImageMapCreateInfoClass() {
        return URLImageMapCreateInfo.class;
    }

    @Override
    public List<String> getExtraPermissions() {
        return Collections.singletonList("imageframe.create.animated");
    }

    @Override
    public boolean isSupported(String imageType) {
        return "image/gif".equalsIgnoreCase(imageType);
    }

    @Override
    public boolean isPreferred(String imageType) {
        return this.isSupported(imageType);
    }

    @Override
    public Future<URLAnimatedImageMap> create(URLImageMapCreateInfo createInfo) throws Exception {
        World world = MapUtils.getMainWorld();
        int mapsCount = createInfo.getWidth() * createInfo.getHeight();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapsCount);
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            mapViewsFuture.add(MapUtils.createMap(world));
            markers.add(new ConcurrentHashMap());
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapsCount);
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapsCount);
        for (Future future : mapViewsFuture) {
            MapView mapView = (MapView)future.get();
            Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                for (MapRenderer renderer : mapView.getRenderers()) {
                    mapView.removeRenderer(renderer);
                }
            });
            mapViews.add(mapView);
            mapIds.add(mapView.getId());
        }
        URLAnimatedImageMap map = new URLAnimatedImageMap(createInfo.getManager(), this, -1, createInfo.getName(), createInfo.getUrl(), new FileLazyMappedBufferedImage[mapsCount][], mapViews, mapIds, markers, createInfo.getWidth(), createInfo.getHeight(), createInfo.getDitheringType(), createInfo.getCreator(), Collections.emptyMap(), System.currentTimeMillis(), -1, 0);
        return FutureUtils.callAsyncMethod(() -> {
            FutureUtils.callSyncMethod(() -> {
                for (int i = 0; i < mapViews.size(); ++i) {
                    ((MapView)mapViews.get(i)).addRenderer((MapRenderer)new URLAnimatedImageMap.URLAnimatedImageMapRenderer(map, i));
                }
            }).get();
            map.update(false);
            return map;
        });
    }

    @Override
    public Future<URLAnimatedImageMap> load(ImageMapManager manager, File folder, JsonObject json) throws Exception {
        Map<UUID, ImageMapAccessPermissionType> hasAccess;
        int imageIndex = json.get("index").getAsInt();
        String name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        String url = json.get("url").getAsString();
        int width = json.get("width").getAsInt();
        int height = json.get("height").getAsInt();
        DitheringType ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        long creationTime = json.get("creationTime").getAsLong();
        UUID creator = UUID.fromString(json.get("creator").getAsString());
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            hasAccess = new HashMap(accessJson.size());
            for (Map.Entry<String, JsonElement> entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString(entry.getKey()), ImageMapAccessPermissionType.valueOf(entry.getValue().getAsString().toUpperCase()));
            }
        } else {
            hasAccess = Collections.emptyMap();
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapDataJson.size());
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapDataJson.size());
        FileLazyMappedBufferedImage[][] cachedImages = new FileLazyMappedBufferedImage[mapDataJson.size()][];
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapDataJson.size());
        World world = (World)Bukkit.getWorlds().get(0);
        int i = 0;
        for (Object dataJson : mapDataJson) {
            JsonObject jsonObject = ((JsonElement)dataJson).getAsJsonObject();
            int mapId = jsonObject.get("mapid").getAsInt();
            mapIds.add(mapId);
            mapViewsFuture.add(MapUtils.getMapOrCreateMissing(world, mapId));
            JsonArray framesArray = jsonObject.get("images").getAsJsonArray();
            FileLazyMappedBufferedImage[] images = new FileLazyMappedBufferedImage[framesArray.size()];
            int u = 0;
            for (JsonElement element : framesArray) {
                images[u++] = FileLazyMappedBufferedImage.fromFile(new File(folder, element.getAsString()));
            }
            ConcurrentHashMap<String, MapCursor> mapCursors = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    mapCursors.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            markers.add(mapCursors);
            cachedImages[i++] = images;
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapViewsFuture.size());
        for (Future future : mapViewsFuture) {
            mapViews.add((MapView)future.get());
        }
        int pausedAt = json.has("pausedAt") ? json.get("pausedAt").getAsInt() : -1;
        int n = json.has("tickOffset") ? json.get("tickOffset").getAsInt() : 0;
        URLAnimatedImageMap map = new URLAnimatedImageMap(manager, this, imageIndex, name, url, cachedImages, mapViews, mapIds, markers, width, height, ditheringType, creator, hasAccess, creationTime, pausedAt, n);
        return FutureUtils.callSyncMethod(() -> {
            for (int u = 0; u < mapViews.size(); ++u) {
                MapView mapView = (MapView)mapViews.get(u);
                for (MapRenderer renderer : mapView.getRenderers()) {
                    mapView.removeRenderer(renderer);
                }
                mapView.addRenderer((MapRenderer)new URLAnimatedImageMap.URLAnimatedImageMapRenderer(map, u));
            }
            return map;
        });
    }
}

