/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonObject;
import com.loohp.imageframe.libs.net.kyori.adventure.key.Key;
import com.loohp.imageframe.media.GifReaderMediaLoader;
import com.loohp.imageframe.media.ImageIOMediaLoader;
import com.loohp.imageframe.media.MediaLoader;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapCreateInfo;
import com.loohp.imageframe.objectholders.ImageMapLoader;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.MinecraftURLOverlayImageMapLoader;
import com.loohp.imageframe.objectholders.NonUpdatableStaticImageMapLoader;
import com.loohp.imageframe.objectholders.URLAnimatedImageMapLoader;
import com.loohp.imageframe.objectholders.URLStaticImageMapLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class ImageMapLoaders {
    private static final List<ImageMapLoader<?, ?>> LOADERS_ORDERED = new CopyOnWriteArrayList();
    private static final Map<Key, ImageMapLoader<?, ?>> LOADERS_MAP = new ConcurrentHashMap();
    public static final URLStaticImageMapLoader URL_STATIC_IMAGE_MAP_LOADER = ImageMapLoaders.registerLoader(new URLStaticImageMapLoader());
    public static final URLAnimatedImageMapLoader URL_ANIMATED_IMAGE_MAP_LOADER = ImageMapLoaders.registerLoader(new URLAnimatedImageMapLoader());
    public static final MinecraftURLOverlayImageMapLoader MINECRAFT_URL_OVERLAY_IMAGE_MAP_LOADER = ImageMapLoaders.registerLoader(new MinecraftURLOverlayImageMapLoader());
    public static final NonUpdatableStaticImageMapLoader NON_UPDATABLE_IMAGE_MAP_LOADER = ImageMapLoaders.registerLoader(new NonUpdatableStaticImageMapLoader());
    public static final GifReaderMediaLoader GIF_READER_MEDIA_LOADER = ImageMapLoaders.registerLoader(new GifReaderMediaLoader(), URL_ANIMATED_IMAGE_MAP_LOADER);
    public static final ImageIOMediaLoader IMAGE_IO_MEDIA_LOADER = ImageMapLoaders.registerLoader(new ImageIOMediaLoader(), URL_STATIC_IMAGE_MAP_LOADER, MINECRAFT_URL_OVERLAY_IMAGE_MAP_LOADER);

    public static void init() {
    }

    public static <T extends ImageMapLoader<?, ?>> T registerLoader(T loader) {
        LOADERS_ORDERED.add(loader);
        LOADERS_MAP.put(loader.getIdentifier(), loader);
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GRAY + "[ImageFrame] Registered ImageMapLoader " + loader.getIdentifier().asString());
        return loader;
    }

    public static <T extends ImageMapLoader<?, ?>> T getLoader(Class<T> loaderClass) {
        return (T)((ImageMapLoader)LOADERS_ORDERED.stream().filter(l -> loaderClass.equals(l.getClass())).findFirst().orElse(null));
    }

    public static <T extends ImageMap, C extends ImageMapCreateInfo> ImageMapLoader<? extends T, C> getLoader(Class<T> imageMapClass, Class<C> createInfoClass, String imageType, CommandSender sender) {
        return LOADERS_ORDERED.stream().filter(l -> imageMapClass.isAssignableFrom(l.getImageMapClass())).filter(l -> createInfoClass.equals(l.getImageMapCreateInfoClass())).filter(l -> l.isSupported(imageType)).filter(l -> l.getExtraPermissions().stream().allMatch(p -> sender.hasPermission(p))).max(Comparator.comparing(l -> l.isPreferred(imageType))).orElse(null);
    }

    public static <T extends ImageMap> ImageMapLoader<?, ?> getLoader(Key identifier) {
        return LOADERS_MAP.get(identifier);
    }

    public static <T extends ImageMap> ImageMapLoader<?, ?> getLoader(String identifier) {
        if (identifier.contains(":")) {
            return ImageMapLoaders.getLoader(Key.key(identifier));
        }
        return LOADERS_ORDERED.stream().filter(l -> identifier.equalsIgnoreCase(l.getLegacyType())).findFirst().orElse(null);
    }

    public static Future<? extends ImageMap> load(ImageMapManager manager, File folder) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            JsonObject json = ImageMap.GSON.fromJson((Reader)reader, JsonObject.class);
            String type = json.get("type").getAsString();
            ImageMapLoader<?, ?> loader = ImageMapLoaders.getLoader(type);
            if (loader == null) {
                throw new IllegalStateException("Unable to find ImageMapLoader " + type);
            }
            Future<?> future = loader.load(manager, folder, json);
            return future;
        }
    }

    private static <T extends MediaLoader> T registerLoader(T loader, ImageMapLoader<?, ?> ... imageMapLoaders) {
        for (ImageMapLoader<?, ?> imageMapLoader : imageMapLoaders) {
            imageMapLoader.registerMediaLoaderLast(loader);
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GRAY + "[ImageFrame] Registered MediaLoader " + loader.getIdentifier().asString() + " to ImageMapLoader " + imageMapLoader.getIdentifier().asString());
        }
        return loader;
    }
}

