/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.metrics;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.metrics.Metrics;
import com.loohp.imageframe.objectholders.ImageMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bukkit.map.MapCursor;

public class Charts {
    public static void setup(Metrics metrics) {
        metrics.addCustomChart(new Metrics.SingleLineChart("total_images_created", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ImageFrame.imageMapManager.getMaps().size();
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("total_maps_created", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ImageFrame.imageMapManager.getMaps().stream().mapToInt(each -> each.getMapViews().size()).sum();
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("images_created_by_type_id", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (ImageMap imageMap : ImageFrame.imageMapManager.getMaps()) {
                    String type = imageMap.getType().asString();
                    valueMap.merge(type, 1, Integer::sum);
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("images_created_by_type", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (ImageMap imageMap : ImageFrame.imageMapManager.getMaps()) {
                    String type = imageMap.getLegacyType();
                    if (type == null) continue;
                    valueMap.merge(type, 1, Integer::sum);
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("total_markers_created", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ImageFrame.imageMapManager.getMaps().stream().flatMap(each -> each.getMapMarkers().stream()).mapToInt(each -> each.size()).sum();
            }
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("markers_created_by_type", new Callable<Map<String, Integer>>(){

            @Override
            public Map<String, Integer> call() throws Exception {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (ImageMap imageMap : ImageFrame.imageMapManager.getMaps()) {
                    for (Map<String, MapCursor> map : imageMap.getMapMarkers()) {
                        for (MapCursor mapCursor : map.values()) {
                            String type = mapCursor.getType().name().toLowerCase();
                            valueMap.merge(type, 1, Integer::sum);
                        }
                    }
                }
                return valueMap;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("item_frames_made_invisible_in_last_interval", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                long value = ImageFrame.invisibleFrameManager.getItemFramesMadeInvisible().getAndSet(0L);
                return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("invisible_item_frames_placed_in_last_interval", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                long value = ImageFrame.invisibleFrameManager.getInvisibleItemFramesPlaced().getAndSet(0L);
                return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("embedded_service_image_uploaded_in_last_interval", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                long value = ImageFrame.imageUploadManager.getImagesUploadedCounter().getAndSet(0L);
                return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
            }
        }));
        metrics.addCustomChart(new Metrics.SingleLineChart("players_with_imageframe_client", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ImageFrame.customClientNetworkManager.getPlayers().size();
            }
        }));
    }
}

