/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.api.events.ImageMapUpdatedEvent;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.DitheringType;
import com.loohp.imageframe.objectholders.FileLazyMappedBufferedImage;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapAccessPermissionType;
import com.loohp.imageframe.objectholders.ImageMapManager;
import com.loohp.imageframe.objectholders.IntPosition;
import com.loohp.imageframe.objectholders.MapPacketSentCallback;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.objectholders.URLImageMap;
import com.loohp.imageframe.utils.FutureUtils;
import com.loohp.imageframe.utils.GifReader;
import com.loohp.imageframe.utils.HTTPRequestUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class URLAnimatedImageMap
extends URLImageMap {
    protected final FileLazyMappedBufferedImage[][] cachedImages;
    protected byte[][][] cachedColors;
    protected int[][] fakeMapIds;
    protected Set<Integer> fakeMapIdsSet;
    protected int pausedAt;
    protected int tickOffset;

    public static Future<? extends URLAnimatedImageMap> create(ImageMapManager manager, String name, String url, int width, int height, DitheringType ditheringType, UUID creator) throws Exception {
        World world = MapUtils.getMainWorld();
        int mapsCount = width * height;
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapsCount);
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapsCount);
        for (int i = 0; i < mapsCount; ++i) {
            mapViewsFuture.add(MapUtils.createMap(world));
            markers.add(new ConcurrentHashMap());
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapsCount);
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapsCount);
        for (Future future : mapViewsFuture) {
            MapView mapView = (MapView)future.get();
            Scheduler.runTask((Plugin)ImageFrame.plugin, () -> {
                for (MapRenderer renderer : mapView.getRenderers()) {
                    mapView.removeRenderer(renderer);
                }
            });
            mapViews.add(mapView);
            mapIds.add(mapView.getId());
        }
        URLAnimatedImageMap map = new URLAnimatedImageMap(manager, -1, name, url, new FileLazyMappedBufferedImage[mapsCount][], mapViews, mapIds, markers, width, height, ditheringType, creator, Collections.emptyMap(), System.currentTimeMillis(), -1, 0);
        return FutureUtils.callAsyncMethod(() -> {
            FutureUtils.callSyncMethod(() -> {
                for (int i = 0; i < mapViews.size(); ++i) {
                    ((MapView)mapViews.get(i)).addRenderer((MapRenderer)new URLAnimatedImageMapRenderer(map, i));
                }
            }).get();
            map.update(false);
            return map;
        });
    }

    public static Future<? extends URLAnimatedImageMap> load(ImageMapManager manager, File folder, JsonObject json) throws Exception {
        Map<UUID, ImageMapAccessPermissionType> hasAccess;
        if (!json.get("type").getAsString().equals(URLAnimatedImageMap.class.getName())) {
            throw new IllegalArgumentException("invalid type");
        }
        int imageIndex = json.get("index").getAsInt();
        String name = json.has("name") ? json.get("name").getAsString() : "Unnamed";
        String url = json.get("url").getAsString();
        int width = json.get("width").getAsInt();
        int height = json.get("height").getAsInt();
        DitheringType ditheringType = DitheringType.fromName(json.has("ditheringType") ? json.get("ditheringType").getAsString() : null);
        long creationTime = json.get("creationTime").getAsLong();
        UUID creator = UUID.fromString(json.get("creator").getAsString());
        if (json.has("hasAccess")) {
            JsonObject accessJson = json.get("hasAccess").getAsJsonObject();
            hasAccess = new HashMap(accessJson.size());
            for (Map.Entry<String, JsonElement> entry : accessJson.entrySet()) {
                hasAccess.put(UUID.fromString(entry.getKey()), ImageMapAccessPermissionType.valueOf(entry.getValue().getAsString().toUpperCase()));
            }
        } else {
            hasAccess = Collections.emptyMap();
        }
        JsonArray mapDataJson = json.get("mapdata").getAsJsonArray();
        ArrayList<Future<MapView>> mapViewsFuture = new ArrayList<Future<MapView>>(mapDataJson.size());
        ArrayList<Integer> mapIds = new ArrayList<Integer>(mapDataJson.size());
        FileLazyMappedBufferedImage[][] cachedImages = new FileLazyMappedBufferedImage[mapDataJson.size()][];
        ArrayList<Map<String, MapCursor>> markers = new ArrayList<Map<String, MapCursor>>(mapDataJson.size());
        World world = (World)Bukkit.getWorlds().get(0);
        int i = 0;
        for (Object dataJson : mapDataJson) {
            JsonObject jsonObject = ((JsonElement)dataJson).getAsJsonObject();
            int mapId = jsonObject.get("mapid").getAsInt();
            mapIds.add(mapId);
            mapViewsFuture.add(MapUtils.getMapOrCreateMissing(world, mapId));
            JsonArray framesArray = jsonObject.get("images").getAsJsonArray();
            FileLazyMappedBufferedImage[] images = new FileLazyMappedBufferedImage[framesArray.size()];
            int u = 0;
            for (JsonElement element : framesArray) {
                images[u++] = FileLazyMappedBufferedImage.fromFile(new File(folder, element.getAsString()));
            }
            ConcurrentHashMap<String, MapCursor> mapCursors = new ConcurrentHashMap<String, MapCursor>();
            if (jsonObject.has("markers")) {
                JsonArray markerArray = jsonObject.get("markers").getAsJsonArray();
                for (JsonElement element : markerArray) {
                    JsonObject markerData = element.getAsJsonObject();
                    String markerName = markerData.get("name").getAsString();
                    byte x = markerData.get("x").getAsByte();
                    byte y = markerData.get("y").getAsByte();
                    MapCursor.Type type = MapCursor.Type.valueOf((String)markerData.get("type").getAsString().toUpperCase());
                    byte direction = markerData.get("direction").getAsByte();
                    boolean visible = markerData.get("visible").getAsBoolean();
                    JsonElement caption = markerData.get("caption");
                    mapCursors.put(markerName, new MapCursor(x, y, direction, type, visible, caption.isJsonNull() ? null : caption.getAsString()));
                }
            }
            markers.add(mapCursors);
            cachedImages[i++] = images;
        }
        ArrayList<MapView> mapViews = new ArrayList<MapView>(mapViewsFuture.size());
        for (Future future : mapViewsFuture) {
            mapViews.add((MapView)future.get());
        }
        int pausedAt = json.has("pausedAt") ? json.get("pausedAt").getAsInt() : -1;
        int n = json.has("tickOffset") ? json.get("tickOffset").getAsInt() : 0;
        URLAnimatedImageMap map = new URLAnimatedImageMap(manager, imageIndex, name, url, cachedImages, mapViews, mapIds, markers, width, height, ditheringType, creator, hasAccess, creationTime, pausedAt, n);
        return FutureUtils.callSyncMethod(() -> {
            for (int u = 0; u < mapViews.size(); ++u) {
                MapView mapView = (MapView)mapViews.get(u);
                for (MapRenderer renderer : mapView.getRenderers()) {
                    mapView.removeRenderer(renderer);
                }
                mapView.addRenderer((MapRenderer)new URLAnimatedImageMapRenderer(map, u));
            }
            return map;
        });
    }

    protected URLAnimatedImageMap(ImageMapManager manager, int imageIndex, String name, String url, FileLazyMappedBufferedImage[][] cachedImages, List<MapView> mapViews, List<Integer> mapIds, List<Map<String, MapCursor>> mapMarkers, int width, int height, DitheringType ditheringType, UUID creator, Map<UUID, ImageMapAccessPermissionType> hasAccess, long creationTime, int pausedAt, int tickOffset) {
        super(manager, imageIndex, name, url, mapViews, mapIds, mapMarkers, width, height, ditheringType, creator, hasAccess, creationTime);
        this.cachedImages = cachedImages;
        this.pausedAt = pausedAt;
        this.tickOffset = tickOffset;
        this.cacheControlTask.loadCacheIfManual();
    }

    @Override
    public void loadColorCache() {
        if (this.cachedImages == null) {
            return;
        }
        if (this.cachedImages[0] == null) {
            return;
        }
        byte[][][] cachedColors = new byte[this.cachedImages.length][][];
        int[][] fakeMapIds = new int[cachedColors.length][];
        HashSet<Integer> fakeMapIdsSet = new HashSet<Integer>();
        BufferedImage[] combined = new BufferedImage[this.cachedImages[0].length];
        for (int i3 = 0; i3 < combined.length; ++i3) {
            combined[i3] = new BufferedImage(this.width * 128, this.height * 128, 2);
        }
        Graphics2D[] g = (Graphics2D[])Arrays.stream(combined).map(i -> i.createGraphics()).toArray(Graphics2D[]::new);
        int index = 0;
        for (FileLazyMappedBufferedImage[] fileLazyMappedBufferedImageArray : this.cachedImages) {
            int f = 0;
            for (FileLazyMappedBufferedImage image : fileLazyMappedBufferedImageArray) {
                g[f++].drawImage((Image)image.get(), index % this.width * 128, index / this.width * 128, null);
            }
            ++index;
        }
        for (FileLazyMappedBufferedImage[] fileLazyMappedBufferedImageArray : g) {
            fileLazyMappedBufferedImageArray.dispose();
        }
        byte[][] combinedData = new byte[combined.length][];
        for (int i2 = 0; i2 < combined.length; ++i2) {
            combinedData[i2] = MapUtils.toMapPaletteBytes(combined[i2], this.ditheringType);
        }
        int i2 = 0;
        for (FileLazyMappedBufferedImage[] images : this.cachedImages) {
            byte[][] data = new byte[images.length][];
            int[] mapIds = new int[data.length];
            Arrays.fill(mapIds, -1);
            byte[] lastDistinctFrame = null;
            for (int u = 0; u < images.length; ++u) {
                int mapId;
                byte[] b = new byte[16384];
                for (int y = 0; y < 128; ++y) {
                    int offset = (i2 / this.width * 128 + y) * (this.width * 128) + i2 % this.width * 128;
                    System.arraycopy(combinedData[u], offset, b, y * 128, 128);
                }
                if (u != 0 && Arrays.equals(b, lastDistinctFrame)) continue;
                data[u] = b;
                mapIds[u] = mapId = ImageMapManager.getNextFakeMapId();
                fakeMapIdsSet.add(mapId);
                lastDistinctFrame = b;
            }
            cachedColors[i2] = data;
            fakeMapIds[i2] = mapIds;
            ++i2;
        }
        this.cachedColors = cachedColors;
        this.fakeMapIds = fakeMapIds;
        this.fakeMapIdsSet = fakeMapIdsSet;
    }

    @Override
    public boolean hasColorCached() {
        return this.cachedColors != null;
    }

    @Override
    public void unloadColorCache() {
        this.cachedColors = null;
    }

    @Override
    public void update(boolean save) throws Exception {
        int index;
        List<GifReader.ImageFrame> frames;
        try {
            frames = GifReader.readGif(HTTPRequestUtils.getInputStream(this.url), ImageFrame.maxImageFileSize).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read or download animated gif, does this url directly links to the gif? (" + this.url + ")", e);
        }
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        int currentTime = 0;
        while ((index = GifReader.getFrameAt(frames, currentTime)) >= 0) {
            images.add(frames.get(index).getImage());
            currentTime += 50;
        }
        for (int i = 0; i < this.cachedImages.length; ++i) {
            this.cachedImages[i] = new FileLazyMappedBufferedImage[images.size()];
        }
        int index2 = 0;
        HashMap<IntPosition, FileLazyMappedBufferedImage> previousImages = new HashMap<IntPosition, FileLazyMappedBufferedImage>();
        for (BufferedImage image : images) {
            image = MapUtils.resize(image, this.width, this.height);
            int i = 0;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    IntPosition intPosition = new IntPosition(x, y);
                    BufferedImage subImage = MapUtils.getSubImage(image, x, y);
                    FileLazyMappedBufferedImage previousFile = (FileLazyMappedBufferedImage)previousImages.get(intPosition);
                    FileLazyMappedBufferedImage file = previousFile == null || !MapUtils.areImagesEqual(subImage, previousFile.getIfLoaded()) ? FileLazyMappedBufferedImage.fromImage(subImage) : previousFile;
                    this.cachedImages[i++][index2] = file;
                    previousImages.put(intPosition, file);
                }
            }
            ++index2;
        }
        this.reloadColorCache();
        Bukkit.getPluginManager().callEvent((Event)new ImageMapUpdatedEvent(this));
        if (save) {
            this.save();
        }
    }

    @Override
    public boolean requiresAnimationService() {
        return true;
    }

    @Override
    public int getCurrentPositionInSequenceWithOffset() {
        if (this.isAnimationPaused()) {
            return this.pausedAt;
        }
        int sequenceLength = this.getSequenceLength();
        int currentPosition = this.manager.getCurrentAnimationTick() % sequenceLength - this.tickOffset;
        if (currentPosition < 0) {
            currentPosition = sequenceLength + currentPosition;
        }
        return currentPosition;
    }

    @Override
    public boolean isAnimationPaused() {
        return this.pausedAt >= 0;
    }

    @Override
    public synchronized void setAnimationPause(boolean pause) throws Exception {
        if (this.pausedAt < 0 && pause) {
            this.pausedAt = this.getCurrentPositionInSequenceWithOffset();
            this.save();
        } else if (this.pausedAt >= 0 && !pause) {
            this.setCurrentPositionInSequence(this.pausedAt);
            this.pausedAt = -1;
            this.save();
        }
    }

    @Override
    public void setCurrentPositionInSequence(int position) {
        int sequenceLength = this.getSequenceLength();
        this.tickOffset = this.manager.getCurrentAnimationTick() % sequenceLength - position % sequenceLength;
    }

    @Override
    public synchronized void setAnimationPlaybackTime(double seconds) throws Exception {
        int totalTicks = this.getSequenceLength();
        int ticks = seconds < 0.0 ? totalTicks + (int)Math.ceil((seconds + 1.0) * 20.0) : (int)Math.floor(seconds * 20.0);
        ticks = Math.min(Math.max(0, ticks), totalTicks - 1);
        if (this.isAnimationPaused()) {
            this.pausedAt = ticks;
            this.save();
        } else {
            this.setCurrentPositionInSequence(ticks);
            this.save();
        }
    }

    @Override
    public byte[] getRawAnimationColors(int currentTick, int index) {
        if (this.cachedColors == null) {
            return null;
        }
        byte[][] colors = this.cachedColors[index];
        if (colors == null) {
            return null;
        }
        return colors[currentTick % colors.length];
    }

    @Override
    public int getAnimationFakeMapId(int currentTick, int index, boolean lookbehind) {
        if (this.fakeMapIds == null) {
            return -1;
        }
        int[] mapIds = this.fakeMapIds[index];
        if (mapIds == null) {
            return -1;
        }
        int mapIdIndex = currentTick % mapIds.length;
        int mapId = mapIds[mapIdIndex];
        if (mapId >= 0 || !lookbehind) {
            return mapId;
        }
        while (mapIdIndex >= 0) {
            mapId = mapIds[mapIdIndex];
            if (mapId >= 0) {
                return mapId;
            }
            --mapIdIndex;
        }
        return mapId;
    }

    @Override
    public void sendAnimationFakeMaps(Collection<? extends Player> players, MapPacketSentCallback completionCallback) {
        int length = this.getSequenceLength();
        for (int currentTick = 0; currentTick < length; ++currentTick) {
            for (int index = 0; index < this.fakeMapIds.length; ++index) {
                int mapId;
                int[] mapIds = this.fakeMapIds[index];
                if (mapIds == null || currentTick >= mapIds.length || (mapId = mapIds[currentTick]) < 0) continue;
                MapUtils.sendImageMap(mapId, (MapView)this.mapViews.get(index), currentTick, players, completionCallback);
            }
        }
    }

    @Override
    public Set<Integer> getFakeMapIds() {
        return this.fakeMapIdsSet;
    }

    @Override
    public int getSequenceLength() {
        return this.cachedImages[0].length;
    }

    @Override
    public ImageMap deepClone(String name, UUID creator) throws Exception {
        URLAnimatedImageMap imageMap = URLAnimatedImageMap.create(this.manager, name, this.url, this.width, this.height, this.ditheringType, creator).get();
        List<Map<String, MapCursor>> newList = imageMap.getMapMarkers();
        int i = 0;
        for (Map<String, MapCursor> map : this.getMapMarkers()) {
            Map<String, MapCursor> newMap = newList.get(i++);
            for (Map.Entry<String, MapCursor> entry : map.entrySet()) {
                MapCursor mapCursor = entry.getValue();
                newMap.put(entry.getKey(), new MapCursor(mapCursor.getX(), mapCursor.getY(), mapCursor.getDirection(), mapCursor.getType(), mapCursor.isVisible(), mapCursor.getCaption()));
            }
        }
        return imageMap;
    }

    @Override
    public void save() throws Exception {
        if (this.imageIndex < 0) {
            throw new IllegalStateException("ImageMap with index < 0 cannot be saved");
        }
        File folder = new File(this.manager.getDataFolder(), String.valueOf(this.imageIndex));
        folder.mkdirs();
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getClass().getName());
        json.addProperty("index", this.imageIndex);
        json.addProperty("name", this.name);
        json.addProperty("url", this.url);
        json.addProperty("width", this.width);
        json.addProperty("height", this.height);
        if (this.ditheringType != null) {
            json.addProperty("ditheringType", this.ditheringType.getName());
        }
        json.addProperty("creator", this.creator.toString());
        json.addProperty("pausedAt", this.pausedAt);
        json.addProperty("tickOffset", this.tickOffset);
        JsonObject accessJson = new JsonObject();
        for (Map.Entry<UUID, ImageMapAccessPermissionType> entry : this.accessControl.getPermissions().entrySet()) {
            accessJson.addProperty(entry.getKey().toString(), entry.getValue().name());
        }
        json.add("hasAccess", accessJson);
        json.addProperty("creationTime", this.creationTime);
        JsonArray mapDataJson = new JsonArray();
        int u = 0;
        for (int i = 0; i < this.mapViews.size(); ++i) {
            JsonObject dataJson = new JsonObject();
            dataJson.addProperty("mapid", (Number)this.mapIds.get(i));
            JsonArray framesArray = new JsonArray();
            for (FileLazyMappedBufferedImage image : this.cachedImages[i]) {
                int index;
                File file;
                if (image.canSetFile(file = new File(folder, (index = u++) + ".png"))) {
                    image.setFile(file);
                    framesArray.add(index + ".png");
                    continue;
                }
                framesArray.add(image.getFile().getName());
            }
            dataJson.add("images", framesArray);
            JsonArray markerArray = new JsonArray();
            for (Map.Entry entry : ((Map)this.mapMarkers.get(i)).entrySet()) {
                MapCursor marker = (MapCursor)entry.getValue();
                JsonObject markerData = new JsonObject();
                markerData.addProperty("name", (String)entry.getKey());
                markerData.addProperty("x", marker.getX());
                markerData.addProperty("y", marker.getY());
                markerData.addProperty("type", marker.getType().name());
                markerData.addProperty("direction", marker.getDirection());
                markerData.addProperty("visible", marker.isVisible());
                markerData.addProperty("caption", marker.getCaption());
                markerArray.add(markerData);
            }
            dataJson.add("markers", markerArray);
            mapDataJson.add(dataJson);
        }
        json.add("mapdata", mapDataJson);
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(Files.newOutputStream(new File(folder, "data.json").toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            pw.println(GSON.toJson(json));
            pw.flush();
        }
    }

    public static class URLAnimatedImageMapRenderer
    extends ImageMap.ImageMapRenderer {
        private final URLAnimatedImageMap parent;

        public URLAnimatedImageMapRenderer(URLAnimatedImageMap parent, int index) {
            super(parent.getManager(), parent, index);
            this.parent = parent;
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, int currentTick, Player player) {
            byte[] colors = this.parent.getRawAnimationColors(currentTick, this.index);
            Collection<MapCursor> cursors = this.parent.getMapMarkers().get(this.index).values();
            return new MutablePair<byte[], Collection<MapCursor>>(colors, cursors);
        }

        @Override
        public MutablePair<byte[], Collection<MapCursor>> renderMap(MapView mapView, Player player) {
            return this.renderMap(mapView, this.parent.getCurrentPositionInSequenceWithOffset(), player);
        }
    }
}

