/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapRenderEventListener;
import com.loohp.imageframe.objectholders.MutablePair;
import com.loohp.imageframe.utils.FileUtils;
import com.loohp.imageframe.utils.MapUtils;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class ImageMapManager
implements AutoCloseable {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    public static final int FAKE_MAP_ID_START_RANGE = 0x5FFFFFFD;
    private static final AtomicInteger FAKE_MAP_ID_COUNTER = new AtomicInteger(0x5FFFFFFD);
    private final Map<Integer, ImageMap> maps = new ConcurrentHashMap<Integer, ImageMap>();
    private final Map<MapView, ImageMap> mapsByView = new ConcurrentHashMap<MapView, ImageMap>();
    private final AtomicInteger mapIndexCounter = new AtomicInteger(0);
    private final File dataFolder;
    private final AtomicInteger tickCounter;
    private final List<ImageMapRenderEventListener> renderEventListeners;
    private final Set<Integer> deletedMapIds;
    private final ScheduledTask tickCounterTask;

    public static int getNextFakeMapId() {
        return FAKE_MAP_ID_COUNTER.getAndUpdate(i -> i < 0x5FFFFFFD ? 0x5FFFFFFD : i + 1);
    }

    public ImageMapManager(File dataFolder) {
        this.dataFolder = dataFolder;
        this.tickCounter = new AtomicInteger(0);
        this.renderEventListeners = new CopyOnWriteArrayList<ImageMapRenderEventListener>();
        this.deletedMapIds = ConcurrentHashMap.newKeySet();
        this.tickCounterTask = Scheduler.runTaskTimerAsynchronously((Plugin)ImageFrame.plugin, () -> this.tickCounter.incrementAndGet(), 0L, 1L);
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    protected int getCurrentAnimationTick() {
        return this.tickCounter.get();
    }

    @Override
    public void close() {
        this.saveDeletedMaps();
        this.tickCounterTask.cancel();
    }

    public void appendRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.add(listener);
    }

    public void prependRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.add(0, listener);
    }

    public void removeRenderEventListener(ImageMapRenderEventListener listener) {
        this.renderEventListeners.remove(listener);
    }

    protected void callRenderEventListener(ImageMapManager manager, ImageMap imageMap, MapView map, Player player, MutablePair<byte[], Collection<MapCursor>> renderData) {
        this.renderEventListeners.forEach(each -> each.accept(manager, imageMap, map, player, renderData));
    }

    public synchronized void addMap(ImageMap map) throws Exception {
        if (map.getManager() != this) {
            throw new IllegalArgumentException("ImageMap's manager is not set to this");
        }
        if (this.getFromCreator(map.getCreator(), map.getName()) != null) {
            throw new IllegalArgumentException("Duplicated map name for this creator");
        }
        int originalImageIndex = map.getImageIndex();
        if (originalImageIndex < 0) {
            map.imageIndex = this.mapIndexCounter.getAndIncrement();
        } else {
            this.mapIndexCounter.updateAndGet(i -> Math.max(originalImageIndex + 1, i));
        }
        this.maps.put(map.getImageIndex(), map);
        for (MapView mapView : map.getMapViews()) {
            this.mapsByView.put(mapView, map);
            this.deletedMapIds.remove(mapView.getId());
        }
        try {
            map.save();
        }
        catch (Throwable e) {
            this.maps.remove(originalImageIndex);
            for (MapView mapView : map.getMapViews()) {
                this.mapsByView.remove(mapView);
            }
            throw e;
        }
        this.saveDeletedMaps();
    }

    public boolean hasMap(int imageIndex) {
        return this.maps.containsKey(imageIndex);
    }

    public Collection<ImageMap> getMaps() {
        return Collections.unmodifiableCollection(this.maps.values());
    }

    public ImageMap getFromMapId(int id) {
        MapView mapView = Bukkit.getMap((int)id);
        if (mapView == null) {
            return null;
        }
        return this.getFromMapView(Bukkit.getMap((int)id));
    }

    public ImageMap getFromImageId(int imageId) {
        return this.maps.get(imageId);
    }

    public ImageMap getFromMapView(MapView mapView) {
        return this.mapsByView.get(mapView);
    }

    public Set<ImageMap> getFromCreator(UUID uuid) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid)).collect(Collectors.toSet());
    }

    public List<ImageMap> getFromCreator(UUID uuid, Comparator<ImageMap> order) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid)).sorted(order).collect(Collectors.toList());
    }

    public ImageMap getFromCreator(UUID uuid, String name) {
        return this.maps.values().stream().filter(each -> each.getCreator().equals(uuid) && each.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public Set<UUID> getCreators() {
        return this.maps.values().stream().map(each -> each.getCreator()).collect(Collectors.toSet());
    }

    public boolean deleteMap(int imageIndex) {
        ImageMap imageMap = this.maps.remove(imageIndex);
        if (imageMap == null) {
            return false;
        }
        List<MapView> mapViews = imageMap.getMapViews();
        for (MapView mapView : mapViews) {
            this.mapsByView.remove(mapView);
        }
        if (imageMap.trackDeletedMaps()) {
            mapViews.forEach(each -> this.deletedMapIds.add(each.getId()));
        }
        imageMap.markInvalid();
        this.dataFolder.mkdirs();
        File folder = new File(this.dataFolder, String.valueOf(imageIndex));
        if (folder.exists() && folder.isDirectory()) {
            FileUtils.removeFolderRecursively(folder);
        }
        imageMap.stop();
        this.saveDeletedMaps();
        Scheduler.runTask((Plugin)ImageFrame.plugin, () -> mapViews.forEach(each -> {
            if (each.getRenderers().isEmpty()) {
                each.addRenderer((MapRenderer)DeletedMapRenderer.INSTANCE);
            }
        }));
        return true;
    }

    public boolean isMapDeleted(int mapId) {
        return this.deletedMapIds.contains(mapId);
    }

    public boolean isMapDeleted(MapView mapView) {
        return this.isMapDeleted(mapView.getId());
    }

    public synchronized void loadMaps() {
        this.maps.clear();
        this.mapsByView.clear();
        this.dataFolder.mkdirs();
        File[] files = this.dataFolder.listFiles();
        Arrays.sort(files, FileUtils.BY_NUMBER_THAN_STRING);
        LinkedList<MutablePair<File, Future<? extends ImageMap>>> futures = new LinkedList<MutablePair<File, Future<? extends ImageMap>>>();
        for (File file : files) {
            if (file.isDirectory()) {
                try {
                    futures.add(new MutablePair<File, Future<? extends ImageMap>>(file, ImageMap.load(this, file)));
                }
                catch (Throwable e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMap data in " + file.getAbsolutePath());
                    e.printStackTrace();
                }
                continue;
            }
            if (file.getName().equalsIgnoreCase("deletedMaps.bin")) {
                try (DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                    try {
                        this.deletedMapIds.add(dataInputStream.readInt());
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                }
                catch (IOException e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMapManager data in " + file.getAbsolutePath());
                    e.printStackTrace();
                }
                continue;
            }
            if (!file.getName().equalsIgnoreCase("deletedMaps.json")) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                JsonObject json = GSON.fromJson((Reader)reader, JsonObject.class);
                JsonArray deletedMapIdsArray = json.get("mapids").getAsJsonArray();
                for (JsonElement element : deletedMapIdsArray) {
                    this.deletedMapIds.add(element.getAsInt());
                }
            }
            catch (IOException e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMapManager data in " + file.getAbsolutePath());
                e.printStackTrace();
            }
            this.saveDeletedMaps();
            try {
                Files.move(file.toPath(), new File(this.dataFolder, "deletedMaps.json.bak").toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Scheduler.runTaskAsynchronously((Plugin)ImageFrame.plugin, () -> {
            int count = 0;
            for (MutablePair pair : futures) {
                try {
                    this.addMap((ImageMap)((Future)pair.getSecond()).get());
                    ++count;
                }
                catch (Throwable e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to load ImageMap data in " + ((File)pair.getFirst()).getAbsolutePath());
                    e.printStackTrace();
                }
            }
            Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[ImageFrame] Data loading completed! Loaded " + count + " ImageMaps!");
        });
    }

    public synchronized void saveDeletedMaps() {
        File file = new File(this.dataFolder, "deletedMaps.bin");
        try (DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            for (int deletedMapId : this.deletedMapIds) {
                dataOutputStream.writeInt(deletedMapId);
            }
            dataOutputStream.flush();
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ImageFrame] Unable to save ImageMapManager data in " + file.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void sendAllMaps(Collection<? extends Player> players) {
        this.maps.values().forEach(m -> m.send(players));
    }

    public static class DeletedMapRenderer
    extends MapRenderer {
        public static final DeletedMapRenderer INSTANCE = new DeletedMapRenderer();

        private DeletedMapRenderer() {
        }

        public void render(MapView map, MapCanvas canvas, Player player) {
            List mapRenderers = map.getRenderers();
            if (mapRenderers.size() != 1 || mapRenderers.get(0) != this) {
                Scheduler.runTaskLater((Plugin)ImageFrame.plugin, () -> map.removeRenderer((MapRenderer)this), 1L);
                return;
            }
            Random random = new Random(map.getId());
            byte[] colors = MapUtils.PALETTE_GRAYSCALE;
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    canvas.setPixel(x, y, colors[random.nextInt(colors.length)]);
                }
            }
        }
    }
}

