/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.imageframe.objectholders;

import com.loohp.imageframe.ImageFrame;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.ScheduledTask;
import com.loohp.imageframe.libs.com.loohp.platformscheduler.Scheduler;
import com.loohp.imageframe.objectholders.ImageMap;
import com.loohp.imageframe.objectholders.ImageMapCacheControlTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.plugin.Plugin;

public class ImageMapDynamicCacheControlTask
implements ImageMapCacheControlTask,
Runnable {
    private final ImageMap imageMap;
    private final AtomicBoolean locked;
    private final AtomicBoolean closed;
    private final AtomicReference<ScheduledTask> task;
    private final AtomicInteger noViewerCounts;

    public ImageMapDynamicCacheControlTask(ImageMap imageMap) {
        this.imageMap = imageMap;
        this.noViewerCounts = new AtomicInteger(0);
        this.locked = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
        this.task = new AtomicReference<ScheduledTask>(Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, this, 5L));
    }

    @Override
    public ImageMap getImageMap() {
        return this.imageMap;
    }

    @Override
    public void loadCacheIfManual() {
    }

    public boolean isLocked() {
        return this.locked.get();
    }

    public void setLocked(boolean locked) {
        this.locked.set(locked);
    }

    @Override
    public void run() {
        if (this.closed.get()) {
            return;
        }
        if (!this.locked.get()) {
            if (this.imageMap.hasViewers()) {
                this.noViewerCounts.set(0);
                if (!this.imageMap.hasColorCached()) {
                    this.imageMap.loadColorCache();
                }
            } else if (this.noViewerCounts.getAndIncrement() > 200 && this.imageMap.hasColorCached()) {
                this.imageMap.unloadColorCache();
            }
        }
        this.task.set(Scheduler.runTaskLaterAsynchronously((Plugin)ImageFrame.plugin, this, 5L));
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.task.updateAndGet(t -> {
            if (t != null) {
                t.cancel();
            }
            return t;
        });
    }
}

