/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import net.skullian.util.GithubBuildInfo;
import org.jetbrains.annotations.NotNull;

public class GithubUtils {
    public static final String MAIN_BRANCH = "main";
    private static final String API_BASE = "https://api.github.com/repos/";
    private static final String API_LATEST_RELEASE = "https://api.github.com/repos/TerraByteDev/HoloMobHealth-PacketEvents/releases/latest";
    private static final String API_COMPARE = "https://api.github.com/repos/TerraByteDev/HoloMobHealth-PacketEvents/compare/%s...%s";

    private GithubUtils() {
    }

    public static GithubBuildInfo lookupLatestRelease() throws IOException {
        URL url = new URL(API_LATEST_RELEASE);
        HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
        int responseCode = https.getResponseCode();
        if (GithubUtils.isSuccessfulResponse(responseCode)) {
            try (InputStream in = https.getInputStream();){
                GithubBuildInfo githubBuildInfo;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    githubBuildInfo = GithubUtils.parseBuildInfo(reader);
                }
                return githubBuildInfo;
            }
        }
        throw new IOException("Bad response status: " + responseCode);
    }

    private static GithubBuildInfo parseBuildInfo(BufferedReader reader) {
        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        String id = json.get("tag_name").getAsString();
        return new GithubBuildInfo(id, id, MAIN_BRANCH, true);
    }

    public static GitHubStatusLookup compare(@NotNull String base, @NotNull String head) throws IOException {
        URL url = new URL(String.format(API_COMPARE, base, head));
        HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
        int responseCode = https.getResponseCode();
        if (GithubUtils.isSuccessfulResponse(responseCode)) {
            try (InputStream in = https.getInputStream();){
                GitHubStatusLookup gitHubStatusLookup;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    gitHubStatusLookup = GithubUtils.parseComparison(reader);
                }
                return gitHubStatusLookup;
            }
        }
        if (responseCode == 404) {
            return new GitHubStatusLookup(GitHubStatus.UNKNOWN, 0);
        }
        return new GitHubStatusLookup(GitHubStatus.FAILURE, 0);
    }

    private static GitHubStatusLookup parseComparison(@NotNull BufferedReader reader) {
        JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
        GitHubStatus status = GitHubStatus.fromString(json.get("status").getAsString());
        int aheadBy = json.get("ahead_by").getAsInt();
        int behindBy = json.get("behind_by").getAsInt();
        return new GitHubStatusLookup(status, status == GitHubStatus.AHEAD ? aheadBy : behindBy);
    }

    private static boolean isSuccessfulResponse(int code) {
        return code >= 200 && code <= 299;
    }

    public static class GitHubStatusLookup {
        private final GitHubStatus status;
        private final int distance;

        private GitHubStatusLookup(@NotNull GitHubStatus status, int distance) {
            this.status = Objects.requireNonNull(status);
            this.distance = distance;
        }

        public boolean isAhead() {
            return this.status == GitHubStatus.AHEAD;
        }

        public boolean isIdentical() {
            return this.status == GitHubStatus.IDENTICAL;
        }

        public boolean isBehind() {
            return this.status == GitHubStatus.BEHIND;
        }

        public String toString() {
            return "GitHubStatusLookup{status=" + String.valueOf((Object)this.status) + ", distance=" + this.distance + "}";
        }

        @Generated
        public GitHubStatus getStatus() {
            return this.status;
        }

        @Generated
        public int getDistance() {
            return this.distance;
        }
    }

    public static enum GitHubStatus {
        DIVERGED,
        AHEAD,
        BEHIND,
        IDENTICAL,
        UNKNOWN,
        FAILURE;


        public static GitHubStatus fromString(@NotNull String str) {
            return GitHubStatus.valueOf(str.toUpperCase(Locale.ROOT));
        }
    }
}

