/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import net.skullian.HoloMobHealthPacketEvents;

public record GithubBuildInfo(String id, String name, String branch, boolean stable) {
    public static final GithubBuildInfo CURRENT = GithubBuildInfo.readBuildInfo();

    public GithubBuildInfo(String id, String name, String branch, boolean stable) {
        this.id = Objects.requireNonNull(id);
        this.name = Objects.requireNonNull(name);
        this.branch = Objects.requireNonNull(branch);
        this.stable = stable;
    }

    @Override
    public String toString() {
        return "GithubBuildInfo{id='" + this.id + "', name='" + this.name + "', branch='" + this.branch + ", stable=" + this.stable + "}";
    }

    private static GithubBuildInfo readBuildInfo() {
        GithubBuildInfo githubBuildInfo;
        block9: {
            InputStream in = HoloMobHealthPacketEvents.instance.getResource("version.properties");
            try {
                if (in == null) {
                    throw new IOException("No input");
                }
                Properties properties = new Properties();
                properties.load(in);
                githubBuildInfo = GithubBuildInfo.parseBuildInfo(properties);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError("Missing version information!", e);
                }
            }
            in.close();
        }
        return githubBuildInfo;
    }

    private static GithubBuildInfo parseBuildInfo(Properties properties) {
        String id = properties.getProperty("git.commit.id.abbrev");
        String name = properties.getProperty("git.build.version");
        String branch = properties.getProperty("git.branch");
        boolean stable = name.indexOf(45) == -1 && name.indexOf(43) == -1;
        return new GithubBuildInfo(id, name, branch, stable);
    }
}

