/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.updater;

import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import net.skullian.util.ChatUtils;
import net.skullian.util.GithubBuildInfo;
import net.skullian.util.GithubUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;

public class Updater
implements Listener {
    public static UpdateStatus checkUpdate(CommandSender ... senders) {
        GithubUtils.GitHubStatusLookup lookupStatus;
        GithubBuildInfo latestBuild;
        GithubBuildInfo currentBuild = GithubBuildInfo.CURRENT;
        UpdateStatus updateStatus = new UpdateStatus(false, false);
        try {
            if (currentBuild.stable()) {
                latestBuild = GithubUtils.lookupLatestRelease();
                lookupStatus = GithubUtils.compare(latestBuild.id(), currentBuild.id());
            } else {
                latestBuild = null;
                lookupStatus = GithubUtils.compare("main", currentBuild.id());
            }
        }
        catch (IOException error) {
            ChatUtils.sendMessage("<red>Failed to fetch latest version: " + String.valueOf(error), senders);
            updateStatus.setFailed(true);
            return updateStatus;
        }
        if (lookupStatus.isBehind()) {
            if (currentBuild.stable()) {
                String url = "https://github.com/TerraByteDev/HoloMobHealth-PacketEvents/releases/tag/" + latestBuild.id();
                ChatUtils.sendMessage("<green>A new version of HoloMobHealth-PacketEvents is available: " + latestBuild.id() + "!", senders);
                ChatUtils.sendMessage("<grey>Download at: <click:open_url:'" + url + "'>" + url + "</click>", senders);
            } else {
                ChatUtils.sendMessage("<yellow>You are running a development build of HoloMobHealth-PacketEvents!\nThe latest available development build is " + String.format(Locale.ROOT, "%,d", lookupStatus.getDistance()) + " commits ahead.", senders);
            }
        }
        updateStatus.setUpToDate(!lookupStatus.isBehind());
        return updateStatus;
    }

    public static final class UpdateStatus {
        private boolean isUpToDate;
        private boolean failed;

        @Generated
        public UpdateStatus(boolean isUpToDate, boolean failed) {
            this.isUpToDate = isUpToDate;
            this.failed = failed;
        }

        @Generated
        public boolean isUpToDate() {
            return this.isUpToDate;
        }

        @Generated
        public boolean isFailed() {
            return this.failed;
        }

        @Generated
        public void setUpToDate(boolean isUpToDate) {
            this.isUpToDate = isUpToDate;
        }

        @Generated
        public void setFailed(boolean failed) {
            this.failed = failed;
        }
    }
}

