/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.platform;

import com.github.retrooper.packetevents.protocol.entity.data.EntityData;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataType;
import com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import com.github.retrooper.packetevents.protocol.world.Location;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSpawnLivingEntity;
import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.holders.DataWatcherField;
import com.loohp.holomobhealth.holders.DataWatcherFieldType;
import com.loohp.holomobhealth.holders.DataWatcherFields;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.platform.PlatformPacketCreatorProvider;
import com.loohp.holomobhealth.platform.packets.PlatformPacket;
import com.loohp.holomobhealth.utils.MCVersion;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class PacketEventsPacketCreatorProvider
implements PlatformPacketCreatorProvider<PacketWrapper<?>> {
    private static void addOrReplaceDataWatcher(List<EntityData<?>> entityData, DataWatcherField field, Object value) {
        for (EntityData<?> data : entityData) {
            if (data.getIndex() != field.getIndex() || !data.getType().equals(PacketEventsPacketCreatorProvider.c(field.getType()))) continue;
            data.setValue(value);
            return;
        }
        entityData.add(new EntityData(field.getIndex(), PacketEventsPacketCreatorProvider.c(field.getType()), value));
    }

    private static EntityDataType<?> c(DataWatcherFieldType type) {
        switch (type) {
            case OPTIONAL_CHAT: {
                return EntityDataTypes.OPTIONAL_ADV_COMPONENT;
            }
            case STRING: {
                return EntityDataTypes.STRING;
            }
            case BOOLEAN: {
                return EntityDataTypes.BOOLEAN;
            }
            case BYTE: {
                return EntityDataTypes.BYTE;
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(type));
    }

    private static EntityData<?> c(DataWatcherField field, Object value) {
        if (field.getType().equals((Object)DataWatcherFieldType.OPTIONAL_CHAT)) {
            if (value instanceof String) {
                return new EntityData(field.getIndex(), EntityDataTypes.OPTIONAL_ADV_COMPONENT, ((String)value).isEmpty() ? Optional.empty() : Optional.of(LegacyComponentSerializer.legacySection().deserialize((String)value)));
            }
            return new EntityData(field.getIndex(), EntityDataTypes.OPTIONAL_ADV_COMPONENT, (Object)((Optional)value));
        }
        if (field.getType().equals((Object)DataWatcherFieldType.STRING)) {
            if (value instanceof String) {
                return new EntityData(field.getIndex(), EntityDataTypes.STRING, (Object)((String)value));
            }
            Optional chat = (Optional)value;
            return new EntityData(field.getIndex(), EntityDataTypes.STRING, (Object)chat.map(c -> LegacyComponentSerializer.legacySection().serialize(c)).orElse(""));
        }
        if (field.getType().equals((Object)DataWatcherFieldType.BOOLEAN)) {
            if (value instanceof Byte) {
                return new EntityData(field.getIndex(), EntityDataTypes.BOOLEAN, (Object)((Byte)value != 0 ? 1 : 0));
            }
            return new EntityData(field.getIndex(), EntityDataTypes.BOOLEAN, (Object)((Boolean)value));
        }
        if (field.getType().equals((Object)DataWatcherFieldType.BYTE)) {
            if (value instanceof Byte) {
                return new EntityData(field.getIndex(), EntityDataTypes.BYTE, (Object)((Byte)value));
            }
            return new EntityData(field.getIndex(), EntityDataTypes.BYTE, (Object)((Boolean)value != false ? (byte)1 : 0));
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(field.getType()));
    }

    private static EntityData<?> getByFieldIndex(List<EntityData<?>> entityData, int index) {
        return entityData.stream().filter(e -> e.getIndex() == index).findFirst().orElse(null);
    }

    private static List<PlatformPacket<PacketWrapper<?>>> c(PacketWrapper<?> ... packets) {
        return Arrays.stream(packets).map(PacketEventsGenericCreatorPacket::new).collect(Collectors.toList());
    }

    private static List<PlatformPacket<PacketWrapper<?>>> c(PacketWrapper<?> packet) {
        return Collections.singletonList(new PacketEventsGenericCreatorPacket(packet));
    }

    private static Location c(org.bukkit.Location location) {
        return new Location(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public List<PlatformPacket<PacketWrapper<?>>> createEntityDestroyPackets(int ... entityIds) {
        return PacketEventsPacketCreatorProvider.c(new WrapperPlayServerDestroyEntities(entityIds));
    }

    public List<PlatformPacket<PacketWrapper<?>>> createEntityTeleportPackets(int entityId, org.bukkit.Location location) {
        return PacketEventsPacketCreatorProvider.c(new WrapperPlayServerEntityTeleport(entityId, PacketEventsPacketCreatorProvider.c(location), false));
    }

    public List<PlatformPacket<PacketWrapper<?>>> createUpdateEntityPackets(Entity entity) {
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        List actualEntityData = SpigotReflectionUtil.getEntityMetadata((Entity)entity);
        ArrayList entityData = new ArrayList();
        DataWatcherField name = fields.getCustomNameField();
        entityData.add(PacketEventsPacketCreatorProvider.getByFieldIndex(actualEntityData, name.getIndex()));
        DataWatcherField visible = fields.getCustomNameVisibleField();
        entityData.add(PacketEventsPacketCreatorProvider.getByFieldIndex(actualEntityData, visible.getIndex()));
        return PacketEventsPacketCreatorProvider.c(new WrapperPlayServerEntityMetadata(entity.getEntityId(), entityData));
    }

    public List<PlatformPacket<PacketWrapper<?>>> createUpdateEntityMetadataPackets(Entity entity, Component entityNameComponent, boolean visible) {
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        ArrayList entityData = new ArrayList();
        DataWatcherField customNameField = fields.getCustomNameField();
        Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(BukkitComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
        entityData.add(PacketEventsPacketCreatorProvider.c(customNameField, name));
        DataWatcherField visibleField = fields.getCustomNameVisibleField();
        entityData.add(PacketEventsPacketCreatorProvider.c(visibleField, visible));
        return PacketEventsPacketCreatorProvider.c(new WrapperPlayServerEntityMetadata(entity.getEntityId(), entityData));
    }

    public List<PlatformPacket<PacketWrapper<?>>> createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        Object packet1 = HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_19) ? new WrapperPlayServerSpawnEntity(entity.getEntityId(), entity.getUniqueId(), EntityTypes.getByName((String)entity.getType().getName()), PacketEventsPacketCreatorProvider.c(entity.getLocation()), entity.getLocation().getYaw(), 0, null) : new WrapperPlayServerSpawnLivingEntity(entity.getEntityId(), entity.getUniqueId(), EntityTypes.getByName((String)entity.getType().getName()), PacketEventsPacketCreatorProvider.c(entity.getLocation()), entity.getLocation().getPitch(), Vector3d.zero(), Collections.emptyList());
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        ArrayList entityData = new ArrayList();
        DataWatcherField byteField = fields.getByteField();
        byte bitmask = 32;
        entityData.add(PacketEventsPacketCreatorProvider.c(byteField, bitmask));
        DataWatcherField customNameField = fields.getCustomNameField();
        Optional name = component == null ? Optional.empty() : Optional.of(BukkitComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(component))));
        entityData.add(PacketEventsPacketCreatorProvider.c(customNameField, name));
        DataWatcherField visibleField = fields.getCustomNameVisibleField();
        entityData.add(PacketEventsPacketCreatorProvider.c(visibleField, visible));
        DataWatcherField armorStandByteField = fields.getArmorStandByteField();
        byte standbitmask = 17;
        entityData.add(PacketEventsPacketCreatorProvider.c(armorStandByteField, standbitmask));
        WrapperPlayServerEntityMetadata packet2 = new WrapperPlayServerEntityMetadata(entity.getEntityId(), entityData);
        return PacketEventsPacketCreatorProvider.c(new PacketWrapper[]{packet1, packet2});
    }

    public List<PlatformPacket<PacketWrapper<?>>> createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        ArrayList entityData = new ArrayList();
        DataWatcherField byteField = fields.getByteField();
        byte bitmask = 32;
        entityData.add(PacketEventsPacketCreatorProvider.c(byteField, bitmask));
        DataWatcherField customNameField = fields.getCustomNameField();
        Optional name = component == null ? Optional.empty() : Optional.of(BukkitComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(component))));
        entityData.add(PacketEventsPacketCreatorProvider.c(customNameField, name));
        DataWatcherField visibleField = fields.getCustomNameVisibleField();
        entityData.add(PacketEventsPacketCreatorProvider.c(visibleField, visible));
        DataWatcherField armorStandByteField = fields.getArmorStandByteField();
        byte standbitmask = 17;
        entityData.add(PacketEventsPacketCreatorProvider.c(armorStandByteField, standbitmask));
        WrapperPlayServerEntityMetadata packet1 = new WrapperPlayServerEntityMetadata(entity.getEntityId(), entityData);
        WrapperPlayServerEntityTeleport packet2 = new WrapperPlayServerEntityTeleport(entity.getEntityId(), PacketEventsPacketCreatorProvider.c(entity.getLocation()), false);
        return PacketEventsPacketCreatorProvider.c(new PacketWrapper[]{packet1, packet2});
    }

    public List<PlatformPacket<PacketWrapper<?>>> createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return PacketEventsPacketCreatorProvider.c(new WrapperPlayServerEntityTeleport(entity.getEntityId(), PacketEventsPacketCreatorProvider.c(entity.getLocation()), false));
    }

    public List<PlatformPacket<PacketWrapper<?>>> createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, org.bukkit.Location location, Vector velocity, boolean gravity) {
        Object packet1 = HoloMobHealth.version.isNewerOrEqualTo(MCVersion.V1_19) ? new WrapperPlayServerSpawnEntity(entityId, uuid, EntityTypes.ARMOR_STAND, PacketEventsPacketCreatorProvider.c(location), location.getYaw(), 0, null) : new WrapperPlayServerSpawnLivingEntity(entityId, uuid, EntityTypes.ARMOR_STAND, PacketEventsPacketCreatorProvider.c(location), location.getPitch(), Vector3d.zero(), Collections.emptyList());
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        ArrayList entityData = new ArrayList();
        DataWatcherField byteField = fields.getByteField();
        byte bitmask = 32;
        entityData.add(PacketEventsPacketCreatorProvider.c(byteField, bitmask));
        DataWatcherField customNameField = fields.getCustomNameField();
        Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(BukkitComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
        entityData.add(PacketEventsPacketCreatorProvider.c(customNameField, name));
        DataWatcherField visibleField = fields.getCustomNameVisibleField();
        entityData.add(PacketEventsPacketCreatorProvider.c(visibleField, true));
        if (fields.hasSilentField()) {
            DataWatcherField silentField = fields.getSilentField();
            entityData.add(PacketEventsPacketCreatorProvider.c(silentField, true));
        }
        if (fields.hasNoGravityField()) {
            DataWatcherField noGravityField = fields.getNoGravityField();
            entityData.add(PacketEventsPacketCreatorProvider.c(noGravityField, !gravity));
        }
        DataWatcherField armorStandByteField = fields.getArmorStandByteField();
        byte standbitmask = 25;
        entityData.add(PacketEventsPacketCreatorProvider.c(armorStandByteField, standbitmask));
        WrapperPlayServerEntityMetadata packet2 = new WrapperPlayServerEntityMetadata(entityId, entityData);
        return PacketEventsPacketCreatorProvider.c(new PacketWrapper[]{packet1, packet2});
    }

    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        List<EntityData<?>> entityData = dataWatchers;
        DataWatcherFields fields = NMS.getInstance().getDataWatcherFields();
        DataWatcherField customNameField = fields.getCustomNameField();
        DataWatcherField visibleField = fields.getCustomNameVisibleField();
        Optional name = entityNameComponent == null ? Optional.empty() : Optional.of(BukkitComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
        PacketEventsPacketCreatorProvider.addOrReplaceDataWatcher(entityData, customNameField, name);
        PacketEventsPacketCreatorProvider.addOrReplaceDataWatcher(entityData, visibleField, visible);
    }

    private static class PacketEventsGenericCreatorPacket
    extends PlatformPacket<PacketWrapper<?>> {
        public PacketEventsGenericCreatorPacket(PacketWrapper<?> handle) {
            super(handle);
        }

        public PacketEventsGenericCreatorPacket shallowClone() {
            return new PacketEventsGenericCreatorPacket((PacketWrapper)this.handle);
        }
    }
}

