/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.utils.BoundingBox;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class RayTrace {
    private final Vector origin;
    private final Vector direction;

    public static Entity getLookingEntity(LivingEntity entity, double range) {
        RayTrace ray = new RayTrace(entity.getEyeLocation().toVector(), entity.getEyeLocation().getDirection());
        List entities = entity.getNearbyEntities(range, range, range);
        Entity closest = null;
        double distanceSquared = range * range + 1.0;
        for (Entity each : entities) {
            double dis;
            Vector intersect;
            if (each instanceof Player && ((Player)each).getGameMode().equals((Object)GameMode.SPECTATOR) || (intersect = ray.positionOfIntersection(NMS.getInstance().getBoundingBox(each), range, 0.1)) == null || !((dis = entity.getEyeLocation().distanceSquared(intersect.toLocation(each.getWorld()))) < distanceSquared)) continue;
            closest = each;
            distanceSquared = dis;
        }
        return closest;
    }

    public static boolean intersects(Vector position, Vector min, Vector max) {
        if (position.getX() < min.getX() || position.getX() > max.getX()) {
            return false;
        }
        if (position.getY() < min.getY() || position.getY() > max.getY()) {
            return false;
        }
        return !(position.getZ() < min.getZ()) && !(position.getZ() > max.getZ());
    }

    public RayTrace(Vector origin, Vector direction) {
        this.origin = origin;
        this.direction = direction;
    }

    public Vector getPostion(double blocksAway) {
        return this.origin.clone().add(this.direction.clone().multiply(blocksAway));
    }

    public boolean isOnLine(Vector position) {
        double t = (position.getX() - this.origin.getX()) / this.direction.getX();
        return (double)position.getBlockY() == this.origin.getY() + t * this.direction.getY() && (double)position.getBlockZ() == this.origin.getZ() + t * this.direction.getZ();
    }

    public List<Vector> traverse(double blocksAway, double accuracy) {
        ArrayList<Vector> positions = new ArrayList<Vector>();
        for (double d = 0.0; d <= blocksAway; d += accuracy) {
            positions.add(this.getPostion(d));
        }
        return positions;
    }

    public Vector positionOfIntersection(Vector min, Vector max, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return position;
        }
        return null;
    }

    public boolean intersects(Vector min, Vector max, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return true;
        }
        return false;
    }

    public Vector positionOfIntersection(BoundingBox boundingBox, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, boundingBox.getMin(), boundingBox.getMax())) continue;
            return position;
        }
        return null;
    }

    public boolean intersects(BoundingBox boundingBox, double blocksAway, double accuracy) {
        List<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, boundingBox.getMin(), boundingBox.getMax())) continue;
            return true;
        }
        return false;
    }

    public void highlight(World world, double blocksAway, double accuracy) {
        for (Vector position : this.traverse(blocksAway, accuracy)) {
            world.spawnParticle(Particle.REDSTONE, position.toLocation(world), 1, (Object)new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)0), 1.0f));
        }
    }
}

