/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TextReplacementConfig;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TranslationArgument;
import com.loohp.holomobhealth.libs.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import com.loohp.holomobhealth.libs.org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import com.loohp.holomobhealth.libs.org.apache.commons.lang3.text.WordUtils;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.utils.ComponentCompacting;
import com.loohp.holomobhealth.utils.ComponentFlattening;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.FileUtils;
import com.loohp.holomobhealth.utils.HTTPRequestUtils;
import com.loohp.holomobhealth.utils.HashUtils;
import com.loohp.holomobhealth.utils.JsonUtils;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.TropicalFishUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class LanguageUtils {
    public static final String VERSION_MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    public static final String RESOURCES_URL = "https://resources.download.minecraft.net/";
    private static final Map<String, Map<String, String>> translations = new HashMap<String, Map<String, String>>();
    private static final AtomicBoolean lock = new AtomicBoolean(false);

    public static void loadTranslations(String language) {
        Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[HoloMobHealth] Loading languages...");
        Bukkit.getScheduler().runTaskAsynchronously(HoloMobHealth.plugin, () -> {
            while (lock.get()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            lock.set(true);
            try {
                String key;
                File langFolder = new File(HoloMobHealth.plugin.getDataFolder(), "lang");
                langFolder.mkdirs();
                File langFileFolder = new File(langFolder, "languages");
                langFileFolder.mkdirs();
                File hashFile = new File(langFolder, "hashes.json");
                if (!hashFile.exists()) {
                    PrintWriter pw = new PrintWriter(hashFile, "UTF-8");
                    pw.print("{");
                    pw.print("}");
                    pw.flush();
                    pw.close();
                }
                InputStreamReader hashStream = new InputStreamReader((InputStream)new FileInputStream(hashFile), StandardCharsets.UTF_8);
                JSONObject data = (JSONObject)new JSONParser().parse((Reader)hashStream);
                hashStream.close();
                try {
                    JSONObject manifest = HTTPRequestUtils.getJSONResponse(VERSION_MANIFEST_URL);
                    if (manifest == null) {
                        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to fetch version_manifest from " + VERSION_MANIFEST_URL);
                    } else {
                        String mcVersion = HoloMobHealth.exactMinecraftVersion;
                        Object urlObj = ((JSONArray)manifest.get((Object)"versions")).stream().filter(each -> ((JSONObject)each).get((Object)"id").toString().equalsIgnoreCase(mcVersion)).map(each -> ((JSONObject)each).get((Object)"url").toString()).findFirst().orElse(null);
                        if (urlObj == null) {
                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to find " + mcVersion + " from version_manifest");
                        } else {
                            JSONObject versionData = HTTPRequestUtils.getJSONResponse(urlObj.toString());
                            if (versionData == null) {
                                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to fetch version data from " + urlObj);
                            } else {
                                block44: {
                                    String clientUrl = ((JSONObject)((JSONObject)versionData.get((Object)"downloads")).get((Object)"client")).get((Object)"url").toString();
                                    try (ZipArchiveInputStream zip = new ZipArchiveInputStream(new ByteArrayInputStream(HTTPRequestUtils.download(clientUrl)), StandardCharsets.UTF_8.toString(), false, true, true);){
                                        File fileToSave;
                                        JSONObject values;
                                        byte[] currentEntry;
                                        ZipArchiveEntry entry;
                                        String name;
                                        do {
                                            int n;
                                            if ((entry = zip.getNextZipEntry()) == null) {
                                                break block44;
                                            }
                                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                            byte[] byteChunk = new byte[4096];
                                            while ((n = zip.read(byteChunk)) > 0) {
                                                baos.write(byteChunk, 0, n);
                                            }
                                            currentEntry = baos.toByteArray();
                                        } while (!(name = entry.getName().toLowerCase()).matches("^.*assets/minecraft/lang/en_us.(json|lang)$"));
                                        String enUsFileHash = HashUtils.createSha1String(new ByteArrayInputStream(currentEntry));
                                        String enUsExtension = name.substring(name.indexOf(".") + 1);
                                        if (data.containsKey((Object)"en_us")) {
                                            values = (JSONObject)data.get((Object)"en_us");
                                            fileToSave = new File(langFileFolder, "en_us." + enUsExtension);
                                            if (!values.get((Object)"hash").toString().equals(enUsFileHash) || !fileToSave.exists()) {
                                                values.put((Object)"hash", (Object)enUsFileHash);
                                                if (fileToSave.exists()) {
                                                    fileToSave.delete();
                                                }
                                                FileUtils.copy(new ByteArrayInputStream(currentEntry), fileToSave);
                                            }
                                        } else {
                                            values = new JSONObject();
                                            values.put((Object)"hash", (Object)enUsFileHash);
                                            fileToSave = new File(langFileFolder, "en_us." + enUsExtension);
                                            if (fileToSave.exists()) {
                                                fileToSave.delete();
                                            }
                                            FileUtils.copy(new ByteArrayInputStream(currentEntry), fileToSave);
                                            data.put((Object)"en_us", (Object)values);
                                        }
                                        zip.close();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                String indexUrl = ((JSONObject)versionData.get((Object)"assetIndex")).get((Object)"url").toString();
                                JSONObject assets = HTTPRequestUtils.getJSONResponse(indexUrl);
                                if (assets == null) {
                                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to fetch assets data from " + indexUrl);
                                } else {
                                    JSONObject objects = (JSONObject)assets.get((Object)"objects");
                                    for (Object obj : objects.keySet()) {
                                        File fileToSave;
                                        JSONObject values;
                                        key = obj.toString().toLowerCase();
                                        if (!key.matches("^minecraft\\/lang\\/" + language + ".(json|lang)$")) continue;
                                        String lang = key.substring(key.lastIndexOf("/") + 1, key.indexOf("."));
                                        String extension = key.substring(key.indexOf(".") + 1);
                                        String hash = ((JSONObject)objects.get((Object)obj.toString())).get((Object)"hash").toString();
                                        String fileUrl = RESOURCES_URL + hash.substring(0, 2) + "/" + hash;
                                        if (data.containsKey((Object)lang)) {
                                            values = (JSONObject)data.get((Object)lang);
                                            fileToSave = new File(langFileFolder, lang + "." + extension);
                                            if (values.get((Object)"hash").toString().equals(hash) && fileToSave.exists()) continue;
                                            values.put((Object)"hash", (Object)hash);
                                            if (fileToSave.exists()) {
                                                fileToSave.delete();
                                            }
                                            if (HTTPRequestUtils.download(fileToSave, fileUrl)) continue;
                                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to download " + key + " from " + fileUrl);
                                            continue;
                                        }
                                        values = new JSONObject();
                                        values.put((Object)"hash", (Object)hash);
                                        fileToSave = new File(langFileFolder, lang + "." + extension);
                                        if (fileToSave.exists()) {
                                            fileToSave.delete();
                                        }
                                        if (!HTTPRequestUtils.download(fileToSave, fileUrl)) {
                                            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to download " + key + " from " + fileUrl);
                                        }
                                        data.put((Object)lang, (Object)values);
                                    }
                                }
                            }
                        }
                    }
                    JsonUtils.saveToFilePretty(data, hashFile);
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to download latest languages files from Mojang");
                    e.printStackTrace();
                }
                String langRegex = "(en_us|" + language + ")";
                for (File file : langFileFolder.listFiles()) {
                    try {
                        if (file.getName().matches("^" + langRegex + ".json$")) {
                            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                            JSONObject json = (JSONObject)new JSONParser().parse((Reader)reader);
                            reader.close();
                            HashMap<String, String> mapping = new HashMap<String, String>();
                            for (Object obj : json.keySet()) {
                                try {
                                    key = (String)obj;
                                    mapping.put(key, (String)json.get((Object)key));
                                }
                                catch (Exception exception) {}
                            }
                            translations.put(file.getName().substring(0, file.getName().lastIndexOf(".")), mapping);
                            continue;
                        }
                        if (!file.getName().matches("^" + langRegex + ".lang$")) continue;
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
                        HashMap mapping = new HashMap();
                        br.lines().forEach(line -> {
                            if (line.contains("=")) {
                                mapping.put(line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1));
                            }
                        });
                        br.close();
                        translations.put(file.getName().substring(0, file.getName().lastIndexOf(".")), mapping);
                    }
                    catch (Exception e) {
                        Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to load " + file.getName());
                        e.printStackTrace();
                    }
                }
                if (translations.isEmpty()) {
                    throw new RuntimeException();
                }
                Bukkit.getConsoleSender().sendMessage(ChatColor.GREEN + "[HoloMobHealth] Loaded all " + translations.size() + " languages!");
            }
            catch (Exception e) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] Unable to setup languages");
                e.printStackTrace();
            }
            lock.set(false);
        });
    }

    public static String getTranslationKey(Entity entity) {
        String result = LanguageUtils.getTranslationKeyOrNull(entity);
        return result == null ? WordUtils.capitalizeFully(EntityTypeUtils.getEntityType(entity).name().toLowerCase().replace("_", " ")) : result;
    }

    public static String getTranslationKeyOrNull(Entity entity) {
        try {
            if (HoloMobHealth.version.isLegacy()) {
                return LanguageUtils.getLegacyTranslationKey(entity);
            }
            return LanguageUtils.getModernTranslationKey(entity);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String getLegacyTranslationKey(Entity entity) {
        try {
            String str = NMS.getInstance().getEntityTranslationKey(entity);
            if (str == null) {
                return null;
            }
            EntityType type = EntityTypeUtils.getEntityType(entity);
            if (type.equals((Object)EntityType.VILLAGER)) {
                Villager villager = (Villager)entity;
                return str.substring(0, str.lastIndexOf(".")) + "." + villager.getProfession().toString().toLowerCase();
            }
            return str;
        }
        catch (NullPointerException str) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getModernTranslationKey(Entity entity) {
        EntityType type = EntityTypeUtils.getEntityType(entity);
        String path = NMS.getInstance().getEntityTranslationKey(entity);
        path = TropicalFishUtils.addTropicalFishType(entity, path);
        if (type.equals((Object)EntityType.VILLAGER)) {
            Villager villager = (Villager)entity;
            if (HoloMobHealth.version.equals((Object)MCVersion.V1_13) || HoloMobHealth.version.equals((Object)MCVersion.V1_13_1)) {
                switch (villager.getProfession()) {
                    case TOOLSMITH: {
                        path = path + ".tool_smith";
                        break;
                    }
                    case WEAPONSMITH: {
                        path = path + ".weapon_smith";
                        break;
                    }
                    default: {
                        path = path + "." + villager.getProfession().toString().toLowerCase();
                        break;
                    }
                }
            } else {
                path = villager.getProfession() instanceof Enum ? path + "." + villager.getProfession().toString().toLowerCase() : path + "." + villager.getProfession().getKey().getKey();
            }
        }
        return path;
    }

    public static Set<String> getSupportedLanguages() {
        return Collections.unmodifiableSet(translations.keySet());
    }

    public static String getTranslation(String translationKey, String language) {
        try {
            if (HoloMobHealth.version.isLegacy() && translationKey.equals("item.skull.player.name")) {
                return "%s's Head";
            }
            Map<String, String> mapping = translations.get(language);
            if (language.equals("en_us")) {
                return mapping.getOrDefault(translationKey, translationKey);
            }
            return mapping == null ? LanguageUtils.getTranslation(translationKey, "en_us") : mapping.getOrDefault(translationKey, LanguageUtils.getTranslation(translationKey, "en_us"));
        }
        catch (Exception e) {
            return translationKey;
        }
    }

    public static Component convert(Component component, String language) {
        component = ComponentFlattening.flatten(component);
        ArrayList<Component> children = new ArrayList<Component>(component.children());
        for (int i = 0; i < children.size(); ++i) {
            Component current = (Component)children.get(i);
            if (!(current instanceof TranslatableComponent)) continue;
            TranslatableComponent trans = (TranslatableComponent)current;
            Component translated = Component.text(LanguageUtils.getTranslation(trans.key(), language)).style(trans.style());
            for (TranslationArgument arg : trans.arguments()) {
                translated = translated.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%s").replacement(LanguageUtils.convert(arg.asComponent(), language)).once().build());
            }
            children.set(i, translated);
        }
        return ComponentCompacting.optimize(component.children(children));
    }
}

