/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.registries;

import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.utils.CustomStringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;

public class DisplayTextCacher {
    private static final Map<String, HealthFormatData> decimalFormatMapping = new ConcurrentHashMap<String, HealthFormatData>();
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> cacheDecimalFormat(List<String> lines) {
        Object object = lock;
        synchronized (object) {
            ArrayList<String> cachedList = new ArrayList<String>(lines.size());
            for (String text : lines) {
                cachedList.add(DisplayTextCacher.cacheDecimalFormat(text));
            }
            return cachedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cacheDecimalFormat(String line) {
        Object object = lock;
        synchronized (object) {
            Matcher matcher;
            String text = line;
            while ((matcher = Pattern.compile("\\{(Health|MaxHealth|PercentageHealth|Indicator)_.+?\\}").matcher(text)).find()) {
                int start = matcher.start();
                int end = matcher.end();
                String matched = matcher.group();
                try {
                    DecimalFormat formatter = new DecimalFormat(matched.substring(matched.indexOf("_") + 1, matched.lastIndexOf("}")));
                    formatter.setRoundingMode(HoloMobHealth.roundingMode);
                    String placeholder = "%D%" + counter.getAndIncrement() + "%F%";
                    decimalFormatMapping.put(placeholder, new HealthFormatData(formatter, HealthType.fromName(matched.substring(matched.indexOf("{") + 1, matched.indexOf("_")))));
                    text = CustomStringUtils.replaceFromTo(text, start, end, placeholder);
                }
                catch (Exception e) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] There is a syntax error with your placeholders in your mob name field in the config! (\"" + matched + "\")");
                    break;
                }
            }
            return text;
        }
    }

    public static Map<String, HealthFormatData> getDecimalFormatMapping() {
        return Collections.unmodifiableMap(decimalFormatMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDecimalFormatMappings() {
        Object object = lock;
        synchronized (object) {
            decimalFormatMapping.clear();
            counter.set(0);
        }
    }

    public static class HealthFormatData {
        private final DecimalFormat format;
        private final HealthType type;

        public HealthFormatData(DecimalFormat format, HealthType type) {
            this.format = format;
            this.type = type;
        }

        public DecimalFormat getFormatter() {
            return this.format;
        }

        public HealthType getType() {
            return this.type;
        }
    }

    public static enum HealthType {
        HEALTH("Health"),
        MAXHEALTH("MaxHealth"),
        PERCENTAGEHEALTH("PercentageHealth"),
        INDICATOR("Indicator");

        private final String name;

        public static HealthType fromName(String name) {
            for (HealthType type : HealthType.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        private HealthType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

