/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.protocol;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.PacketSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class EntityMetadata {
    public static void updatePlayer(Player player) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        int range = HoloMobHealth.getUpdateRange(player.getWorld());
        for (Entity entity : player.getNearbyEntities((double)range, (double)range, (double)range)) {
            EntityMetadata.updateEntity(players, entity);
        }
    }

    public static void updateEntity(Player player, Entity entity) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.add(player);
        EntityMetadata.updateEntity(players, entity);
    }

    public static void updateEntity(Collection<? extends Player> players, Entity entity) {
        if (!EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) {
            return;
        }
        if (!entity.isValid()) {
            return;
        }
        PacketContainer packet = NMS.getInstance().createUpdateEntityPacket(entity);
        Bukkit.getScheduler().runTaskAsynchronously(HoloMobHealth.plugin, () -> {
            for (Player player : players) {
                if (!player.getWorld().equals((Object)entity.getWorld())) continue;
                try {
                    PacketSender.sendServerPacket(player, packet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void sendMetadataPacket(Entity entity, Component entityNameComponent, boolean visible, List<Player> players, boolean quiet) {
        Bukkit.getScheduler().runTask(HoloMobHealth.plugin, () -> {
            PacketContainer packet = NMS.getInstance().createUpdateEntityMetadataPacket(entity, entityNameComponent, visible);
            for (Player player : players) {
                if (!player.hasPermission("holomobhealth.use")) continue;
                PacketSender.sendServerPacket(player, packet, !quiet);
            }
        });
    }
}

