/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.AllYamlLines;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Backwards;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BuiltComment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Concatenated;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.FirstCommentFound;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadComment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Skip;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlLine;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ReadPlainScalar
extends BaseScalar {
    private static final Pattern QUOTED_LITERAL_MAP_SEQ = Pattern.compile("^([ ]*(-[ ]+)(('(?:[^'\\\\]|\\\\.)*')|(\"(?:[^\"\\\\]|\\\\.)*\"))|((?:(?:[^>]*?(?:(?:'[^'\"]*?(?:')|\"[^'\"]*?(?:\"))[^>]*?)*)|(?:)):[ ]+(.*))|(-[ ]+(.*)))$");
    private static final int QUOTED_LITERAL_GROUP = 3;
    private static final int MAPPING_GROUP = 7;
    private static final int SEQUENCE_GROUP = 9;
    private final AllYamlLines all;
    private final YamlLine scalar;

    ReadPlainScalar(AllYamlLines all, YamlLine scalar) {
        this.all = all;
        this.scalar = scalar;
    }

    @Override
    public String value() {
        String value = this.scalar.trimmed();
        Matcher matcher = this.escapedSequenceScalar(this.scalar);
        if (matcher.matches()) {
            if (matcher.group(3) != null) {
                value = matcher.group(3);
            } else if (matcher.group(7) != null) {
                value = matcher.group(7).trim();
            } else if (matcher.group(9) != null) {
                value = matcher.group(9).trim();
            }
        }
        if ("null".equals(value)) {
            return null;
        }
        return this.unescape(value);
    }

    @Override
    public Comment comment() {
        Concatenated comment;
        if (this.scalar instanceof YamlLine.NullYamlLine) {
            comment = new Concatenated(new BuiltComment(this, ""), new BuiltComment(this, ""));
        } else {
            int lineNumber = this.scalar.number();
            comment = new Concatenated(new ReadComment(new Backwards(new FirstCommentFound(new Backwards(new Skip(this.all, line -> line.number() >= lineNumber, line -> line.trimmed().startsWith("..."), line -> line.trimmed().startsWith("%"), line -> line.trimmed().startsWith("!!"))), false)), this), new ReadComment(new Skip(this.all, line -> line.number() != lineNumber), this));
        }
        return comment;
    }

    private String unescape(String value) {
        String unescaped = value == null || value.length() < 2 ? value : (value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : (value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value));
        return unescaped;
    }

    private Matcher escapedSequenceScalar(YamlLine dashLine) {
        String trimmed = dashLine.trimmed();
        return QUOTED_LITERAL_MAP_SEQ.matcher(trimmed);
    }
}

