/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.Commands;
import com.loohp.holomobhealth.api.HoloMobHealthAPI;
import com.loohp.holomobhealth.config.Config;
import com.loohp.holomobhealth.database.Database;
import com.loohp.holomobhealth.debug.Debug;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.YamlConfiguration;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.holomobhealth.listeners.Events;
import com.loohp.holomobhealth.metrics.Charts;
import com.loohp.holomobhealth.metrics.Metrics;
import com.loohp.holomobhealth.modules.ArmorstandDisplay;
import com.loohp.holomobhealth.modules.DamageIndicator;
import com.loohp.holomobhealth.modules.NameTagDisplay;
import com.loohp.holomobhealth.modules.RangeModule;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.placeholderapi.Placeholders;
import com.loohp.holomobhealth.protocol.ArmorStandPacket;
import com.loohp.holomobhealth.registries.CustomPlaceholderScripts;
import com.loohp.holomobhealth.registries.DisplayTextCacher;
import com.loohp.holomobhealth.updater.Updater;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.JarUtils;
import com.loohp.holomobhealth.utils.LanguageUtils;
import com.loohp.holomobhealth.utils.LegacyPlaceholdersConverter;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.ModelEngineUtils;
import com.loohp.holomobhealth.utils.PacketSender;
import com.loohp.holomobhealth.utils.WorldGuardUtils;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HoloMobHealth
extends JavaPlugin {
    public static final int BSTATS_PLUGIN_ID = 6749;
    public static final String CONFIG_ID = "config";
    public static Plugin plugin = null;
    public static String exactMinecraftVersion;
    public static MCVersion version;
    public static ProtocolManager protocolManager;
    public static int activeShowHealthTaskID;
    public static RoundingMode roundingMode;
    public static List<String> displayText;
    public static int heartScale;
    public static boolean dynamicScale;
    public static Set<Player> playersEnabled;
    public static String healthyColor;
    public static String halfColor;
    public static String lowColor;
    public static String healthyChar;
    public static String halfChar;
    public static String emptyChar;
    public static boolean alwaysShow;
    public static boolean applyToNamed;
    public static String reloadPluginMessage;
    public static String noPermissionMessage;
    public static String playersOnlyMessage;
    public static String playersNotFoundMessage;
    public static String toggleDisplayOnMessage;
    public static String toggleDisplayOffMessage;
    public static Set<EntityType> disabledMobTypes;
    public static Set<String> disabledMobNamesAbsolute;
    public static List<String> disabledMobNamesContains;
    public static Set<String> disabledWorlds;
    public static boolean useAlterHealth;
    public static int altHealthDisplayTime;
    public static boolean altOnlyPlayer;
    public static Map<UUID, Long> altShowHealth;
    public static boolean idleUse;
    public static List<String> idleDisplayText;
    public static boolean useDamageIndicator;
    public static boolean damageIndicatorPlayerTriggered;
    public static int damageIndicatorVisibleRange;
    public static int damageIndicatorTimeout;
    public static boolean damageIndicatorDamageEnabled;
    public static boolean damageIndicatorDamageAnimation;
    public static String damageIndicatorDamageText;
    public static double damageIndicatorDamageY;
    public static double damageIndicatorDamageMinimum;
    public static boolean damageIndicatorRegenEnabled;
    public static boolean damageIndicatorRegenAnimation;
    public static String damageIndicatorRegenText;
    public static double damageIndicatorRegenY;
    public static double damageIndicatorRegenMinimum;
    public static boolean placeholderAPIHook;
    public static boolean mythicHook;
    public static boolean showMythicMobs;
    public static boolean useMythicMobCustomNamesFirst;
    public static boolean citizensHook;
    public static boolean showCitizens;
    public static boolean shopkeepersHook;
    public static boolean showShopkeepers;
    public static boolean myPetHook;
    public static boolean showMyPet;
    public static boolean ultimateStackerHook;
    public static boolean roseStackerHook;
    public static boolean modelEngineHook;
    public static boolean worldGuardHook;
    public static boolean armorStandMode;
    public static int armorStandYOffset;
    public static HashMap<EntityType, Integer> specialTypeOffset;
    public static HashMap<String, Integer> specialNameOffset;
    public static boolean rangeEnabled;
    public static boolean updaterEnabled;
    public static String language;
    public static boolean sendPacketsOnMainThread;

    public static YamlConfiguration getConfiguration() {
        return Config.getConfig(CONFIG_ID).getConfiguration();
    }

    public static boolean isPluginEnabled(String name) {
        return HoloMobHealth.isPluginEnabled(name, true);
    }

    public static boolean isPluginEnabled(String name, boolean checkRunning) {
        Plugin plugin = Bukkit.getPluginManager().getPlugin(name);
        return plugin != null && (!checkRunning || plugin.isEnabled());
    }

    public static void loadConfig() {
        Config config = Config.getConfig(CONFIG_ID);
        config.reload();
        rangeEnabled = config.getConfiguration().getBoolean("Options.Range.Use");
        roundingMode = RoundingMode.valueOf(config.getConfiguration().getString("Options.NumberRounding").toUpperCase());
        specialNameOffset.clear();
        specialTypeOffset.clear();
        displayText = DisplayTextCacher.cacheDecimalFormat(config.getConfiguration().getStringList("Display.Text"));
        heartScale = config.getConfiguration().getInt("Display.ScaledSymbolSettings.Scale");
        dynamicScale = config.getConfiguration().getBoolean("Display.ScaledSymbolSettings.DynamicScale");
        healthyColor = config.getConfiguration().getString("Display.DynamicColorSettings.HealthyColor");
        halfColor = config.getConfiguration().getString("Display.DynamicColorSettings.HalfColor");
        lowColor = config.getConfiguration().getString("Display.DynamicColorSettings.LowColor");
        healthyChar = config.getConfiguration().getString("Display.ScaledSymbolSettings.HealthyChar");
        halfChar = config.getConfiguration().getString("Display.ScaledSymbolSettings.HalfChar");
        emptyChar = config.getConfiguration().getString("Display.ScaledSymbolSettings.EmptyChar");
        alwaysShow = config.getConfiguration().getBoolean("Options.AlwaysShow");
        applyToNamed = config.getConfiguration().getBoolean("Options.ApplyToNamed");
        reloadPluginMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.ReloadPlugin"));
        noPermissionMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.NoPermission"));
        playersOnlyMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PlayersOnly"));
        playersNotFoundMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.PlayerNotFound"));
        toggleDisplayOnMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.ToggleDisplayOn"));
        toggleDisplayOffMessage = ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("Messages.ToggleDisplayOff"));
        List<String> types = config.getConfiguration().getStringList("Options.DisabledMobTypes");
        for (String string : types) {
            if (version.isLegacy()) {
                disabledMobTypes.add(EntityType.fromName((String)string.toUpperCase()));
                continue;
            }
            disabledMobTypes.add(EntityType.valueOf((String)string.toUpperCase()));
        }
        disabledMobNamesAbsolute = new HashSet<String>(config.getConfiguration().getStringList("Options.DisabledMobNamesAbsolute"));
        disabledMobNamesContains = config.getConfiguration().getStringList("Options.DisabledMobNamesContains");
        disabledWorlds = new HashSet<String>(config.getConfiguration().getStringList("Options.DisabledWorlds"));
        useAlterHealth = config.getConfiguration().getBoolean("Options.DynamicHealthDisplay.Use");
        altHealthDisplayTime = config.getConfiguration().getInt("Options.DynamicHealthDisplay.Timeout");
        altOnlyPlayer = config.getConfiguration().getBoolean("Options.DynamicHealthDisplay.OnlyPlayerTrigger");
        idleUse = config.getConfiguration().getBoolean("Options.DynamicHealthDisplay.IdleDisplay.Use");
        idleDisplayText = DisplayTextCacher.cacheDecimalFormat(config.getConfiguration().getStringList("Options.DynamicHealthDisplay.IdleDisplay.Text"));
        armorStandMode = config.getConfiguration().getBoolean("Options.MultiLine.Enable");
        armorStandYOffset = config.getConfiguration().getInt("Options.MultiLine.MasterYOffset");
        List<String> armorStandSpecial = config.getConfiguration().getStringList("Options.MultiLine.Special");
        for (String cases : armorStandSpecial) {
            int offset = Integer.parseInt(cases.substring(cases.lastIndexOf(":") + 1));
            switch (cases.substring(0, cases.indexOf(":")).toLowerCase()) {
                case "name": {
                    String regex = cases.substring(cases.indexOf(":") + 1, cases.lastIndexOf(":"));
                    specialNameOffset.put(regex, offset);
                    break;
                }
                case "type": {
                    String type = cases.substring(cases.indexOf(":") + 1, cases.lastIndexOf(":"));
                    EntityType entitytype = EntityType.valueOf((String)type.toUpperCase());
                    specialTypeOffset.put(entitytype, offset);
                }
            }
        }
        if (activeShowHealthTaskID >= 0) {
            Bukkit.getScheduler().cancelTask(activeShowHealthTaskID);
        }
        protocolManager.removePacketListeners(plugin);
        if (!armorStandMode || version.isOld() || version.equals((Object)MCVersion.V1_9) || version.equals((Object)MCVersion.V1_9_4)) {
            NameTagDisplay.entityMetadataPacketListener();
            if (armorStandMode) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[HoloMobHealth] Multi-line is not supported on this version of Minecraft. Using Single line instead!");
                armorStandMode = false;
            }
        } else {
            ArmorstandDisplay.entityMetadataPacketListener();
            if (modelEngineHook) {
                Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, () -> ModelEngineUtils.updateModelEngineNametags(), 0L, 10L);
            }
        }
        useDamageIndicator = config.getConfiguration().getBoolean("DamageIndicator.Enabled");
        damageIndicatorVisibleRange = config.getConfiguration().getInt("DamageIndicator.VisibleRange");
        damageIndicatorTimeout = config.getConfiguration().getInt("DamageIndicator.Timeout");
        damageIndicatorPlayerTriggered = config.getConfiguration().getBoolean("DamageIndicator.OnlyPlayerTriggered");
        damageIndicatorDamageEnabled = config.getConfiguration().getBoolean("DamageIndicator.Damage.Enabled");
        damageIndicatorDamageAnimation = config.getConfiguration().getBoolean("DamageIndicator.Damage.Animation");
        damageIndicatorDamageText = DisplayTextCacher.cacheDecimalFormat(ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("DamageIndicator.Damage.HoloText")));
        damageIndicatorDamageY = config.getConfiguration().getDouble("DamageIndicator.Damage.Y-Offset");
        damageIndicatorDamageMinimum = config.getConfiguration().getDouble("DamageIndicator.Damage.Minimum");
        damageIndicatorRegenEnabled = config.getConfiguration().getBoolean("DamageIndicator.Regen.Enabled");
        damageIndicatorRegenAnimation = config.getConfiguration().getBoolean("DamageIndicator.Regen.Animation");
        damageIndicatorRegenText = DisplayTextCacher.cacheDecimalFormat(ChatColorUtils.translateAlternateColorCodes('&', config.getConfiguration().getString("DamageIndicator.Regen.HoloText")));
        damageIndicatorRegenY = config.getConfiguration().getDouble("DamageIndicator.Regen.Y-Offset");
        damageIndicatorRegenMinimum = config.getConfiguration().getDouble("DamageIndicator.Regen.Minimum");
        showCitizens = config.getConfiguration().getBoolean("Hooks.Citizens.ShowNPCMobHealth");
        showMythicMobs = config.getConfiguration().getBoolean("Hooks.MythicMobs.ShowMythicMobsHealth");
        useMythicMobCustomNamesFirst = config.getConfiguration().getBoolean("Hooks.MythicMobs.UseMythicMobCustomNamesFirst");
        showShopkeepers = config.getConfiguration().getBoolean("Hooks.Shopkeepers.ShowShopkeepersHealth");
        showMyPet = config.getConfiguration().getBoolean("Hooks.MyPet.ShowMyPetHealth");
        updaterEnabled = config.getConfiguration().getBoolean("Updater.Enable");
        language = config.getConfiguration().getString("Options.Language");
        sendPacketsOnMainThread = config.getConfiguration().getBoolean("Settings.SendPacketsOnMainThread");
        CustomPlaceholderScripts.clearScripts();
        CustomPlaceholderScripts.loadScriptsFromFolder(new File(plugin.getDataFolder(), "placeholder_scripts"));
        boolean bl = config.getConfiguration().getBoolean("CustomPlaceholderScript.SilentClassNotFound");
        for (String key : config.getConfiguration().getConfigurationSection("CustomPlaceholderScript.AdditionClasses").getValues(false).keySet()) {
            String classPath = config.getConfiguration().getString("CustomPlaceholderScript.AdditionClasses." + key);
            try {
                Class<?> clazz = Class.forName(classPath);
                HoloMobHealthAPI.registerClassToCustomPlaceholderScript(key, clazz);
            }
            catch (ClassNotFoundException e) {
                if (bl) continue;
                e.printStackTrace();
            }
        }
        LanguageUtils.loadTranslations(language);
    }

    public static int getUpdateRange(World world) {
        if (version.isOld()) {
            return 80;
        }
        if (version.isNewerOrEqualTo(MCVersion.V1_18)) {
            return Math.min(Math.min(world.getViewDistance() << 4, world.getSimulationDistance() << 4), 80);
        }
        if (version.isNewerOrEqualTo(MCVersion.V1_16)) {
            return Math.min((world.getViewDistance() << 4) / 2, 80);
        }
        return Math.min((Bukkit.getViewDistance() << 4) / 2, 80);
    }

    public static void sendMessage(CommandSender sender, Component component) {
        block5: {
            if (version.isLegacyRGB()) {
                try {
                    sender.spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.colorDownsamplingGson().serialize(component))));
                }
                catch (Throwable e) {
                    if (sender instanceof Player) {
                        ((Player)sender).spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.colorDownsamplingGson().serialize(component))));
                        break block5;
                    }
                    sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(component));
                }
            } else {
                sender.spigot().sendMessage(ComponentSerializer.parse((String)((String)GsonComponentSerializer.gson().serialize(component))));
            }
        }
    }

    public void onLoad() {
        String version;
        if (HoloMobHealth.isPluginEnabled("WorldGuard", false) && (version = this.getServer().getPluginManager().getPlugin("WorldGuard").getDescription().getVersion()).startsWith("7.")) {
            this.getServer().getLogger().info("[HoloMobHealth] Registering WorldGuard State Flags...");
            WorldGuardUtils.registerFlag();
            worldGuardHook = true;
        }
    }

    public void onEnable() {
        plugin = this;
        exactMinecraftVersion = Bukkit.getVersion().substring(Bukkit.getVersion().indexOf("(") + 5, Bukkit.getVersion().indexOf(")"));
        version = MCVersion.resolve();
        this.getServer().getPluginManager().registerEvents((Listener)new Debug(), (Plugin)this);
        if (version.isNewerOrEqualTo(MCVersion.V1_11)) {
            this.getServer().getPluginManager().registerEvents((Listener)new DamageIndicator(), (Plugin)this);
        }
        Metrics metrics = new Metrics((Plugin)this, 6749);
        Charts.setup(metrics);
        if (!version.isSupported()) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "This version of minecraft is unsupported!");
        }
        protocolManager = ProtocolLibrary.getProtocolManager();
        this.getServer().getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        try {
            Config.loadConfig(CONFIG_ID, new File(this.getDataFolder(), "config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("config.yml"), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            JarUtils.copyFolderFromJar("placeholder_scripts", this.getDataFolder(), JarUtils.CopyOption.COPY_IF_NOT_EXIST);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        List<String> lines = HoloMobHealth.getConfiguration().getStringList("Display.Text");
        if (LegacyPlaceholdersConverter.getLegacyPlaceholderSet().stream().anyMatch(each -> lines.stream().anyMatch(line -> line.contains((CharSequence)each)))) {
            LegacyPlaceholdersConverter.convert();
        }
        HoloMobHealth.loadConfig();
        if (armorStandMode) {
            this.getServer().getPluginManager().registerEvents((Listener)new ArmorStandPacket(), plugin);
            ArmorStandPacket.update();
        }
        this.getCommand("holomobhealth").setExecutor((CommandExecutor)new Commands());
        if (HoloMobHealth.isPluginEnabled("Citizens")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into Citizens!");
            citizensHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("MythicMobs")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into MythicMobs!");
            mythicHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("Shopkeepers")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into Shopkeepers!");
            shopkeepersHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("MyPet")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into MyPet!");
            myPetHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("UltimateStacker")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into UltimateStacker!");
            ultimateStackerHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("PlaceholderAPI")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into PlaceholderAPI!");
            placeholderAPIHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("UltimateStacker")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into UltimateStacker!");
            ultimateStackerHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("RoseStacker")) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into RoseStacker!");
            roseStackerHook = true;
        }
        if (HoloMobHealth.isPluginEnabled("ModelEngine", false)) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into ModelEngine!");
            modelEngineHook = true;
        }
        if (worldGuardHook) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.AQUA + "[HoloMobHealth] Hooked into WorldGuard! (v7)");
        }
        if (rangeEnabled) {
            RangeModule.reloadNumbers();
            RangeModule.run();
        }
        Database.setup();
        if (updaterEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new Updater(), (Plugin)this);
        }
        ArmorstandDisplay.run();
        if (HoloMobHealth.isPluginEnabled("PlaceholderAPI")) {
            new Placeholders().register();
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + "[HoloMobHealth] HoloMobHealth has been Enabled!");
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Bukkit.getScheduler().runTaskAsynchronously(plugin, () -> {
                    if (!Database.playerExists(player)) {
                        Database.createPlayer(player);
                    }
                    Database.loadPlayer(player);
                });
            }
            if (armorStandMode) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    ArmorStandPacket.playerStatus.put(player, new ConcurrentHashMap());
                }
            }
        });
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this, () -> {
            Updater.UpdaterResponse version;
            if (updaterEnabled && !(version = Updater.checkUpdate()).getResult().equals("latest")) {
                Updater.sendUpdateMessage((CommandSender)Bukkit.getConsoleSender(), version.getResult(), version.getSpigotPluginId());
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.hasPermission("holomobhealth.update")) continue;
                    Updater.sendUpdateMessage((CommandSender)player, version.getResult(), version.getSpigotPluginId());
                }
            }
        }, 100L);
    }

    public void onDisable() {
        if (!Bukkit.getOnlinePlayers().isEmpty() && armorStandMode) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.YELLOW + "[HoloMobHealth] Plugin reload detected, attempting to despawn all visual entities. If anything went wrong, please restart! (Reloads are always not recommended)");
            int[] entityIdArray = ArmorStandPacket.active.stream().mapToInt(each -> each.getEntityId()).toArray();
            PacketContainer[] packets = NMS.getInstance().createEntityDestroyPacket(entityIdArray);
            PacketSender.sendServerPackets((Collection<? extends Player>)Bukkit.getOnlinePlayers(), packets);
        }
        this.getServer().getConsoleSender().sendMessage(ChatColor.RED + "[HoloMobHealth] HoloMobHealth has been Disabled!");
    }

    static {
        activeShowHealthTaskID = -1;
        roundingMode = RoundingMode.UP;
        displayText = new ArrayList<String>();
        heartScale = 10;
        dynamicScale = true;
        playersEnabled = ConcurrentHashMap.newKeySet();
        healthyColor = "&a";
        halfColor = "&e";
        lowColor = "&c";
        healthyChar = "&c\u00e2\u009d\u00a4";
        halfChar = "&e\u00e2\u009d\u00a4";
        emptyChar = "&7\u00e2\u009d\u00a4";
        alwaysShow = true;
        applyToNamed = false;
        reloadPluginMessage = "";
        noPermissionMessage = "";
        playersOnlyMessage = "";
        playersNotFoundMessage = "";
        toggleDisplayOnMessage = "";
        toggleDisplayOffMessage = "";
        disabledMobTypes = new HashSet<EntityType>();
        disabledMobNamesAbsolute = new HashSet<String>();
        disabledMobNamesContains = new ArrayList<String>();
        disabledWorlds = new HashSet<String>();
        useAlterHealth = false;
        altHealthDisplayTime = 3;
        altOnlyPlayer = false;
        altShowHealth = new ConcurrentHashMap<UUID, Long>();
        idleUse = false;
        idleDisplayText = new ArrayList<String>();
        useDamageIndicator = true;
        damageIndicatorPlayerTriggered = false;
        damageIndicatorVisibleRange = 64;
        damageIndicatorTimeout = 40;
        damageIndicatorDamageEnabled = true;
        damageIndicatorDamageAnimation = true;
        damageIndicatorDamageText = "";
        damageIndicatorDamageY = 0.0;
        damageIndicatorDamageMinimum = 0.5;
        damageIndicatorRegenEnabled = true;
        damageIndicatorRegenAnimation = true;
        damageIndicatorRegenText = "";
        damageIndicatorRegenY = 0.0;
        damageIndicatorRegenMinimum = 0.5;
        placeholderAPIHook = false;
        mythicHook = false;
        showMythicMobs = true;
        useMythicMobCustomNamesFirst = true;
        citizensHook = false;
        showCitizens = true;
        shopkeepersHook = false;
        showShopkeepers = true;
        myPetHook = false;
        showMyPet = true;
        ultimateStackerHook = false;
        roseStackerHook = false;
        modelEngineHook = false;
        worldGuardHook = false;
        armorStandMode = false;
        armorStandYOffset = 0;
        specialTypeOffset = new HashMap();
        specialNameOffset = new HashMap();
        rangeEnabled = false;
        updaterEnabled = true;
        language = "en_us";
        sendPacketsOnMainThread = false;
    }
}

