/*
 * Decompiled with CFR 0.152.
 */
package dev.kqmvs2.otherside;

import dev.kqmvs2.otherside.Otherside;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.EntityType;

public class OthersideConfig {
    private final Otherside plugin;
    private int defaultDespawnTime;
    private final HashMap<EntityType, Integer> mobTypeDespawnTimeMap = new HashMap();

    public OthersideConfig(Otherside plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        plugin.reloadConfig();
    }

    public void loadAndParseConfig() throws InvalidConfigurationException {
        String DEFAULT_DESPAWN_IMMUNITY_TIME_KEY = "default-despawn-immunity-time-seconds";
        String IMMUNITY_TIME_OVERRIDES_KEY = "despawn-immunity-time-overrides";
        this.plugin.reloadConfig();
        this.defaultDespawnTime = this.plugin.getConfig().getInt("default-despawn-immunity-time-seconds");
        ConfigurationSection despawnSection = this.plugin.getConfig().getConfigurationSection("despawn-immunity-time-overrides");
        boolean hasInvalidMobTypes = false;
        for (String entityTypeKey : despawnSection.getKeys(false)) {
            try {
                EntityType entityType = EntityType.valueOf((String)entityTypeKey.toUpperCase(Locale.ROOT).replace(" ", "_"));
                int despawnTimeSec = this.plugin.getConfig().getInt("despawn-immunity-time-overrides." + entityTypeKey);
                this.mobTypeDespawnTimeMap.put(entityType, despawnTimeSec);
            }
            catch (IllegalArgumentException ex) {
                this.plugin.getLogger().severe("Invalid mob type '" + entityTypeKey + "'");
                hasInvalidMobTypes = true;
            }
        }
        if (hasInvalidMobTypes) {
            throw new InvalidConfigurationException("Found invalid mob type");
        }
    }

    public int getDespawnSeconds(EntityType entityType) {
        return this.mobTypeDespawnTimeMap.getOrDefault(entityType, this.defaultDespawnTime);
    }
}

