/*
 * Decompiled with CFR 0.152.
 */
package dev.kqmvs2.otherside;

import dev.kqmvs2.otherside.Otherside;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.InvalidConfigurationException;

public class OthersideCommand
implements TabExecutor {
    Otherside plugin;

    public OthersideCommand(Otherside plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String USAGE_MSG = String.valueOf(ChatColor.YELLOW) + "Usage: /otherside reload";
        switch (args.length) {
            case 1: {
                if (!args[0].equals("reload")) break;
                this.doReloadSubcommand(sender);
                break;
            }
            default: {
                sender.sendMessage(USAGE_MSG);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("reload");
            return completions;
        }
        return null;
    }

    private void doReloadSubcommand(CommandSender sender) {
        String RELOADED_MSG = String.valueOf(ChatColor.GREEN) + "Configuration reloaded";
        String RELOAD_ERROR_MSG = String.valueOf(ChatColor.RED) + "Error reloading config: %s. Some changes may not have been applied, check the console for more details";
        try {
            this.plugin.getOthersideConfig().loadAndParseConfig();
            sender.sendMessage(RELOADED_MSG);
        }
        catch (InvalidConfigurationException ex) {
            sender.sendMessage(String.format(RELOAD_ERROR_MSG, ex.getMessage()));
            ex.printStackTrace();
        }
    }
}

